/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a test repository triggers operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestRepositoryTriggersResponse extends CodeCommitResponse implements
        ToCopyableBuilder<TestRepositoryTriggersResponse.Builder, TestRepositoryTriggersResponse> {
    private static final SdkField<List<String>> SUCCESSFUL_EXECUTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(TestRepositoryTriggersResponse::successfulExecutions))
            .setter(setter(Builder::successfulExecutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successfulExecutions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RepositoryTriggerExecutionFailure>> FAILED_EXECUTIONS_FIELD = SdkField
            .<List<RepositoryTriggerExecutionFailure>> builder(MarshallingType.LIST)
            .getter(getter(TestRepositoryTriggersResponse::failedExecutions))
            .setter(setter(Builder::failedExecutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedExecutions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RepositoryTriggerExecutionFailure> builder(MarshallingType.SDK_POJO)
                                            .constructor(RepositoryTriggerExecutionFailure::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFUL_EXECUTIONS_FIELD,
            FAILED_EXECUTIONS_FIELD));

    private final List<String> successfulExecutions;

    private final List<RepositoryTriggerExecutionFailure> failedExecutions;

    private TestRepositoryTriggersResponse(BuilderImpl builder) {
        super(builder);
        this.successfulExecutions = builder.successfulExecutions;
        this.failedExecutions = builder.failedExecutions;
    }

    /**
     * Returns true if the SuccessfulExecutions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSuccessfulExecutions() {
        return successfulExecutions != null && !(successfulExecutions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of triggers that were successfully tested. This list provides the names of the triggers that were
     * successfully tested, separated by commas.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSuccessfulExecutions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of triggers that were successfully tested. This list provides the names of the triggers that
     *         were successfully tested, separated by commas.
     */
    public List<String> successfulExecutions() {
        return successfulExecutions;
    }

    /**
     * Returns true if the FailedExecutions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasFailedExecutions() {
        return failedExecutions != null && !(failedExecutions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of triggers that were not tested. This list provides the names of the triggers that could not be tested,
     * separated by commas.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFailedExecutions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of triggers that were not tested. This list provides the names of the triggers that could not be
     *         tested, separated by commas.
     */
    public List<RepositoryTriggerExecutionFailure> failedExecutions() {
        return failedExecutions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(successfulExecutions());
        hashCode = 31 * hashCode + Objects.hashCode(failedExecutions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestRepositoryTriggersResponse)) {
            return false;
        }
        TestRepositoryTriggersResponse other = (TestRepositoryTriggersResponse) obj;
        return Objects.equals(successfulExecutions(), other.successfulExecutions())
                && Objects.equals(failedExecutions(), other.failedExecutions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TestRepositoryTriggersResponse").add("SuccessfulExecutions", successfulExecutions())
                .add("FailedExecutions", failedExecutions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "successfulExecutions":
            return Optional.ofNullable(clazz.cast(successfulExecutions()));
        case "failedExecutions":
            return Optional.ofNullable(clazz.cast(failedExecutions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestRepositoryTriggersResponse, T> g) {
        return obj -> g.apply((TestRepositoryTriggersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, TestRepositoryTriggersResponse> {
        /**
         * <p>
         * The list of triggers that were successfully tested. This list provides the names of the triggers that were
         * successfully tested, separated by commas.
         * </p>
         * 
         * @param successfulExecutions
         *        The list of triggers that were successfully tested. This list provides the names of the triggers that
         *        were successfully tested, separated by commas.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulExecutions(Collection<String> successfulExecutions);

        /**
         * <p>
         * The list of triggers that were successfully tested. This list provides the names of the triggers that were
         * successfully tested, separated by commas.
         * </p>
         * 
         * @param successfulExecutions
         *        The list of triggers that were successfully tested. This list provides the names of the triggers that
         *        were successfully tested, separated by commas.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulExecutions(String... successfulExecutions);

        /**
         * <p>
         * The list of triggers that were not tested. This list provides the names of the triggers that could not be
         * tested, separated by commas.
         * </p>
         * 
         * @param failedExecutions
         *        The list of triggers that were not tested. This list provides the names of the triggers that could not
         *        be tested, separated by commas.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedExecutions(Collection<RepositoryTriggerExecutionFailure> failedExecutions);

        /**
         * <p>
         * The list of triggers that were not tested. This list provides the names of the triggers that could not be
         * tested, separated by commas.
         * </p>
         * 
         * @param failedExecutions
         *        The list of triggers that were not tested. This list provides the names of the triggers that could not
         *        be tested, separated by commas.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedExecutions(RepositoryTriggerExecutionFailure... failedExecutions);

        /**
         * <p>
         * The list of triggers that were not tested. This list provides the names of the triggers that could not be
         * tested, separated by commas.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RepositoryTriggerExecutionFailure>.Builder}
         * avoiding the need to create one manually via {@link List<RepositoryTriggerExecutionFailure>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RepositoryTriggerExecutionFailure>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #failedExecutions(List<RepositoryTriggerExecutionFailure>)}.
         * 
         * @param failedExecutions
         *        a consumer that will call methods on {@link List<RepositoryTriggerExecutionFailure>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedExecutions(List<RepositoryTriggerExecutionFailure>)
         */
        Builder failedExecutions(Consumer<RepositoryTriggerExecutionFailure.Builder>... failedExecutions);
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private List<String> successfulExecutions = DefaultSdkAutoConstructList.getInstance();

        private List<RepositoryTriggerExecutionFailure> failedExecutions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TestRepositoryTriggersResponse model) {
            super(model);
            successfulExecutions(model.successfulExecutions);
            failedExecutions(model.failedExecutions);
        }

        public final Collection<String> getSuccessfulExecutions() {
            return successfulExecutions;
        }

        @Override
        public final Builder successfulExecutions(Collection<String> successfulExecutions) {
            this.successfulExecutions = RepositoryTriggerNameListCopier.copy(successfulExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulExecutions(String... successfulExecutions) {
            successfulExecutions(Arrays.asList(successfulExecutions));
            return this;
        }

        public final void setSuccessfulExecutions(Collection<String> successfulExecutions) {
            this.successfulExecutions = RepositoryTriggerNameListCopier.copy(successfulExecutions);
        }

        public final Collection<RepositoryTriggerExecutionFailure.Builder> getFailedExecutions() {
            return failedExecutions != null ? failedExecutions.stream().map(RepositoryTriggerExecutionFailure::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failedExecutions(Collection<RepositoryTriggerExecutionFailure> failedExecutions) {
            this.failedExecutions = RepositoryTriggerExecutionFailureListCopier.copy(failedExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedExecutions(RepositoryTriggerExecutionFailure... failedExecutions) {
            failedExecutions(Arrays.asList(failedExecutions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedExecutions(Consumer<RepositoryTriggerExecutionFailure.Builder>... failedExecutions) {
            failedExecutions(Stream.of(failedExecutions)
                    .map(c -> RepositoryTriggerExecutionFailure.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFailedExecutions(Collection<RepositoryTriggerExecutionFailure.BuilderImpl> failedExecutions) {
            this.failedExecutions = RepositoryTriggerExecutionFailureListCopier.copyFromBuilder(failedExecutions);
        }

        @Override
        public TestRepositoryTriggersResponse build() {
            return new TestRepositoryTriggersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
