/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.CodeCommitRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCommentReactionsRequest
extends CodeCommitRequest
implements ToCopyableBuilder<Builder, GetCommentReactionsRequest> {
    private static final SdkField<String> COMMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetCommentReactionsRequest.getter(GetCommentReactionsRequest::commentId)).setter(GetCommentReactionsRequest.setter(Builder::commentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commentId").build()}).build();
    private static final SdkField<String> REACTION_USER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetCommentReactionsRequest.getter(GetCommentReactionsRequest::reactionUserArn)).setter(GetCommentReactionsRequest.setter(Builder::reactionUserArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reactionUserArn").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetCommentReactionsRequest.getter(GetCommentReactionsRequest::nextToken)).setter(GetCommentReactionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(GetCommentReactionsRequest.getter(GetCommentReactionsRequest::maxResults)).setter(GetCommentReactionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMENT_ID_FIELD, REACTION_USER_ARN_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final String commentId;
    private final String reactionUserArn;
    private final String nextToken;
    private final Integer maxResults;

    private GetCommentReactionsRequest(BuilderImpl builder) {
        super(builder);
        this.commentId = builder.commentId;
        this.reactionUserArn = builder.reactionUserArn;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public String commentId() {
        return this.commentId;
    }

    public String reactionUserArn() {
        return this.reactionUserArn;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.commentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reactionUserArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCommentReactionsRequest)) {
            return false;
        }
        GetCommentReactionsRequest other = (GetCommentReactionsRequest)((Object)obj);
        return Objects.equals(this.commentId(), other.commentId()) && Objects.equals(this.reactionUserArn(), other.reactionUserArn()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"GetCommentReactionsRequest").add("CommentId", (Object)this.commentId()).add("ReactionUserArn", (Object)this.reactionUserArn()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "commentId": {
                return Optional.ofNullable(clazz.cast(this.commentId()));
            }
            case "reactionUserArn": {
                return Optional.ofNullable(clazz.cast(this.reactionUserArn()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCommentReactionsRequest, T> g) {
        return obj -> g.apply((GetCommentReactionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitRequest.BuilderImpl
    implements Builder {
        private String commentId;
        private String reactionUserArn;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCommentReactionsRequest model) {
            super(model);
            this.commentId(model.commentId);
            this.reactionUserArn(model.reactionUserArn);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getCommentId() {
            return this.commentId;
        }

        @Override
        public final Builder commentId(String commentId) {
            this.commentId = commentId;
            return this;
        }

        public final void setCommentId(String commentId) {
            this.commentId = commentId;
        }

        public final String getReactionUserArn() {
            return this.reactionUserArn;
        }

        @Override
        public final Builder reactionUserArn(String reactionUserArn) {
            this.reactionUserArn = reactionUserArn;
            return this;
        }

        public final void setReactionUserArn(String reactionUserArn) {
            this.reactionUserArn = reactionUserArn;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCommentReactionsRequest build() {
            return new GetCommentReactionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCommitRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCommentReactionsRequest> {
        public Builder commentId(String var1);

        public Builder reactionUserArn(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

