/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codecommit.model.ApprovalRule;
import software.amazon.awssdk.services.codecommit.model.ApprovalRulesListCopier;
import software.amazon.awssdk.services.codecommit.model.PullRequestStatusEnum;
import software.amazon.awssdk.services.codecommit.model.PullRequestTarget;
import software.amazon.awssdk.services.codecommit.model.PullRequestTargetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PullRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PullRequest> {
    private static final SdkField<String> PULL_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PullRequest.getter(PullRequest::pullRequestId)).setter(PullRequest.setter(Builder::pullRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestId").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PullRequest.getter(PullRequest::title)).setter(PullRequest.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PullRequest.getter(PullRequest::description)).setter(PullRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Instant> LAST_ACTIVITY_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(PullRequest.getter(PullRequest::lastActivityDate)).setter(PullRequest.setter(Builder::lastActivityDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastActivityDate").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(PullRequest.getter(PullRequest::creationDate)).setter(PullRequest.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final SdkField<String> PULL_REQUEST_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PullRequest.getter(PullRequest::pullRequestStatusAsString)).setter(PullRequest.setter(Builder::pullRequestStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestStatus").build()}).build();
    private static final SdkField<String> AUTHOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PullRequest.getter(PullRequest::authorArn)).setter(PullRequest.setter(Builder::authorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorArn").build()}).build();
    private static final SdkField<List<PullRequestTarget>> PULL_REQUEST_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(PullRequest.getter(PullRequest::pullRequestTargets)).setter(PullRequest.setter(Builder::pullRequestTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestTargets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PullRequestTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PullRequest.getter(PullRequest::clientRequestToken)).setter(PullRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build()}).build();
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PullRequest.getter(PullRequest::revisionId)).setter(PullRequest.setter(Builder::revisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()}).build();
    private static final SdkField<List<ApprovalRule>> APPROVAL_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(PullRequest.getter(PullRequest::approvalRules)).setter(PullRequest.setter(Builder::approvalRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ApprovalRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PULL_REQUEST_ID_FIELD, TITLE_FIELD, DESCRIPTION_FIELD, LAST_ACTIVITY_DATE_FIELD, CREATION_DATE_FIELD, PULL_REQUEST_STATUS_FIELD, AUTHOR_ARN_FIELD, PULL_REQUEST_TARGETS_FIELD, CLIENT_REQUEST_TOKEN_FIELD, REVISION_ID_FIELD, APPROVAL_RULES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String pullRequestId;
    private final String title;
    private final String description;
    private final Instant lastActivityDate;
    private final Instant creationDate;
    private final String pullRequestStatus;
    private final String authorArn;
    private final List<PullRequestTarget> pullRequestTargets;
    private final String clientRequestToken;
    private final String revisionId;
    private final List<ApprovalRule> approvalRules;

    private PullRequest(BuilderImpl builder) {
        this.pullRequestId = builder.pullRequestId;
        this.title = builder.title;
        this.description = builder.description;
        this.lastActivityDate = builder.lastActivityDate;
        this.creationDate = builder.creationDate;
        this.pullRequestStatus = builder.pullRequestStatus;
        this.authorArn = builder.authorArn;
        this.pullRequestTargets = builder.pullRequestTargets;
        this.clientRequestToken = builder.clientRequestToken;
        this.revisionId = builder.revisionId;
        this.approvalRules = builder.approvalRules;
    }

    public String pullRequestId() {
        return this.pullRequestId;
    }

    public String title() {
        return this.title;
    }

    public String description() {
        return this.description;
    }

    public Instant lastActivityDate() {
        return this.lastActivityDate;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public PullRequestStatusEnum pullRequestStatus() {
        return PullRequestStatusEnum.fromValue(this.pullRequestStatus);
    }

    public String pullRequestStatusAsString() {
        return this.pullRequestStatus;
    }

    public String authorArn() {
        return this.authorArn;
    }

    public boolean hasPullRequestTargets() {
        return this.pullRequestTargets != null && !(this.pullRequestTargets instanceof SdkAutoConstructList);
    }

    public List<PullRequestTarget> pullRequestTargets() {
        return this.pullRequestTargets;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    public String revisionId() {
        return this.revisionId;
    }

    public boolean hasApprovalRules() {
        return this.approvalRules != null && !(this.approvalRules instanceof SdkAutoConstructList);
    }

    public List<ApprovalRule> approvalRules() {
        return this.approvalRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pullRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastActivityDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.pullRequestStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.pullRequestTargets());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvalRules());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PullRequest)) {
            return false;
        }
        PullRequest other = (PullRequest)obj;
        return Objects.equals(this.pullRequestId(), other.pullRequestId()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.lastActivityDate(), other.lastActivityDate()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.pullRequestStatusAsString(), other.pullRequestStatusAsString()) && Objects.equals(this.authorArn(), other.authorArn()) && Objects.equals(this.pullRequestTargets(), other.pullRequestTargets()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.revisionId(), other.revisionId()) && Objects.equals(this.approvalRules(), other.approvalRules());
    }

    public String toString() {
        return ToString.builder((String)"PullRequest").add("PullRequestId", (Object)this.pullRequestId()).add("Title", (Object)this.title()).add("Description", (Object)this.description()).add("LastActivityDate", (Object)this.lastActivityDate()).add("CreationDate", (Object)this.creationDate()).add("PullRequestStatus", (Object)this.pullRequestStatusAsString()).add("AuthorArn", (Object)this.authorArn()).add("PullRequestTargets", this.pullRequestTargets()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("RevisionId", (Object)this.revisionId()).add("ApprovalRules", this.approvalRules()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pullRequestId": {
                return Optional.ofNullable(clazz.cast(this.pullRequestId()));
            }
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "lastActivityDate": {
                return Optional.ofNullable(clazz.cast(this.lastActivityDate()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "pullRequestStatus": {
                return Optional.ofNullable(clazz.cast(this.pullRequestStatusAsString()));
            }
            case "authorArn": {
                return Optional.ofNullable(clazz.cast(this.authorArn()));
            }
            case "pullRequestTargets": {
                return Optional.ofNullable(clazz.cast(this.pullRequestTargets()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "revisionId": {
                return Optional.ofNullable(clazz.cast(this.revisionId()));
            }
            case "approvalRules": {
                return Optional.ofNullable(clazz.cast(this.approvalRules()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PullRequest, T> g) {
        return obj -> g.apply((PullRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String pullRequestId;
        private String title;
        private String description;
        private Instant lastActivityDate;
        private Instant creationDate;
        private String pullRequestStatus;
        private String authorArn;
        private List<PullRequestTarget> pullRequestTargets = DefaultSdkAutoConstructList.getInstance();
        private String clientRequestToken;
        private String revisionId;
        private List<ApprovalRule> approvalRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PullRequest model) {
            this.pullRequestId(model.pullRequestId);
            this.title(model.title);
            this.description(model.description);
            this.lastActivityDate(model.lastActivityDate);
            this.creationDate(model.creationDate);
            this.pullRequestStatus(model.pullRequestStatus);
            this.authorArn(model.authorArn);
            this.pullRequestTargets(model.pullRequestTargets);
            this.clientRequestToken(model.clientRequestToken);
            this.revisionId(model.revisionId);
            this.approvalRules(model.approvalRules);
        }

        public final String getPullRequestId() {
            return this.pullRequestId;
        }

        @Override
        public final Builder pullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
            return this;
        }

        public final void setPullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
        }

        public final String getTitle() {
            return this.title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getLastActivityDate() {
            return this.lastActivityDate;
        }

        @Override
        public final Builder lastActivityDate(Instant lastActivityDate) {
            this.lastActivityDate = lastActivityDate;
            return this;
        }

        public final void setLastActivityDate(Instant lastActivityDate) {
            this.lastActivityDate = lastActivityDate;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final String getPullRequestStatus() {
            return this.pullRequestStatus;
        }

        @Override
        public final Builder pullRequestStatus(String pullRequestStatus) {
            this.pullRequestStatus = pullRequestStatus;
            return this;
        }

        @Override
        public final Builder pullRequestStatus(PullRequestStatusEnum pullRequestStatus) {
            this.pullRequestStatus(pullRequestStatus == null ? null : pullRequestStatus.toString());
            return this;
        }

        public final void setPullRequestStatus(String pullRequestStatus) {
            this.pullRequestStatus = pullRequestStatus;
        }

        public final String getAuthorArn() {
            return this.authorArn;
        }

        @Override
        public final Builder authorArn(String authorArn) {
            this.authorArn = authorArn;
            return this;
        }

        public final void setAuthorArn(String authorArn) {
            this.authorArn = authorArn;
        }

        public final Collection<PullRequestTarget.Builder> getPullRequestTargets() {
            return this.pullRequestTargets != null ? (Collection)this.pullRequestTargets.stream().map(PullRequestTarget::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder pullRequestTargets(Collection<PullRequestTarget> pullRequestTargets) {
            this.pullRequestTargets = PullRequestTargetListCopier.copy(pullRequestTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pullRequestTargets(PullRequestTarget ... pullRequestTargets) {
            this.pullRequestTargets(Arrays.asList(pullRequestTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pullRequestTargets(Consumer<PullRequestTarget.Builder> ... pullRequestTargets) {
            this.pullRequestTargets(Stream.of(pullRequestTargets).map(c -> (PullRequestTarget)((PullRequestTarget.Builder)PullRequestTarget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPullRequestTargets(Collection<PullRequestTarget.BuilderImpl> pullRequestTargets) {
            this.pullRequestTargets = PullRequestTargetListCopier.copyFromBuilder(pullRequestTargets);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        public final Collection<ApprovalRule.Builder> getApprovalRules() {
            return this.approvalRules != null ? (Collection)this.approvalRules.stream().map(ApprovalRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder approvalRules(Collection<ApprovalRule> approvalRules) {
            this.approvalRules = ApprovalRulesListCopier.copy(approvalRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvalRules(ApprovalRule ... approvalRules) {
            this.approvalRules(Arrays.asList(approvalRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvalRules(Consumer<ApprovalRule.Builder> ... approvalRules) {
            this.approvalRules(Stream.of(approvalRules).map(c -> (ApprovalRule)((ApprovalRule.Builder)ApprovalRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setApprovalRules(Collection<ApprovalRule.BuilderImpl> approvalRules) {
            this.approvalRules = ApprovalRulesListCopier.copyFromBuilder(approvalRules);
        }

        public PullRequest build() {
            return new PullRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PullRequest> {
        public Builder pullRequestId(String var1);

        public Builder title(String var1);

        public Builder description(String var1);

        public Builder lastActivityDate(Instant var1);

        public Builder creationDate(Instant var1);

        public Builder pullRequestStatus(String var1);

        public Builder pullRequestStatus(PullRequestStatusEnum var1);

        public Builder authorArn(String var1);

        public Builder pullRequestTargets(Collection<PullRequestTarget> var1);

        public Builder pullRequestTargets(PullRequestTarget ... var1);

        public Builder pullRequestTargets(Consumer<PullRequestTarget.Builder> ... var1);

        public Builder clientRequestToken(String var1);

        public Builder revisionId(String var1);

        public Builder approvalRules(Collection<ApprovalRule> var1);

        public Builder approvalRules(ApprovalRule ... var1);

        public Builder approvalRules(Consumer<ApprovalRule.Builder> ... var1);
    }
}

