/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.CodeCommitRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutCommentReactionRequest
extends CodeCommitRequest
implements ToCopyableBuilder<Builder, PutCommentReactionRequest> {
    private static final SdkField<String> COMMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutCommentReactionRequest.getter(PutCommentReactionRequest::commentId)).setter(PutCommentReactionRequest.setter(Builder::commentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commentId").build()}).build();
    private static final SdkField<String> REACTION_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutCommentReactionRequest.getter(PutCommentReactionRequest::reactionValue)).setter(PutCommentReactionRequest.setter(Builder::reactionValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reactionValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMENT_ID_FIELD, REACTION_VALUE_FIELD));
    private final String commentId;
    private final String reactionValue;

    private PutCommentReactionRequest(BuilderImpl builder) {
        super(builder);
        this.commentId = builder.commentId;
        this.reactionValue = builder.reactionValue;
    }

    public String commentId() {
        return this.commentId;
    }

    public String reactionValue() {
        return this.reactionValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.commentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reactionValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutCommentReactionRequest)) {
            return false;
        }
        PutCommentReactionRequest other = (PutCommentReactionRequest)((Object)obj);
        return Objects.equals(this.commentId(), other.commentId()) && Objects.equals(this.reactionValue(), other.reactionValue());
    }

    public String toString() {
        return ToString.builder((String)"PutCommentReactionRequest").add("CommentId", (Object)this.commentId()).add("ReactionValue", (Object)this.reactionValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "commentId": {
                return Optional.ofNullable(clazz.cast(this.commentId()));
            }
            case "reactionValue": {
                return Optional.ofNullable(clazz.cast(this.reactionValue()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutCommentReactionRequest, T> g) {
        return obj -> g.apply((PutCommentReactionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitRequest.BuilderImpl
    implements Builder {
        private String commentId;
        private String reactionValue;

        private BuilderImpl() {
        }

        private BuilderImpl(PutCommentReactionRequest model) {
            super(model);
            this.commentId(model.commentId);
            this.reactionValue(model.reactionValue);
        }

        public final String getCommentId() {
            return this.commentId;
        }

        @Override
        public final Builder commentId(String commentId) {
            this.commentId = commentId;
            return this;
        }

        public final void setCommentId(String commentId) {
            this.commentId = commentId;
        }

        public final String getReactionValue() {
            return this.reactionValue;
        }

        @Override
        public final Builder reactionValue(String reactionValue) {
            this.reactionValue = reactionValue;
            return this;
        }

        public final void setReactionValue(String reactionValue) {
            this.reactionValue = reactionValue;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutCommentReactionRequest build() {
            return new PutCommentReactionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCommitRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutCommentReactionRequest> {
        public Builder commentId(String var1);

        public Builder reactionValue(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

