/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.OverrideStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApprovalRuleOverriddenEventMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApprovalRuleOverriddenEventMetadata> {
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revisionId").getter(ApprovalRuleOverriddenEventMetadata.getter(ApprovalRuleOverriddenEventMetadata::revisionId)).setter(ApprovalRuleOverriddenEventMetadata.setter(Builder::revisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()}).build();
    private static final SdkField<String> OVERRIDE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("overrideStatus").getter(ApprovalRuleOverriddenEventMetadata.getter(ApprovalRuleOverriddenEventMetadata::overrideStatusAsString)).setter(ApprovalRuleOverriddenEventMetadata.setter(Builder::overrideStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REVISION_ID_FIELD, OVERRIDE_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String revisionId;
    private final String overrideStatus;

    private ApprovalRuleOverriddenEventMetadata(BuilderImpl builder) {
        this.revisionId = builder.revisionId;
        this.overrideStatus = builder.overrideStatus;
    }

    public String revisionId() {
        return this.revisionId;
    }

    public OverrideStatus overrideStatus() {
        return OverrideStatus.fromValue(this.overrideStatus);
    }

    public String overrideStatusAsString() {
        return this.overrideStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrideStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApprovalRuleOverriddenEventMetadata)) {
            return false;
        }
        ApprovalRuleOverriddenEventMetadata other = (ApprovalRuleOverriddenEventMetadata)obj;
        return Objects.equals(this.revisionId(), other.revisionId()) && Objects.equals(this.overrideStatusAsString(), other.overrideStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"ApprovalRuleOverriddenEventMetadata").add("RevisionId", (Object)this.revisionId()).add("OverrideStatus", (Object)this.overrideStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "revisionId": {
                return Optional.ofNullable(clazz.cast(this.revisionId()));
            }
            case "overrideStatus": {
                return Optional.ofNullable(clazz.cast(this.overrideStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApprovalRuleOverriddenEventMetadata, T> g) {
        return obj -> g.apply((ApprovalRuleOverriddenEventMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String revisionId;
        private String overrideStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ApprovalRuleOverriddenEventMetadata model) {
            this.revisionId(model.revisionId);
            this.overrideStatus(model.overrideStatus);
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        public final String getOverrideStatus() {
            return this.overrideStatus;
        }

        @Override
        public final Builder overrideStatus(String overrideStatus) {
            this.overrideStatus = overrideStatus;
            return this;
        }

        @Override
        public final Builder overrideStatus(OverrideStatus overrideStatus) {
            this.overrideStatus(overrideStatus == null ? null : overrideStatus.toString());
            return this;
        }

        public final void setOverrideStatus(String overrideStatus) {
            this.overrideStatus = overrideStatus;
        }

        public ApprovalRuleOverriddenEventMetadata build() {
            return new ApprovalRuleOverriddenEventMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApprovalRuleOverriddenEventMetadata> {
        public Builder revisionId(String var1);

        public Builder overrideStatus(String var1);

        public Builder overrideStatus(OverrideStatus var1);
    }
}

