/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codecommit.model.CodeCommitRequest;
import software.amazon.awssdk.services.codecommit.model.RepositoryNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchAssociateApprovalRuleTemplateWithRepositoriesRequest
extends CodeCommitRequest
implements ToCopyableBuilder<Builder, BatchAssociateApprovalRuleTemplateWithRepositoriesRequest> {
    private static final SdkField<String> APPROVAL_RULE_TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("approvalRuleTemplateName").getter(BatchAssociateApprovalRuleTemplateWithRepositoriesRequest.getter(BatchAssociateApprovalRuleTemplateWithRepositoriesRequest::approvalRuleTemplateName)).setter(BatchAssociateApprovalRuleTemplateWithRepositoriesRequest.setter(Builder::approvalRuleTemplateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRuleTemplateName").build()}).build();
    private static final SdkField<List<String>> REPOSITORY_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("repositoryNames").getter(BatchAssociateApprovalRuleTemplateWithRepositoriesRequest.getter(BatchAssociateApprovalRuleTemplateWithRepositoriesRequest::repositoryNames)).setter(BatchAssociateApprovalRuleTemplateWithRepositoriesRequest.setter(Builder::repositoryNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPROVAL_RULE_TEMPLATE_NAME_FIELD, REPOSITORY_NAMES_FIELD));
    private final String approvalRuleTemplateName;
    private final List<String> repositoryNames;

    private BatchAssociateApprovalRuleTemplateWithRepositoriesRequest(BuilderImpl builder) {
        super(builder);
        this.approvalRuleTemplateName = builder.approvalRuleTemplateName;
        this.repositoryNames = builder.repositoryNames;
    }

    public String approvalRuleTemplateName() {
        return this.approvalRuleTemplateName;
    }

    public boolean hasRepositoryNames() {
        return this.repositoryNames != null && !(this.repositoryNames instanceof SdkAutoConstructList);
    }

    public List<String> repositoryNames() {
        return this.repositoryNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.approvalRuleTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRepositoryNames() ? this.repositoryNames() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAssociateApprovalRuleTemplateWithRepositoriesRequest)) {
            return false;
        }
        BatchAssociateApprovalRuleTemplateWithRepositoriesRequest other = (BatchAssociateApprovalRuleTemplateWithRepositoriesRequest)((Object)obj);
        return Objects.equals(this.approvalRuleTemplateName(), other.approvalRuleTemplateName()) && this.hasRepositoryNames() == other.hasRepositoryNames() && Objects.equals(this.repositoryNames(), other.repositoryNames());
    }

    public String toString() {
        return ToString.builder((String)"BatchAssociateApprovalRuleTemplateWithRepositoriesRequest").add("ApprovalRuleTemplateName", (Object)this.approvalRuleTemplateName()).add("RepositoryNames", this.hasRepositoryNames() ? this.repositoryNames() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "approvalRuleTemplateName": {
                return Optional.ofNullable(clazz.cast(this.approvalRuleTemplateName()));
            }
            case "repositoryNames": {
                return Optional.ofNullable(clazz.cast(this.repositoryNames()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchAssociateApprovalRuleTemplateWithRepositoriesRequest, T> g) {
        return obj -> g.apply((BatchAssociateApprovalRuleTemplateWithRepositoriesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitRequest.BuilderImpl
    implements Builder {
        private String approvalRuleTemplateName;
        private List<String> repositoryNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAssociateApprovalRuleTemplateWithRepositoriesRequest model) {
            super(model);
            this.approvalRuleTemplateName(model.approvalRuleTemplateName);
            this.repositoryNames(model.repositoryNames);
        }

        public final String getApprovalRuleTemplateName() {
            return this.approvalRuleTemplateName;
        }

        @Override
        public final Builder approvalRuleTemplateName(String approvalRuleTemplateName) {
            this.approvalRuleTemplateName = approvalRuleTemplateName;
            return this;
        }

        public final void setApprovalRuleTemplateName(String approvalRuleTemplateName) {
            this.approvalRuleTemplateName = approvalRuleTemplateName;
        }

        public final Collection<String> getRepositoryNames() {
            if (this.repositoryNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.repositoryNames;
        }

        @Override
        public final Builder repositoryNames(Collection<String> repositoryNames) {
            this.repositoryNames = RepositoryNameListCopier.copy(repositoryNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositoryNames(String ... repositoryNames) {
            this.repositoryNames(Arrays.asList(repositoryNames));
            return this;
        }

        public final void setRepositoryNames(Collection<String> repositoryNames) {
            this.repositoryNames = RepositoryNameListCopier.copy(repositoryNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchAssociateApprovalRuleTemplateWithRepositoriesRequest build() {
            return new BatchAssociateApprovalRuleTemplateWithRepositoriesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCommitRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchAssociateApprovalRuleTemplateWithRepositoriesRequest> {
        public Builder approvalRuleTemplateName(String var1);

        public Builder repositoryNames(Collection<String> var1);

        public Builder repositoryNames(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

