/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codecommit.model.CodeCommitRequest;
import software.amazon.awssdk.services.codecommit.model.CommitIdsInputListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetCommitsRequest
extends CodeCommitRequest
implements ToCopyableBuilder<Builder, BatchGetCommitsRequest> {
    private static final SdkField<List<String>> COMMIT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("commitIds").getter(BatchGetCommitsRequest.getter(BatchGetCommitsRequest::commitIds)).setter(BatchGetCommitsRequest.setter(Builder::commitIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(BatchGetCommitsRequest.getter(BatchGetCommitsRequest::repositoryName)).setter(BatchGetCommitsRequest.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMIT_IDS_FIELD, REPOSITORY_NAME_FIELD));
    private final List<String> commitIds;
    private final String repositoryName;

    private BatchGetCommitsRequest(BuilderImpl builder) {
        super(builder);
        this.commitIds = builder.commitIds;
        this.repositoryName = builder.repositoryName;
    }

    public boolean hasCommitIds() {
        return this.commitIds != null && !(this.commitIds instanceof SdkAutoConstructList);
    }

    public List<String> commitIds() {
        return this.commitIds;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCommitIds() ? this.commitIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetCommitsRequest)) {
            return false;
        }
        BatchGetCommitsRequest other = (BatchGetCommitsRequest)((Object)obj);
        return this.hasCommitIds() == other.hasCommitIds() && Objects.equals(this.commitIds(), other.commitIds()) && Objects.equals(this.repositoryName(), other.repositoryName());
    }

    public String toString() {
        return ToString.builder((String)"BatchGetCommitsRequest").add("CommitIds", this.hasCommitIds() ? this.commitIds() : null).add("RepositoryName", (Object)this.repositoryName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "commitIds": {
                return Optional.ofNullable(clazz.cast(this.commitIds()));
            }
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetCommitsRequest, T> g) {
        return obj -> g.apply((BatchGetCommitsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitRequest.BuilderImpl
    implements Builder {
        private List<String> commitIds = DefaultSdkAutoConstructList.getInstance();
        private String repositoryName;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetCommitsRequest model) {
            super(model);
            this.commitIds(model.commitIds);
            this.repositoryName(model.repositoryName);
        }

        public final Collection<String> getCommitIds() {
            if (this.commitIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.commitIds;
        }

        @Override
        public final Builder commitIds(Collection<String> commitIds) {
            this.commitIds = CommitIdsInputListCopier.copy(commitIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commitIds(String ... commitIds) {
            this.commitIds(Arrays.asList(commitIds));
            return this;
        }

        public final void setCommitIds(Collection<String> commitIds) {
            this.commitIds = CommitIdsInputListCopier.copy(commitIds);
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetCommitsRequest build() {
            return new BatchGetCommitsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCommitRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetCommitsRequest> {
        public Builder commitIds(Collection<String> var1);

        public Builder commitIds(String ... var1);

        public Builder repositoryName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

