/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.CodeCommitResponse;
import software.amazon.awssdk.services.codecommit.model.FileModeTypeEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFileResponse
extends CodeCommitResponse
implements ToCopyableBuilder<Builder, GetFileResponse> {
    private static final SdkField<String> COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("commitId").getter(GetFileResponse.getter(GetFileResponse::commitId)).setter(GetFileResponse.setter(Builder::commitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitId").build()}).build();
    private static final SdkField<String> BLOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blobId").getter(GetFileResponse.getter(GetFileResponse::blobId)).setter(GetFileResponse.setter(Builder::blobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blobId").build()}).build();
    private static final SdkField<String> FILE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filePath").getter(GetFileResponse.getter(GetFileResponse::filePath)).setter(GetFileResponse.setter(Builder::filePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePath").build()}).build();
    private static final SdkField<String> FILE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fileMode").getter(GetFileResponse.getter(GetFileResponse::fileModeAsString)).setter(GetFileResponse.setter(Builder::fileMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileMode").build()}).build();
    private static final SdkField<Long> FILE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("fileSize").getter(GetFileResponse.getter(GetFileResponse::fileSize)).setter(GetFileResponse.setter(Builder::fileSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileSize").build()}).build();
    private static final SdkField<SdkBytes> FILE_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("fileContent").getter(GetFileResponse.getter(GetFileResponse::fileContent)).setter(GetFileResponse.setter(Builder::fileContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileContent").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMIT_ID_FIELD, BLOB_ID_FIELD, FILE_PATH_FIELD, FILE_MODE_FIELD, FILE_SIZE_FIELD, FILE_CONTENT_FIELD));
    private final String commitId;
    private final String blobId;
    private final String filePath;
    private final String fileMode;
    private final Long fileSize;
    private final SdkBytes fileContent;

    private GetFileResponse(BuilderImpl builder) {
        super(builder);
        this.commitId = builder.commitId;
        this.blobId = builder.blobId;
        this.filePath = builder.filePath;
        this.fileMode = builder.fileMode;
        this.fileSize = builder.fileSize;
        this.fileContent = builder.fileContent;
    }

    public String commitId() {
        return this.commitId;
    }

    public String blobId() {
        return this.blobId;
    }

    public String filePath() {
        return this.filePath;
    }

    public FileModeTypeEnum fileMode() {
        return FileModeTypeEnum.fromValue(this.fileMode);
    }

    public String fileModeAsString() {
        return this.fileMode;
    }

    public Long fileSize() {
        return this.fileSize;
    }

    public SdkBytes fileContent() {
        return this.fileContent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.commitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.blobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.filePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileContent());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFileResponse)) {
            return false;
        }
        GetFileResponse other = (GetFileResponse)((Object)obj);
        return Objects.equals(this.commitId(), other.commitId()) && Objects.equals(this.blobId(), other.blobId()) && Objects.equals(this.filePath(), other.filePath()) && Objects.equals(this.fileModeAsString(), other.fileModeAsString()) && Objects.equals(this.fileSize(), other.fileSize()) && Objects.equals(this.fileContent(), other.fileContent());
    }

    public String toString() {
        return ToString.builder((String)"GetFileResponse").add("CommitId", (Object)this.commitId()).add("BlobId", (Object)this.blobId()).add("FilePath", (Object)this.filePath()).add("FileMode", (Object)this.fileModeAsString()).add("FileSize", (Object)this.fileSize()).add("FileContent", (Object)this.fileContent()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "commitId": {
                return Optional.ofNullable(clazz.cast(this.commitId()));
            }
            case "blobId": {
                return Optional.ofNullable(clazz.cast(this.blobId()));
            }
            case "filePath": {
                return Optional.ofNullable(clazz.cast(this.filePath()));
            }
            case "fileMode": {
                return Optional.ofNullable(clazz.cast(this.fileModeAsString()));
            }
            case "fileSize": {
                return Optional.ofNullable(clazz.cast(this.fileSize()));
            }
            case "fileContent": {
                return Optional.ofNullable(clazz.cast(this.fileContent()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFileResponse, T> g) {
        return obj -> g.apply((GetFileResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitResponse.BuilderImpl
    implements Builder {
        private String commitId;
        private String blobId;
        private String filePath;
        private String fileMode;
        private Long fileSize;
        private SdkBytes fileContent;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFileResponse model) {
            super(model);
            this.commitId(model.commitId);
            this.blobId(model.blobId);
            this.filePath(model.filePath);
            this.fileMode(model.fileMode);
            this.fileSize(model.fileSize);
            this.fileContent(model.fileContent);
        }

        public final String getCommitId() {
            return this.commitId;
        }

        @Override
        public final Builder commitId(String commitId) {
            this.commitId = commitId;
            return this;
        }

        public final void setCommitId(String commitId) {
            this.commitId = commitId;
        }

        public final String getBlobId() {
            return this.blobId;
        }

        @Override
        public final Builder blobId(String blobId) {
            this.blobId = blobId;
            return this;
        }

        public final void setBlobId(String blobId) {
            this.blobId = blobId;
        }

        public final String getFilePath() {
            return this.filePath;
        }

        @Override
        public final Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public final void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        public final String getFileMode() {
            return this.fileMode;
        }

        @Override
        public final Builder fileMode(String fileMode) {
            this.fileMode = fileMode;
            return this;
        }

        @Override
        public final Builder fileMode(FileModeTypeEnum fileMode) {
            this.fileMode(fileMode == null ? null : fileMode.toString());
            return this;
        }

        public final void setFileMode(String fileMode) {
            this.fileMode = fileMode;
        }

        public final Long getFileSize() {
            return this.fileSize;
        }

        @Override
        public final Builder fileSize(Long fileSize) {
            this.fileSize = fileSize;
            return this;
        }

        public final void setFileSize(Long fileSize) {
            this.fileSize = fileSize;
        }

        public final ByteBuffer getFileContent() {
            return this.fileContent == null ? null : this.fileContent.asByteBuffer();
        }

        @Override
        public final Builder fileContent(SdkBytes fileContent) {
            this.fileContent = StandardMemberCopier.copy((SdkBytes)fileContent);
            return this;
        }

        public final void setFileContent(ByteBuffer fileContent) {
            this.fileContent(fileContent == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)fileContent));
        }

        @Override
        public GetFileResponse build() {
            return new GetFileResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCommitResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetFileResponse> {
        public Builder commitId(String var1);

        public Builder blobId(String var1);

        public Builder filePath(String var1);

        public Builder fileMode(String var1);

        public Builder fileMode(FileModeTypeEnum var1);

        public Builder fileSize(Long var1);

        public Builder fileContent(SdkBytes var1);
    }
}

