/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codecommit.model.CodeCommitResponse;
import software.amazon.awssdk.services.codecommit.model.RepositoryNameIdPair;
import software.amazon.awssdk.services.codecommit.model.RepositoryNameIdPairListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRepositoriesResponse
extends CodeCommitResponse
implements ToCopyableBuilder<Builder, ListRepositoriesResponse> {
    private static final SdkField<List<RepositoryNameIdPair>> REPOSITORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("repositories").getter(ListRepositoriesResponse.getter(ListRepositoriesResponse::repositories)).setter(ListRepositoriesResponse.setter(Builder::repositories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RepositoryNameIdPair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListRepositoriesResponse.getter(ListRepositoriesResponse::nextToken)).setter(ListRepositoriesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<RepositoryNameIdPair> repositories;
    private final String nextToken;

    private ListRepositoriesResponse(BuilderImpl builder) {
        super(builder);
        this.repositories = builder.repositories;
        this.nextToken = builder.nextToken;
    }

    public boolean hasRepositories() {
        return this.repositories != null && !(this.repositories instanceof SdkAutoConstructList);
    }

    public List<RepositoryNameIdPair> repositories() {
        return this.repositories;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRepositories() ? this.repositories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRepositoriesResponse)) {
            return false;
        }
        ListRepositoriesResponse other = (ListRepositoriesResponse)((Object)obj);
        return this.hasRepositories() == other.hasRepositories() && Objects.equals(this.repositories(), other.repositories()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListRepositoriesResponse").add("Repositories", this.hasRepositories() ? this.repositories() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "repositories": {
                return Optional.ofNullable(clazz.cast(this.repositories()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRepositoriesResponse, T> g) {
        return obj -> g.apply((ListRepositoriesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitResponse.BuilderImpl
    implements Builder {
        private List<RepositoryNameIdPair> repositories = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRepositoriesResponse model) {
            super(model);
            this.repositories(model.repositories);
            this.nextToken(model.nextToken);
        }

        public final Collection<RepositoryNameIdPair.Builder> getRepositories() {
            if (this.repositories instanceof SdkAutoConstructList) {
                return null;
            }
            return this.repositories != null ? (Collection)this.repositories.stream().map(RepositoryNameIdPair::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder repositories(Collection<RepositoryNameIdPair> repositories) {
            this.repositories = RepositoryNameIdPairListCopier.copy(repositories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositories(RepositoryNameIdPair ... repositories) {
            this.repositories(Arrays.asList(repositories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositories(Consumer<RepositoryNameIdPair.Builder> ... repositories) {
            this.repositories(Stream.of(repositories).map(c -> (RepositoryNameIdPair)((RepositoryNameIdPair.Builder)RepositoryNameIdPair.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRepositories(Collection<RepositoryNameIdPair.BuilderImpl> repositories) {
            this.repositories = RepositoryNameIdPairListCopier.copyFromBuilder(repositories);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListRepositoriesResponse build() {
            return new ListRepositoriesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCommitResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRepositoriesResponse> {
        public Builder repositories(Collection<RepositoryNameIdPair> var1);

        public Builder repositories(RepositoryNameIdPair ... var1);

        public Builder repositories(Consumer<RepositoryNameIdPair.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

