/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information about an approval rule template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApprovalRuleTemplate implements SdkPojo, Serializable,
        ToCopyableBuilder<ApprovalRuleTemplate.Builder, ApprovalRuleTemplate> {
    private static final SdkField<String> APPROVAL_RULE_TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("approvalRuleTemplateId").getter(getter(ApprovalRuleTemplate::approvalRuleTemplateId))
            .setter(setter(Builder::approvalRuleTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRuleTemplateId").build())
            .build();

    private static final SdkField<String> APPROVAL_RULE_TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("approvalRuleTemplateName").getter(getter(ApprovalRuleTemplate::approvalRuleTemplateName))
            .setter(setter(Builder::approvalRuleTemplateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRuleTemplateName").build())
            .build();

    private static final SdkField<String> APPROVAL_RULE_TEMPLATE_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("approvalRuleTemplateDescription")
            .getter(getter(ApprovalRuleTemplate::approvalRuleTemplateDescription))
            .setter(setter(Builder::approvalRuleTemplateDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRuleTemplateDescription")
                    .build()).build();

    private static final SdkField<String> APPROVAL_RULE_TEMPLATE_CONTENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("approvalRuleTemplateContent")
            .getter(getter(ApprovalRuleTemplate::approvalRuleTemplateContent))
            .setter(setter(Builder::approvalRuleTemplateContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRuleTemplateContent")
                    .build()).build();

    private static final SdkField<String> RULE_CONTENT_SHA256_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ruleContentSha256").getter(getter(ApprovalRuleTemplate::ruleContentSha256))
            .setter(setter(Builder::ruleContentSha256))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleContentSha256").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedDate").getter(getter(ApprovalRuleTemplate::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate").getter(getter(ApprovalRuleTemplate::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final SdkField<String> LAST_MODIFIED_USER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastModifiedUser").getter(getter(ApprovalRuleTemplate::lastModifiedUser))
            .setter(setter(Builder::lastModifiedUser))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedUser").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            APPROVAL_RULE_TEMPLATE_ID_FIELD, APPROVAL_RULE_TEMPLATE_NAME_FIELD, APPROVAL_RULE_TEMPLATE_DESCRIPTION_FIELD,
            APPROVAL_RULE_TEMPLATE_CONTENT_FIELD, RULE_CONTENT_SHA256_FIELD, LAST_MODIFIED_DATE_FIELD, CREATION_DATE_FIELD,
            LAST_MODIFIED_USER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String approvalRuleTemplateId;

    private final String approvalRuleTemplateName;

    private final String approvalRuleTemplateDescription;

    private final String approvalRuleTemplateContent;

    private final String ruleContentSha256;

    private final Instant lastModifiedDate;

    private final Instant creationDate;

    private final String lastModifiedUser;

    private ApprovalRuleTemplate(BuilderImpl builder) {
        this.approvalRuleTemplateId = builder.approvalRuleTemplateId;
        this.approvalRuleTemplateName = builder.approvalRuleTemplateName;
        this.approvalRuleTemplateDescription = builder.approvalRuleTemplateDescription;
        this.approvalRuleTemplateContent = builder.approvalRuleTemplateContent;
        this.ruleContentSha256 = builder.ruleContentSha256;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.creationDate = builder.creationDate;
        this.lastModifiedUser = builder.lastModifiedUser;
    }

    /**
     * <p>
     * The system-generated ID of the approval rule template.
     * </p>
     * 
     * @return The system-generated ID of the approval rule template.
     */
    public String approvalRuleTemplateId() {
        return approvalRuleTemplateId;
    }

    /**
     * <p>
     * The name of the approval rule template.
     * </p>
     * 
     * @return The name of the approval rule template.
     */
    public String approvalRuleTemplateName() {
        return approvalRuleTemplateName;
    }

    /**
     * <p>
     * The description of the approval rule template.
     * </p>
     * 
     * @return The description of the approval rule template.
     */
    public String approvalRuleTemplateDescription() {
        return approvalRuleTemplateDescription;
    }

    /**
     * <p>
     * The content of the approval rule template.
     * </p>
     * 
     * @return The content of the approval rule template.
     */
    public String approvalRuleTemplateContent() {
        return approvalRuleTemplateContent;
    }

    /**
     * <p>
     * The SHA-256 hash signature for the content of the approval rule template.
     * </p>
     * 
     * @return The SHA-256 hash signature for the content of the approval rule template.
     */
    public String ruleContentSha256() {
        return ruleContentSha256;
    }

    /**
     * <p>
     * The date the approval rule template was most recently changed, in timestamp format.
     * </p>
     * 
     * @return The date the approval rule template was most recently changed, in timestamp format.
     */
    public Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The date the approval rule template was created, in timestamp format.
     * </p>
     * 
     * @return The date the approval rule template was created, in timestamp format.
     */
    public Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the user who made the most recent changes to the approval rule template.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the user who made the most recent changes to the approval rule
     *         template.
     */
    public String lastModifiedUser() {
        return lastModifiedUser;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(approvalRuleTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(approvalRuleTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(approvalRuleTemplateDescription());
        hashCode = 31 * hashCode + Objects.hashCode(approvalRuleTemplateContent());
        hashCode = 31 * hashCode + Objects.hashCode(ruleContentSha256());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedUser());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApprovalRuleTemplate)) {
            return false;
        }
        ApprovalRuleTemplate other = (ApprovalRuleTemplate) obj;
        return Objects.equals(approvalRuleTemplateId(), other.approvalRuleTemplateId())
                && Objects.equals(approvalRuleTemplateName(), other.approvalRuleTemplateName())
                && Objects.equals(approvalRuleTemplateDescription(), other.approvalRuleTemplateDescription())
                && Objects.equals(approvalRuleTemplateContent(), other.approvalRuleTemplateContent())
                && Objects.equals(ruleContentSha256(), other.ruleContentSha256())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(lastModifiedUser(), other.lastModifiedUser());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ApprovalRuleTemplate").add("ApprovalRuleTemplateId", approvalRuleTemplateId())
                .add("ApprovalRuleTemplateName", approvalRuleTemplateName())
                .add("ApprovalRuleTemplateDescription", approvalRuleTemplateDescription())
                .add("ApprovalRuleTemplateContent", approvalRuleTemplateContent()).add("RuleContentSha256", ruleContentSha256())
                .add("LastModifiedDate", lastModifiedDate()).add("CreationDate", creationDate())
                .add("LastModifiedUser", lastModifiedUser()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "approvalRuleTemplateId":
            return Optional.ofNullable(clazz.cast(approvalRuleTemplateId()));
        case "approvalRuleTemplateName":
            return Optional.ofNullable(clazz.cast(approvalRuleTemplateName()));
        case "approvalRuleTemplateDescription":
            return Optional.ofNullable(clazz.cast(approvalRuleTemplateDescription()));
        case "approvalRuleTemplateContent":
            return Optional.ofNullable(clazz.cast(approvalRuleTemplateContent()));
        case "ruleContentSha256":
            return Optional.ofNullable(clazz.cast(ruleContentSha256()));
        case "lastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "lastModifiedUser":
            return Optional.ofNullable(clazz.cast(lastModifiedUser()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApprovalRuleTemplate, T> g) {
        return obj -> g.apply((ApprovalRuleTemplate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApprovalRuleTemplate> {
        /**
         * <p>
         * The system-generated ID of the approval rule template.
         * </p>
         * 
         * @param approvalRuleTemplateId
         *        The system-generated ID of the approval rule template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalRuleTemplateId(String approvalRuleTemplateId);

        /**
         * <p>
         * The name of the approval rule template.
         * </p>
         * 
         * @param approvalRuleTemplateName
         *        The name of the approval rule template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalRuleTemplateName(String approvalRuleTemplateName);

        /**
         * <p>
         * The description of the approval rule template.
         * </p>
         * 
         * @param approvalRuleTemplateDescription
         *        The description of the approval rule template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalRuleTemplateDescription(String approvalRuleTemplateDescription);

        /**
         * <p>
         * The content of the approval rule template.
         * </p>
         * 
         * @param approvalRuleTemplateContent
         *        The content of the approval rule template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalRuleTemplateContent(String approvalRuleTemplateContent);

        /**
         * <p>
         * The SHA-256 hash signature for the content of the approval rule template.
         * </p>
         * 
         * @param ruleContentSha256
         *        The SHA-256 hash signature for the content of the approval rule template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleContentSha256(String ruleContentSha256);

        /**
         * <p>
         * The date the approval rule template was most recently changed, in timestamp format.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date the approval rule template was most recently changed, in timestamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);

        /**
         * <p>
         * The date the approval rule template was created, in timestamp format.
         * </p>
         * 
         * @param creationDate
         *        The date the approval rule template was created, in timestamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the user who made the most recent changes to the approval rule template.
         * </p>
         * 
         * @param lastModifiedUser
         *        The Amazon Resource Name (ARN) of the user who made the most recent changes to the approval rule
         *        template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedUser(String lastModifiedUser);
    }

    static final class BuilderImpl implements Builder {
        private String approvalRuleTemplateId;

        private String approvalRuleTemplateName;

        private String approvalRuleTemplateDescription;

        private String approvalRuleTemplateContent;

        private String ruleContentSha256;

        private Instant lastModifiedDate;

        private Instant creationDate;

        private String lastModifiedUser;

        private BuilderImpl() {
        }

        private BuilderImpl(ApprovalRuleTemplate model) {
            approvalRuleTemplateId(model.approvalRuleTemplateId);
            approvalRuleTemplateName(model.approvalRuleTemplateName);
            approvalRuleTemplateDescription(model.approvalRuleTemplateDescription);
            approvalRuleTemplateContent(model.approvalRuleTemplateContent);
            ruleContentSha256(model.ruleContentSha256);
            lastModifiedDate(model.lastModifiedDate);
            creationDate(model.creationDate);
            lastModifiedUser(model.lastModifiedUser);
        }

        public final String getApprovalRuleTemplateId() {
            return approvalRuleTemplateId;
        }

        @Override
        public final Builder approvalRuleTemplateId(String approvalRuleTemplateId) {
            this.approvalRuleTemplateId = approvalRuleTemplateId;
            return this;
        }

        public final void setApprovalRuleTemplateId(String approvalRuleTemplateId) {
            this.approvalRuleTemplateId = approvalRuleTemplateId;
        }

        public final String getApprovalRuleTemplateName() {
            return approvalRuleTemplateName;
        }

        @Override
        public final Builder approvalRuleTemplateName(String approvalRuleTemplateName) {
            this.approvalRuleTemplateName = approvalRuleTemplateName;
            return this;
        }

        public final void setApprovalRuleTemplateName(String approvalRuleTemplateName) {
            this.approvalRuleTemplateName = approvalRuleTemplateName;
        }

        public final String getApprovalRuleTemplateDescription() {
            return approvalRuleTemplateDescription;
        }

        @Override
        public final Builder approvalRuleTemplateDescription(String approvalRuleTemplateDescription) {
            this.approvalRuleTemplateDescription = approvalRuleTemplateDescription;
            return this;
        }

        public final void setApprovalRuleTemplateDescription(String approvalRuleTemplateDescription) {
            this.approvalRuleTemplateDescription = approvalRuleTemplateDescription;
        }

        public final String getApprovalRuleTemplateContent() {
            return approvalRuleTemplateContent;
        }

        @Override
        public final Builder approvalRuleTemplateContent(String approvalRuleTemplateContent) {
            this.approvalRuleTemplateContent = approvalRuleTemplateContent;
            return this;
        }

        public final void setApprovalRuleTemplateContent(String approvalRuleTemplateContent) {
            this.approvalRuleTemplateContent = approvalRuleTemplateContent;
        }

        public final String getRuleContentSha256() {
            return ruleContentSha256;
        }

        @Override
        public final Builder ruleContentSha256(String ruleContentSha256) {
            this.ruleContentSha256 = ruleContentSha256;
            return this;
        }

        public final void setRuleContentSha256(String ruleContentSha256) {
            this.ruleContentSha256 = ruleContentSha256;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final String getLastModifiedUser() {
            return lastModifiedUser;
        }

        @Override
        public final Builder lastModifiedUser(String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
            return this;
        }

        public final void setLastModifiedUser(String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
        }

        @Override
        public ApprovalRuleTemplate build() {
            return new ApprovalRuleTemplate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
