/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a create repository operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRepositoryResponse extends CodeCommitResponse implements
        ToCopyableBuilder<CreateRepositoryResponse.Builder, CreateRepositoryResponse> {
    private static final SdkField<RepositoryMetadata> REPOSITORY_METADATA_FIELD = SdkField
            .<RepositoryMetadata> builder(MarshallingType.SDK_POJO).memberName("repositoryMetadata")
            .getter(getter(CreateRepositoryResponse::repositoryMetadata)).setter(setter(Builder::repositoryMetadata))
            .constructor(RepositoryMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryMetadata").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_METADATA_FIELD));

    private final RepositoryMetadata repositoryMetadata;

    private CreateRepositoryResponse(BuilderImpl builder) {
        super(builder);
        this.repositoryMetadata = builder.repositoryMetadata;
    }

    /**
     * <p>
     * Information about the newly created repository.
     * </p>
     * 
     * @return Information about the newly created repository.
     */
    public RepositoryMetadata repositoryMetadata() {
        return repositoryMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(repositoryMetadata());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRepositoryResponse)) {
            return false;
        }
        CreateRepositoryResponse other = (CreateRepositoryResponse) obj;
        return Objects.equals(repositoryMetadata(), other.repositoryMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateRepositoryResponse").add("RepositoryMetadata", repositoryMetadata()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryMetadata":
            return Optional.ofNullable(clazz.cast(repositoryMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRepositoryResponse, T> g) {
        return obj -> g.apply((CreateRepositoryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateRepositoryResponse> {
        /**
         * <p>
         * Information about the newly created repository.
         * </p>
         * 
         * @param repositoryMetadata
         *        Information about the newly created repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryMetadata(RepositoryMetadata repositoryMetadata);

        /**
         * <p>
         * Information about the newly created repository.
         * </p>
         * This is a convenience that creates an instance of the {@link RepositoryMetadata.Builder} avoiding the need to
         * create one manually via {@link RepositoryMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link RepositoryMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #repositoryMetadata(RepositoryMetadata)}.
         * 
         * @param repositoryMetadata
         *        a consumer that will call methods on {@link RepositoryMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #repositoryMetadata(RepositoryMetadata)
         */
        default Builder repositoryMetadata(Consumer<RepositoryMetadata.Builder> repositoryMetadata) {
            return repositoryMetadata(RepositoryMetadata.builder().applyMutation(repositoryMetadata).build());
        }
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private RepositoryMetadata repositoryMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRepositoryResponse model) {
            super(model);
            repositoryMetadata(model.repositoryMetadata);
        }

        public final RepositoryMetadata.Builder getRepositoryMetadata() {
            return repositoryMetadata != null ? repositoryMetadata.toBuilder() : null;
        }

        @Override
        public final Builder repositoryMetadata(RepositoryMetadata repositoryMetadata) {
            this.repositoryMetadata = repositoryMetadata;
            return this;
        }

        public final void setRepositoryMetadata(RepositoryMetadata.BuilderImpl repositoryMetadata) {
            this.repositoryMetadata = repositoryMetadata != null ? repositoryMetadata.build() : null;
        }

        @Override
        public CreateRepositoryResponse build() {
            return new CreateRepositoryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
