/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeletePullRequestApprovalRuleRequest extends CodeCommitRequest implements
        ToCopyableBuilder<DeletePullRequestApprovalRuleRequest.Builder, DeletePullRequestApprovalRuleRequest> {
    private static final SdkField<String> PULL_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pullRequestId").getter(getter(DeletePullRequestApprovalRuleRequest::pullRequestId))
            .setter(setter(Builder::pullRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestId").build()).build();

    private static final SdkField<String> APPROVAL_RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("approvalRuleName").getter(getter(DeletePullRequestApprovalRuleRequest::approvalRuleName))
            .setter(setter(Builder::approvalRuleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRuleName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PULL_REQUEST_ID_FIELD,
            APPROVAL_RULE_NAME_FIELD));

    private final String pullRequestId;

    private final String approvalRuleName;

    private DeletePullRequestApprovalRuleRequest(BuilderImpl builder) {
        super(builder);
        this.pullRequestId = builder.pullRequestId;
        this.approvalRuleName = builder.approvalRuleName;
    }

    /**
     * <p>
     * The system-generated ID of the pull request that contains the approval rule you want to delete.
     * </p>
     * 
     * @return The system-generated ID of the pull request that contains the approval rule you want to delete.
     */
    public String pullRequestId() {
        return pullRequestId;
    }

    /**
     * <p>
     * The name of the approval rule you want to delete.
     * </p>
     * 
     * @return The name of the approval rule you want to delete.
     */
    public String approvalRuleName() {
        return approvalRuleName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pullRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(approvalRuleName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePullRequestApprovalRuleRequest)) {
            return false;
        }
        DeletePullRequestApprovalRuleRequest other = (DeletePullRequestApprovalRuleRequest) obj;
        return Objects.equals(pullRequestId(), other.pullRequestId())
                && Objects.equals(approvalRuleName(), other.approvalRuleName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeletePullRequestApprovalRuleRequest").add("PullRequestId", pullRequestId())
                .add("ApprovalRuleName", approvalRuleName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pullRequestId":
            return Optional.ofNullable(clazz.cast(pullRequestId()));
        case "approvalRuleName":
            return Optional.ofNullable(clazz.cast(approvalRuleName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeletePullRequestApprovalRuleRequest, T> g) {
        return obj -> g.apply((DeletePullRequestApprovalRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeletePullRequestApprovalRuleRequest> {
        /**
         * <p>
         * The system-generated ID of the pull request that contains the approval rule you want to delete.
         * </p>
         * 
         * @param pullRequestId
         *        The system-generated ID of the pull request that contains the approval rule you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pullRequestId(String pullRequestId);

        /**
         * <p>
         * The name of the approval rule you want to delete.
         * </p>
         * 
         * @param approvalRuleName
         *        The name of the approval rule you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalRuleName(String approvalRuleName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeCommitRequest.BuilderImpl implements Builder {
        private String pullRequestId;

        private String approvalRuleName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletePullRequestApprovalRuleRequest model) {
            super(model);
            pullRequestId(model.pullRequestId);
            approvalRuleName(model.approvalRuleName);
        }

        public final String getPullRequestId() {
            return pullRequestId;
        }

        @Override
        public final Builder pullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
            return this;
        }

        public final void setPullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
        }

        public final String getApprovalRuleName() {
            return approvalRuleName;
        }

        @Override
        public final Builder approvalRuleName(String approvalRuleName) {
            this.approvalRuleName = approvalRuleName;
            return this;
        }

        public final void setApprovalRuleName(String approvalRuleName) {
            this.approvalRuleName = approvalRuleName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeletePullRequestApprovalRuleRequest build() {
            return new DeletePullRequestApprovalRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
