/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a get branch operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBranchResponse extends CodeCommitResponse implements
        ToCopyableBuilder<GetBranchResponse.Builder, GetBranchResponse> {
    private static final SdkField<BranchInfo> BRANCH_FIELD = SdkField.<BranchInfo> builder(MarshallingType.SDK_POJO)
            .memberName("branch").getter(getter(GetBranchResponse::branch)).setter(setter(Builder::branch))
            .constructor(BranchInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branch").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRANCH_FIELD));

    private final BranchInfo branch;

    private GetBranchResponse(BuilderImpl builder) {
        super(builder);
        this.branch = builder.branch;
    }

    /**
     * <p>
     * The name of the branch.
     * </p>
     * 
     * @return The name of the branch.
     */
    public BranchInfo branch() {
        return branch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(branch());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBranchResponse)) {
            return false;
        }
        GetBranchResponse other = (GetBranchResponse) obj;
        return Objects.equals(branch(), other.branch());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetBranchResponse").add("Branch", branch()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "branch":
            return Optional.ofNullable(clazz.cast(branch()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBranchResponse, T> g) {
        return obj -> g.apply((GetBranchResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetBranchResponse> {
        /**
         * <p>
         * The name of the branch.
         * </p>
         * 
         * @param branch
         *        The name of the branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branch(BranchInfo branch);

        /**
         * <p>
         * The name of the branch.
         * </p>
         * This is a convenience that creates an instance of the {@link BranchInfo.Builder} avoiding the need to create
         * one manually via {@link BranchInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link BranchInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #branch(BranchInfo)}.
         * 
         * @param branch
         *        a consumer that will call methods on {@link BranchInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #branch(BranchInfo)
         */
        default Builder branch(Consumer<BranchInfo.Builder> branch) {
            return branch(BranchInfo.builder().applyMutation(branch).build());
        }
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private BranchInfo branch;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBranchResponse model) {
            super(model);
            branch(model.branch);
        }

        public final BranchInfo.Builder getBranch() {
            return branch != null ? branch.toBuilder() : null;
        }

        @Override
        public final Builder branch(BranchInfo branch) {
            this.branch = branch;
            return this;
        }

        public final void setBranch(BranchInfo.BuilderImpl branch) {
            this.branch = branch != null ? branch.build() : null;
        }

        @Override
        public GetBranchResponse build() {
            return new GetBranchResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
