/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMergeCommitRequest extends CodeCommitRequest implements
        ToCopyableBuilder<GetMergeCommitRequest.Builder, GetMergeCommitRequest> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(GetMergeCommitRequest::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> SOURCE_COMMIT_SPECIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceCommitSpecifier").getter(getter(GetMergeCommitRequest::sourceCommitSpecifier))
            .setter(setter(Builder::sourceCommitSpecifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCommitSpecifier").build())
            .build();

    private static final SdkField<String> DESTINATION_COMMIT_SPECIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("destinationCommitSpecifier")
            .getter(getter(GetMergeCommitRequest::destinationCommitSpecifier))
            .setter(setter(Builder::destinationCommitSpecifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationCommitSpecifier").build())
            .build();

    private static final SdkField<String> CONFLICT_DETAIL_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("conflictDetailLevel").getter(getter(GetMergeCommitRequest::conflictDetailLevelAsString))
            .setter(setter(Builder::conflictDetailLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conflictDetailLevel").build())
            .build();

    private static final SdkField<String> CONFLICT_RESOLUTION_STRATEGY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("conflictResolutionStrategy")
            .getter(getter(GetMergeCommitRequest::conflictResolutionStrategyAsString))
            .setter(setter(Builder::conflictResolutionStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conflictResolutionStrategy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD,
            SOURCE_COMMIT_SPECIFIER_FIELD, DESTINATION_COMMIT_SPECIFIER_FIELD, CONFLICT_DETAIL_LEVEL_FIELD,
            CONFLICT_RESOLUTION_STRATEGY_FIELD));

    private final String repositoryName;

    private final String sourceCommitSpecifier;

    private final String destinationCommitSpecifier;

    private final String conflictDetailLevel;

    private final String conflictResolutionStrategy;

    private GetMergeCommitRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.sourceCommitSpecifier = builder.sourceCommitSpecifier;
        this.destinationCommitSpecifier = builder.destinationCommitSpecifier;
        this.conflictDetailLevel = builder.conflictDetailLevel;
        this.conflictResolutionStrategy = builder.conflictResolutionStrategy;
    }

    /**
     * <p>
     * The name of the repository that contains the merge commit about which you want to get information.
     * </p>
     * 
     * @return The name of the repository that contains the merge commit about which you want to get information.
     */
    public String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name
     * or a full commit ID).
     * </p>
     * 
     * @return The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a
     *         branch name or a full commit ID).
     */
    public String sourceCommitSpecifier() {
        return sourceCommitSpecifier;
    }

    /**
     * <p>
     * The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name
     * or a full commit ID).
     * </p>
     * 
     * @return The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a
     *         branch name or a full commit ID).
     */
    public String destinationCommitSpecifier() {
        return destinationCommitSpecifier;
    }

    /**
     * <p>
     * The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a
     * not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is
     * considered not mergeable if the same file in both branches has differences on the same line.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #conflictDetailLevel} will return {@link ConflictDetailLevelTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #conflictDetailLevelAsString}.
     * </p>
     * 
     * @return The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a
     *         not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a
     *         conflict is considered not mergeable if the same file in both branches has differences on the same line.
     * @see ConflictDetailLevelTypeEnum
     */
    public ConflictDetailLevelTypeEnum conflictDetailLevel() {
        return ConflictDetailLevelTypeEnum.fromValue(conflictDetailLevel);
    }

    /**
     * <p>
     * The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a
     * not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is
     * considered not mergeable if the same file in both branches has differences on the same line.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #conflictDetailLevel} will return {@link ConflictDetailLevelTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #conflictDetailLevelAsString}.
     * </p>
     * 
     * @return The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a
     *         not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a
     *         conflict is considered not mergeable if the same file in both branches has differences on the same line.
     * @see ConflictDetailLevelTypeEnum
     */
    public String conflictDetailLevelAsString() {
        return conflictDetailLevel;
    }

    /**
     * <p>
     * Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions
     * of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation
     * is successful.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #conflictResolutionStrategy} will return {@link ConflictResolutionStrategyTypeEnum#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #conflictResolutionStrategyAsString}.
     * </p>
     * 
     * @return Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two
     *         versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the
     *         merge operation is successful.
     * @see ConflictResolutionStrategyTypeEnum
     */
    public ConflictResolutionStrategyTypeEnum conflictResolutionStrategy() {
        return ConflictResolutionStrategyTypeEnum.fromValue(conflictResolutionStrategy);
    }

    /**
     * <p>
     * Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions
     * of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation
     * is successful.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #conflictResolutionStrategy} will return {@link ConflictResolutionStrategyTypeEnum#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #conflictResolutionStrategyAsString}.
     * </p>
     * 
     * @return Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two
     *         versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the
     *         merge operation is successful.
     * @see ConflictResolutionStrategyTypeEnum
     */
    public String conflictResolutionStrategyAsString() {
        return conflictResolutionStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceCommitSpecifier());
        hashCode = 31 * hashCode + Objects.hashCode(destinationCommitSpecifier());
        hashCode = 31 * hashCode + Objects.hashCode(conflictDetailLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(conflictResolutionStrategyAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMergeCommitRequest)) {
            return false;
        }
        GetMergeCommitRequest other = (GetMergeCommitRequest) obj;
        return Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(sourceCommitSpecifier(), other.sourceCommitSpecifier())
                && Objects.equals(destinationCommitSpecifier(), other.destinationCommitSpecifier())
                && Objects.equals(conflictDetailLevelAsString(), other.conflictDetailLevelAsString())
                && Objects.equals(conflictResolutionStrategyAsString(), other.conflictResolutionStrategyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetMergeCommitRequest").add("RepositoryName", repositoryName())
                .add("SourceCommitSpecifier", sourceCommitSpecifier())
                .add("DestinationCommitSpecifier", destinationCommitSpecifier())
                .add("ConflictDetailLevel", conflictDetailLevelAsString())
                .add("ConflictResolutionStrategy", conflictResolutionStrategyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "sourceCommitSpecifier":
            return Optional.ofNullable(clazz.cast(sourceCommitSpecifier()));
        case "destinationCommitSpecifier":
            return Optional.ofNullable(clazz.cast(destinationCommitSpecifier()));
        case "conflictDetailLevel":
            return Optional.ofNullable(clazz.cast(conflictDetailLevelAsString()));
        case "conflictResolutionStrategy":
            return Optional.ofNullable(clazz.cast(conflictResolutionStrategyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMergeCommitRequest, T> g) {
        return obj -> g.apply((GetMergeCommitRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetMergeCommitRequest> {
        /**
         * <p>
         * The name of the repository that contains the merge commit about which you want to get information.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository that contains the merge commit about which you want to get information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch
         * name or a full commit ID).
         * </p>
         * 
         * @param sourceCommitSpecifier
         *        The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a
         *        branch name or a full commit ID).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCommitSpecifier(String sourceCommitSpecifier);

        /**
         * <p>
         * The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch
         * name or a full commit ID).
         * </p>
         * 
         * @param destinationCommitSpecifier
         *        The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a
         *        branch name or a full commit ID).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCommitSpecifier(String destinationCommitSpecifier);

        /**
         * <p>
         * The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a
         * not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a
         * conflict is considered not mergeable if the same file in both branches has differences on the same line.
         * </p>
         * 
         * @param conflictDetailLevel
         *        The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a
         *        not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a
         *        conflict is considered not mergeable if the same file in both branches has differences on the same
         *        line.
         * @see ConflictDetailLevelTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConflictDetailLevelTypeEnum
         */
        Builder conflictDetailLevel(String conflictDetailLevel);

        /**
         * <p>
         * The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a
         * not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a
         * conflict is considered not mergeable if the same file in both branches has differences on the same line.
         * </p>
         * 
         * @param conflictDetailLevel
         *        The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a
         *        not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a
         *        conflict is considered not mergeable if the same file in both branches has differences on the same
         *        line.
         * @see ConflictDetailLevelTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConflictDetailLevelTypeEnum
         */
        Builder conflictDetailLevel(ConflictDetailLevelTypeEnum conflictDetailLevel);

        /**
         * <p>
         * Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two
         * versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the
         * merge operation is successful.
         * </p>
         * 
         * @param conflictResolutionStrategy
         *        Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging
         *        two versions of a file. The default is NONE, which requires any conflicts to be resolved manually
         *        before the merge operation is successful.
         * @see ConflictResolutionStrategyTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConflictResolutionStrategyTypeEnum
         */
        Builder conflictResolutionStrategy(String conflictResolutionStrategy);

        /**
         * <p>
         * Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two
         * versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the
         * merge operation is successful.
         * </p>
         * 
         * @param conflictResolutionStrategy
         *        Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging
         *        two versions of a file. The default is NONE, which requires any conflicts to be resolved manually
         *        before the merge operation is successful.
         * @see ConflictResolutionStrategyTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConflictResolutionStrategyTypeEnum
         */
        Builder conflictResolutionStrategy(ConflictResolutionStrategyTypeEnum conflictResolutionStrategy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeCommitRequest.BuilderImpl implements Builder {
        private String repositoryName;

        private String sourceCommitSpecifier;

        private String destinationCommitSpecifier;

        private String conflictDetailLevel;

        private String conflictResolutionStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMergeCommitRequest model) {
            super(model);
            repositoryName(model.repositoryName);
            sourceCommitSpecifier(model.sourceCommitSpecifier);
            destinationCommitSpecifier(model.destinationCommitSpecifier);
            conflictDetailLevel(model.conflictDetailLevel);
            conflictResolutionStrategy(model.conflictResolutionStrategy);
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getSourceCommitSpecifier() {
            return sourceCommitSpecifier;
        }

        @Override
        public final Builder sourceCommitSpecifier(String sourceCommitSpecifier) {
            this.sourceCommitSpecifier = sourceCommitSpecifier;
            return this;
        }

        public final void setSourceCommitSpecifier(String sourceCommitSpecifier) {
            this.sourceCommitSpecifier = sourceCommitSpecifier;
        }

        public final String getDestinationCommitSpecifier() {
            return destinationCommitSpecifier;
        }

        @Override
        public final Builder destinationCommitSpecifier(String destinationCommitSpecifier) {
            this.destinationCommitSpecifier = destinationCommitSpecifier;
            return this;
        }

        public final void setDestinationCommitSpecifier(String destinationCommitSpecifier) {
            this.destinationCommitSpecifier = destinationCommitSpecifier;
        }

        public final String getConflictDetailLevel() {
            return conflictDetailLevel;
        }

        @Override
        public final Builder conflictDetailLevel(String conflictDetailLevel) {
            this.conflictDetailLevel = conflictDetailLevel;
            return this;
        }

        @Override
        public final Builder conflictDetailLevel(ConflictDetailLevelTypeEnum conflictDetailLevel) {
            this.conflictDetailLevel(conflictDetailLevel == null ? null : conflictDetailLevel.toString());
            return this;
        }

        public final void setConflictDetailLevel(String conflictDetailLevel) {
            this.conflictDetailLevel = conflictDetailLevel;
        }

        public final String getConflictResolutionStrategy() {
            return conflictResolutionStrategy;
        }

        @Override
        public final Builder conflictResolutionStrategy(String conflictResolutionStrategy) {
            this.conflictResolutionStrategy = conflictResolutionStrategy;
            return this;
        }

        @Override
        public final Builder conflictResolutionStrategy(ConflictResolutionStrategyTypeEnum conflictResolutionStrategy) {
            this.conflictResolutionStrategy(conflictResolutionStrategy == null ? null : conflictResolutionStrategy.toString());
            return this;
        }

        public final void setConflictResolutionStrategy(String conflictResolutionStrategy) {
            this.conflictResolutionStrategy = conflictResolutionStrategy;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMergeCommitRequest build() {
            return new GetMergeCommitRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
