/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListApprovalRuleTemplatesResponse extends CodeCommitResponse implements
        ToCopyableBuilder<ListApprovalRuleTemplatesResponse.Builder, ListApprovalRuleTemplatesResponse> {
    private static final SdkField<List<String>> APPROVAL_RULE_TEMPLATE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("approvalRuleTemplateNames")
            .getter(getter(ListApprovalRuleTemplatesResponse::approvalRuleTemplateNames))
            .setter(setter(Builder::approvalRuleTemplateNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRuleTemplateNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListApprovalRuleTemplatesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            APPROVAL_RULE_TEMPLATE_NAMES_FIELD, NEXT_TOKEN_FIELD));

    private final List<String> approvalRuleTemplateNames;

    private final String nextToken;

    private ListApprovalRuleTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.approvalRuleTemplateNames = builder.approvalRuleTemplateNames;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ApprovalRuleTemplateNames property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasApprovalRuleTemplateNames() {
        return approvalRuleTemplateNames != null && !(approvalRuleTemplateNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of all the approval rule templates found in the AWS Region for your AWS account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasApprovalRuleTemplateNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The names of all the approval rule templates found in the AWS Region for your AWS account.
     */
    public List<String> approvalRuleTemplateNames() {
        return approvalRuleTemplateNames;
    }

    /**
     * <p>
     * An enumeration token that allows the operation to batch the next results of the operation.
     * </p>
     * 
     * @return An enumeration token that allows the operation to batch the next results of the operation.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasApprovalRuleTemplateNames() ? approvalRuleTemplateNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApprovalRuleTemplatesResponse)) {
            return false;
        }
        ListApprovalRuleTemplatesResponse other = (ListApprovalRuleTemplatesResponse) obj;
        return hasApprovalRuleTemplateNames() == other.hasApprovalRuleTemplateNames()
                && Objects.equals(approvalRuleTemplateNames(), other.approvalRuleTemplateNames())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListApprovalRuleTemplatesResponse")
                .add("ApprovalRuleTemplateNames", hasApprovalRuleTemplateNames() ? approvalRuleTemplateNames() : null)
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "approvalRuleTemplateNames":
            return Optional.ofNullable(clazz.cast(approvalRuleTemplateNames()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListApprovalRuleTemplatesResponse, T> g) {
        return obj -> g.apply((ListApprovalRuleTemplatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListApprovalRuleTemplatesResponse> {
        /**
         * <p>
         * The names of all the approval rule templates found in the AWS Region for your AWS account.
         * </p>
         * 
         * @param approvalRuleTemplateNames
         *        The names of all the approval rule templates found in the AWS Region for your AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalRuleTemplateNames(Collection<String> approvalRuleTemplateNames);

        /**
         * <p>
         * The names of all the approval rule templates found in the AWS Region for your AWS account.
         * </p>
         * 
         * @param approvalRuleTemplateNames
         *        The names of all the approval rule templates found in the AWS Region for your AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalRuleTemplateNames(String... approvalRuleTemplateNames);

        /**
         * <p>
         * An enumeration token that allows the operation to batch the next results of the operation.
         * </p>
         * 
         * @param nextToken
         *        An enumeration token that allows the operation to batch the next results of the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private List<String> approvalRuleTemplateNames = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApprovalRuleTemplatesResponse model) {
            super(model);
            approvalRuleTemplateNames(model.approvalRuleTemplateNames);
            nextToken(model.nextToken);
        }

        public final Collection<String> getApprovalRuleTemplateNames() {
            if (approvalRuleTemplateNames instanceof SdkAutoConstructList) {
                return null;
            }
            return approvalRuleTemplateNames;
        }

        @Override
        public final Builder approvalRuleTemplateNames(Collection<String> approvalRuleTemplateNames) {
            this.approvalRuleTemplateNames = ApprovalRuleTemplateNameListCopier.copy(approvalRuleTemplateNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvalRuleTemplateNames(String... approvalRuleTemplateNames) {
            approvalRuleTemplateNames(Arrays.asList(approvalRuleTemplateNames));
            return this;
        }

        public final void setApprovalRuleTemplateNames(Collection<String> approvalRuleTemplateNames) {
            this.approvalRuleTemplateNames = ApprovalRuleTemplateNameListCopier.copy(approvalRuleTemplateNames);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListApprovalRuleTemplatesResponse build() {
            return new ListApprovalRuleTemplatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
