/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a test repository triggers operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestRepositoryTriggersRequest extends CodeCommitRequest implements
        ToCopyableBuilder<TestRepositoryTriggersRequest.Builder, TestRepositoryTriggersRequest> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(TestRepositoryTriggersRequest::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<List<RepositoryTrigger>> TRIGGERS_FIELD = SdkField
            .<List<RepositoryTrigger>> builder(MarshallingType.LIST)
            .memberName("triggers")
            .getter(getter(TestRepositoryTriggersRequest::triggers))
            .setter(setter(Builder::triggers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RepositoryTrigger> builder(MarshallingType.SDK_POJO)
                                            .constructor(RepositoryTrigger::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD,
            TRIGGERS_FIELD));

    private final String repositoryName;

    private final List<RepositoryTrigger> triggers;

    private TestRepositoryTriggersRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.triggers = builder.triggers;
    }

    /**
     * <p>
     * The name of the repository in which to test the triggers.
     * </p>
     * 
     * @return The name of the repository in which to test the triggers.
     */
    public String repositoryName() {
        return repositoryName;
    }

    /**
     * Returns true if the Triggers property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTriggers() {
        return triggers != null && !(triggers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of triggers to test.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTriggers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of triggers to test.
     */
    public List<RepositoryTrigger> triggers() {
        return triggers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTriggers() ? triggers() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestRepositoryTriggersRequest)) {
            return false;
        }
        TestRepositoryTriggersRequest other = (TestRepositoryTriggersRequest) obj;
        return Objects.equals(repositoryName(), other.repositoryName()) && hasTriggers() == other.hasTriggers()
                && Objects.equals(triggers(), other.triggers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TestRepositoryTriggersRequest").add("RepositoryName", repositoryName())
                .add("Triggers", hasTriggers() ? triggers() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "triggers":
            return Optional.ofNullable(clazz.cast(triggers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestRepositoryTriggersRequest, T> g) {
        return obj -> g.apply((TestRepositoryTriggersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitRequest.Builder, SdkPojo, CopyableBuilder<Builder, TestRepositoryTriggersRequest> {
        /**
         * <p>
         * The name of the repository in which to test the triggers.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository in which to test the triggers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The list of triggers to test.
         * </p>
         * 
         * @param triggers
         *        The list of triggers to test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggers(Collection<RepositoryTrigger> triggers);

        /**
         * <p>
         * The list of triggers to test.
         * </p>
         * 
         * @param triggers
         *        The list of triggers to test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggers(RepositoryTrigger... triggers);

        /**
         * <p>
         * The list of triggers to test.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RepositoryTrigger>.Builder} avoiding the
         * need to create one manually via {@link List<RepositoryTrigger>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RepositoryTrigger>.Builder#build()} is called immediately
         * and its result is passed to {@link #triggers(List<RepositoryTrigger>)}.
         * 
         * @param triggers
         *        a consumer that will call methods on {@link List<RepositoryTrigger>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #triggers(List<RepositoryTrigger>)
         */
        Builder triggers(Consumer<RepositoryTrigger.Builder>... triggers);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeCommitRequest.BuilderImpl implements Builder {
        private String repositoryName;

        private List<RepositoryTrigger> triggers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TestRepositoryTriggersRequest model) {
            super(model);
            repositoryName(model.repositoryName);
            triggers(model.triggers);
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final Collection<RepositoryTrigger.Builder> getTriggers() {
            if (triggers instanceof SdkAutoConstructList) {
                return null;
            }
            return triggers != null ? triggers.stream().map(RepositoryTrigger::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder triggers(Collection<RepositoryTrigger> triggers) {
            this.triggers = RepositoryTriggersListCopier.copy(triggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(RepositoryTrigger... triggers) {
            triggers(Arrays.asList(triggers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(Consumer<RepositoryTrigger.Builder>... triggers) {
            triggers(Stream.of(triggers).map(c -> RepositoryTrigger.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTriggers(Collection<RepositoryTrigger.BuilderImpl> triggers) {
            this.triggers = RepositoryTriggersListCopier.copyFromBuilder(triggers);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestRepositoryTriggersRequest build() {
            return new TestRepositoryTriggersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
