/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of an update default branch operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDefaultBranchRequest extends CodeCommitRequest implements
        ToCopyableBuilder<UpdateDefaultBranchRequest.Builder, UpdateDefaultBranchRequest> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(UpdateDefaultBranchRequest::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> DEFAULT_BRANCH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultBranchName").getter(getter(UpdateDefaultBranchRequest::defaultBranchName))
            .setter(setter(Builder::defaultBranchName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultBranchName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD,
            DEFAULT_BRANCH_NAME_FIELD));

    private final String repositoryName;

    private final String defaultBranchName;

    private UpdateDefaultBranchRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.defaultBranchName = builder.defaultBranchName;
    }

    /**
     * <p>
     * The name of the repository to set or change the default branch for.
     * </p>
     * 
     * @return The name of the repository to set or change the default branch for.
     */
    public String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The name of the branch to set as the default.
     * </p>
     * 
     * @return The name of the branch to set as the default.
     */
    public String defaultBranchName() {
        return defaultBranchName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(defaultBranchName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDefaultBranchRequest)) {
            return false;
        }
        UpdateDefaultBranchRequest other = (UpdateDefaultBranchRequest) obj;
        return Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(defaultBranchName(), other.defaultBranchName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateDefaultBranchRequest").add("RepositoryName", repositoryName())
                .add("DefaultBranchName", defaultBranchName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "defaultBranchName":
            return Optional.ofNullable(clazz.cast(defaultBranchName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDefaultBranchRequest, T> g) {
        return obj -> g.apply((UpdateDefaultBranchRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDefaultBranchRequest> {
        /**
         * <p>
         * The name of the repository to set or change the default branch for.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository to set or change the default branch for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The name of the branch to set as the default.
         * </p>
         * 
         * @param defaultBranchName
         *        The name of the branch to set as the default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultBranchName(String defaultBranchName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeCommitRequest.BuilderImpl implements Builder {
        private String repositoryName;

        private String defaultBranchName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDefaultBranchRequest model) {
            super(model);
            repositoryName(model.repositoryName);
            defaultBranchName(model.defaultBranchName);
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getDefaultBranchName() {
            return defaultBranchName;
        }

        @Override
        public final Builder defaultBranchName(String defaultBranchName) {
            this.defaultBranchName = defaultBranchName;
            return this;
        }

        public final void setDefaultBranchName(String defaultBranchName) {
            this.defaultBranchName = defaultBranchName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDefaultBranchRequest build() {
            return new UpdateDefaultBranchRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
