/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Folder
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Folder> {
    private static final SdkField<String> TREE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("treeId").getter(Folder.getter(Folder::treeId)).setter(Folder.setter(Builder::treeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("treeId").build()}).build();
    private static final SdkField<String> ABSOLUTE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("absolutePath").getter(Folder.getter(Folder::absolutePath)).setter(Folder.setter(Builder::absolutePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("absolutePath").build()}).build();
    private static final SdkField<String> RELATIVE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("relativePath").getter(Folder.getter(Folder::relativePath)).setter(Folder.setter(Builder::relativePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relativePath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TREE_ID_FIELD, ABSOLUTE_PATH_FIELD, RELATIVE_PATH_FIELD));
    private static final long serialVersionUID = 1L;
    private final String treeId;
    private final String absolutePath;
    private final String relativePath;

    private Folder(BuilderImpl builder) {
        this.treeId = builder.treeId;
        this.absolutePath = builder.absolutePath;
        this.relativePath = builder.relativePath;
    }

    public String treeId() {
        return this.treeId;
    }

    public String absolutePath() {
        return this.absolutePath;
    }

    public String relativePath() {
        return this.relativePath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.treeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.absolutePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.relativePath());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Folder)) {
            return false;
        }
        Folder other = (Folder)obj;
        return Objects.equals(this.treeId(), other.treeId()) && Objects.equals(this.absolutePath(), other.absolutePath()) && Objects.equals(this.relativePath(), other.relativePath());
    }

    public String toString() {
        return ToString.builder((String)"Folder").add("TreeId", (Object)this.treeId()).add("AbsolutePath", (Object)this.absolutePath()).add("RelativePath", (Object)this.relativePath()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "treeId": {
                return Optional.ofNullable(clazz.cast(this.treeId()));
            }
            case "absolutePath": {
                return Optional.ofNullable(clazz.cast(this.absolutePath()));
            }
            case "relativePath": {
                return Optional.ofNullable(clazz.cast(this.relativePath()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Folder, T> g) {
        return obj -> g.apply((Folder)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String treeId;
        private String absolutePath;
        private String relativePath;

        private BuilderImpl() {
        }

        private BuilderImpl(Folder model) {
            this.treeId(model.treeId);
            this.absolutePath(model.absolutePath);
            this.relativePath(model.relativePath);
        }

        public final String getTreeId() {
            return this.treeId;
        }

        @Override
        public final Builder treeId(String treeId) {
            this.treeId = treeId;
            return this;
        }

        public final void setTreeId(String treeId) {
            this.treeId = treeId;
        }

        public final String getAbsolutePath() {
            return this.absolutePath;
        }

        @Override
        public final Builder absolutePath(String absolutePath) {
            this.absolutePath = absolutePath;
            return this;
        }

        public final void setAbsolutePath(String absolutePath) {
            this.absolutePath = absolutePath;
        }

        public final String getRelativePath() {
            return this.relativePath;
        }

        @Override
        public final Builder relativePath(String relativePath) {
            this.relativePath = relativePath;
            return this;
        }

        public final void setRelativePath(String relativePath) {
            this.relativePath = relativePath;
        }

        public Folder build() {
            return new Folder(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Folder> {
        public Builder treeId(String var1);

        public Builder absolutePath(String var1);

        public Builder relativePath(String var1);
    }
}

