/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.CodeCommitRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFolderRequest
extends CodeCommitRequest
implements ToCopyableBuilder<Builder, GetFolderRequest> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(GetFolderRequest.getter(GetFolderRequest::repositoryName)).setter(GetFolderRequest.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<String> COMMIT_SPECIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("commitSpecifier").getter(GetFolderRequest.getter(GetFolderRequest::commitSpecifier)).setter(GetFolderRequest.setter(Builder::commitSpecifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitSpecifier").build()}).build();
    private static final SdkField<String> FOLDER_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("folderPath").getter(GetFolderRequest.getter(GetFolderRequest::folderPath)).setter(GetFolderRequest.setter(Builder::folderPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("folderPath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD, COMMIT_SPECIFIER_FIELD, FOLDER_PATH_FIELD));
    private final String repositoryName;
    private final String commitSpecifier;
    private final String folderPath;

    private GetFolderRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.commitSpecifier = builder.commitSpecifier;
        this.folderPath = builder.folderPath;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public String commitSpecifier() {
        return this.commitSpecifier;
    }

    public String folderPath() {
        return this.folderPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.commitSpecifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.folderPath());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFolderRequest)) {
            return false;
        }
        GetFolderRequest other = (GetFolderRequest)((Object)obj);
        return Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.commitSpecifier(), other.commitSpecifier()) && Objects.equals(this.folderPath(), other.folderPath());
    }

    public String toString() {
        return ToString.builder((String)"GetFolderRequest").add("RepositoryName", (Object)this.repositoryName()).add("CommitSpecifier", (Object)this.commitSpecifier()).add("FolderPath", (Object)this.folderPath()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "commitSpecifier": {
                return Optional.ofNullable(clazz.cast(this.commitSpecifier()));
            }
            case "folderPath": {
                return Optional.ofNullable(clazz.cast(this.folderPath()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFolderRequest, T> g) {
        return obj -> g.apply((GetFolderRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitRequest.BuilderImpl
    implements Builder {
        private String repositoryName;
        private String commitSpecifier;
        private String folderPath;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFolderRequest model) {
            super(model);
            this.repositoryName(model.repositoryName);
            this.commitSpecifier(model.commitSpecifier);
            this.folderPath(model.folderPath);
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getCommitSpecifier() {
            return this.commitSpecifier;
        }

        @Override
        public final Builder commitSpecifier(String commitSpecifier) {
            this.commitSpecifier = commitSpecifier;
            return this;
        }

        public final void setCommitSpecifier(String commitSpecifier) {
            this.commitSpecifier = commitSpecifier;
        }

        public final String getFolderPath() {
            return this.folderPath;
        }

        @Override
        public final Builder folderPath(String folderPath) {
            this.folderPath = folderPath;
            return this;
        }

        public final void setFolderPath(String folderPath) {
            this.folderPath = folderPath;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetFolderRequest build() {
            return new GetFolderRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCommitRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetFolderRequest> {
        public Builder repositoryName(String var1);

        public Builder commitSpecifier(String var1);

        public Builder folderPath(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

