/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchAssociateApprovalRuleTemplateWithRepositoriesResponse extends CodeCommitResponse
        implements
        ToCopyableBuilder<BatchAssociateApprovalRuleTemplateWithRepositoriesResponse.Builder, BatchAssociateApprovalRuleTemplateWithRepositoriesResponse> {
    private static final SdkField<List<String>> ASSOCIATED_REPOSITORY_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("associatedRepositoryNames")
            .getter(getter(BatchAssociateApprovalRuleTemplateWithRepositoriesResponse::associatedRepositoryNames))
            .setter(setter(Builder::associatedRepositoryNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedRepositoryNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BatchAssociateApprovalRuleTemplateWithRepositoriesError>> ERRORS_FIELD = SdkField
            .<List<BatchAssociateApprovalRuleTemplateWithRepositoriesError>> builder(MarshallingType.LIST)
            .memberName("errors")
            .getter(getter(BatchAssociateApprovalRuleTemplateWithRepositoriesResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchAssociateApprovalRuleTemplateWithRepositoriesError> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(BatchAssociateApprovalRuleTemplateWithRepositoriesError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ASSOCIATED_REPOSITORY_NAMES_FIELD, ERRORS_FIELD));

    private final List<String> associatedRepositoryNames;

    private final List<BatchAssociateApprovalRuleTemplateWithRepositoriesError> errors;

    private BatchAssociateApprovalRuleTemplateWithRepositoriesResponse(BuilderImpl builder) {
        super(builder);
        this.associatedRepositoryNames = builder.associatedRepositoryNames;
        this.errors = builder.errors;
    }

    /**
     * Returns true if the AssociatedRepositoryNames property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAssociatedRepositoryNames() {
        return associatedRepositoryNames != null && !(associatedRepositoryNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of names of the repositories that have been associated with the template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAssociatedRepositoryNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of names of the repositories that have been associated with the template.
     */
    public List<String> associatedRepositoryNames() {
        return associatedRepositoryNames;
    }

    /**
     * Returns true if the Errors property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of any errors that might have occurred while attempting to create the association between the template and
     * the repositories.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasErrors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of any errors that might have occurred while attempting to create the association between the
     *         template and the repositories.
     */
    public List<BatchAssociateApprovalRuleTemplateWithRepositoriesError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociatedRepositoryNames() ? associatedRepositoryNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAssociateApprovalRuleTemplateWithRepositoriesResponse)) {
            return false;
        }
        BatchAssociateApprovalRuleTemplateWithRepositoriesResponse other = (BatchAssociateApprovalRuleTemplateWithRepositoriesResponse) obj;
        return hasAssociatedRepositoryNames() == other.hasAssociatedRepositoryNames()
                && Objects.equals(associatedRepositoryNames(), other.associatedRepositoryNames())
                && hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchAssociateApprovalRuleTemplateWithRepositoriesResponse")
                .add("AssociatedRepositoryNames", hasAssociatedRepositoryNames() ? associatedRepositoryNames() : null)
                .add("Errors", hasErrors() ? errors() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "associatedRepositoryNames":
            return Optional.ofNullable(clazz.cast(associatedRepositoryNames()));
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchAssociateApprovalRuleTemplateWithRepositoriesResponse, T> g) {
        return obj -> g.apply((BatchAssociateApprovalRuleTemplateWithRepositoriesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchAssociateApprovalRuleTemplateWithRepositoriesResponse> {
        /**
         * <p>
         * A list of names of the repositories that have been associated with the template.
         * </p>
         * 
         * @param associatedRepositoryNames
         *        A list of names of the repositories that have been associated with the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedRepositoryNames(Collection<String> associatedRepositoryNames);

        /**
         * <p>
         * A list of names of the repositories that have been associated with the template.
         * </p>
         * 
         * @param associatedRepositoryNames
         *        A list of names of the repositories that have been associated with the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedRepositoryNames(String... associatedRepositoryNames);

        /**
         * <p>
         * A list of any errors that might have occurred while attempting to create the association between the template
         * and the repositories.
         * </p>
         * 
         * @param errors
         *        A list of any errors that might have occurred while attempting to create the association between the
         *        template and the repositories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<BatchAssociateApprovalRuleTemplateWithRepositoriesError> errors);

        /**
         * <p>
         * A list of any errors that might have occurred while attempting to create the association between the template
         * and the repositories.
         * </p>
         * 
         * @param errors
         *        A list of any errors that might have occurred while attempting to create the association between the
         *        template and the repositories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(BatchAssociateApprovalRuleTemplateWithRepositoriesError... errors);

        /**
         * <p>
         * A list of any errors that might have occurred while attempting to create the association between the template
         * and the repositories.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <BatchAssociateApprovalRuleTemplateWithRepositoriesError>.Builder} avoiding the need to create one manually
         * via {@link List<BatchAssociateApprovalRuleTemplateWithRepositoriesError>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <BatchAssociateApprovalRuleTemplateWithRepositoriesError>.Builder#build()} is called immediately and its
         * result is passed to {@link #errors(List<BatchAssociateApprovalRuleTemplateWithRepositoriesError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on {@link List
         *        <BatchAssociateApprovalRuleTemplateWithRepositoriesError>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(List<BatchAssociateApprovalRuleTemplateWithRepositoriesError>)
         */
        Builder errors(Consumer<BatchAssociateApprovalRuleTemplateWithRepositoriesError.Builder>... errors);
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private List<String> associatedRepositoryNames = DefaultSdkAutoConstructList.getInstance();

        private List<BatchAssociateApprovalRuleTemplateWithRepositoriesError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAssociateApprovalRuleTemplateWithRepositoriesResponse model) {
            super(model);
            associatedRepositoryNames(model.associatedRepositoryNames);
            errors(model.errors);
        }

        public final Collection<String> getAssociatedRepositoryNames() {
            if (associatedRepositoryNames instanceof SdkAutoConstructList) {
                return null;
            }
            return associatedRepositoryNames;
        }

        @Override
        public final Builder associatedRepositoryNames(Collection<String> associatedRepositoryNames) {
            this.associatedRepositoryNames = RepositoryNameListCopier.copy(associatedRepositoryNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedRepositoryNames(String... associatedRepositoryNames) {
            associatedRepositoryNames(Arrays.asList(associatedRepositoryNames));
            return this;
        }

        public final void setAssociatedRepositoryNames(Collection<String> associatedRepositoryNames) {
            this.associatedRepositoryNames = RepositoryNameListCopier.copy(associatedRepositoryNames);
        }

        public final Collection<BatchAssociateApprovalRuleTemplateWithRepositoriesError.Builder> getErrors() {
            if (errors instanceof SdkAutoConstructList) {
                return null;
            }
            return errors != null ? errors.stream().map(BatchAssociateApprovalRuleTemplateWithRepositoriesError::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errors(Collection<BatchAssociateApprovalRuleTemplateWithRepositoriesError> errors) {
            this.errors = BatchAssociateApprovalRuleTemplateWithRepositoriesErrorsListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchAssociateApprovalRuleTemplateWithRepositoriesError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchAssociateApprovalRuleTemplateWithRepositoriesError.Builder>... errors) {
            errors(Stream.of(errors)
                    .map(c -> BatchAssociateApprovalRuleTemplateWithRepositoriesError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setErrors(Collection<BatchAssociateApprovalRuleTemplateWithRepositoriesError.BuilderImpl> errors) {
            this.errors = BatchAssociateApprovalRuleTemplateWithRepositoriesErrorsListCopier.copyFromBuilder(errors);
        }

        @Override
        public BatchAssociateApprovalRuleTemplateWithRepositoriesResponse build() {
            return new BatchAssociateApprovalRuleTemplateWithRepositoriesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
