/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a repository.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RepositoryMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<RepositoryMetadata.Builder, RepositoryMetadata> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(RepositoryMetadata::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<String> REPOSITORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryId").getter(getter(RepositoryMetadata::repositoryId)).setter(setter(Builder::repositoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryId").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(RepositoryMetadata::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> REPOSITORY_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryDescription").getter(getter(RepositoryMetadata::repositoryDescription))
            .setter(setter(Builder::repositoryDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryDescription").build())
            .build();

    private static final SdkField<String> DEFAULT_BRANCH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultBranch").getter(getter(RepositoryMetadata::defaultBranch)).setter(setter(Builder::defaultBranch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultBranch").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedDate").getter(getter(RepositoryMetadata::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate").getter(getter(RepositoryMetadata::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final SdkField<String> CLONE_URL_HTTP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cloneUrlHttp").getter(getter(RepositoryMetadata::cloneUrlHttp)).setter(setter(Builder::cloneUrlHttp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloneUrlHttp").build()).build();

    private static final SdkField<String> CLONE_URL_SSH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cloneUrlSsh").getter(getter(RepositoryMetadata::cloneUrlSsh)).setter(setter(Builder::cloneUrlSsh))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloneUrlSsh").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(RepositoryMetadata::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            REPOSITORY_ID_FIELD, REPOSITORY_NAME_FIELD, REPOSITORY_DESCRIPTION_FIELD, DEFAULT_BRANCH_FIELD,
            LAST_MODIFIED_DATE_FIELD, CREATION_DATE_FIELD, CLONE_URL_HTTP_FIELD, CLONE_URL_SSH_FIELD, ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String repositoryId;

    private final String repositoryName;

    private final String repositoryDescription;

    private final String defaultBranch;

    private final Instant lastModifiedDate;

    private final Instant creationDate;

    private final String cloneUrlHttp;

    private final String cloneUrlSsh;

    private final String arn;

    private RepositoryMetadata(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.repositoryId = builder.repositoryId;
        this.repositoryName = builder.repositoryName;
        this.repositoryDescription = builder.repositoryDescription;
        this.defaultBranch = builder.defaultBranch;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.creationDate = builder.creationDate;
        this.cloneUrlHttp = builder.cloneUrlHttp;
        this.cloneUrlSsh = builder.cloneUrlSsh;
        this.arn = builder.arn;
    }

    /**
     * <p>
     * The ID of the AWS account associated with the repository.
     * </p>
     * 
     * @return The ID of the AWS account associated with the repository.
     */
    public String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The ID of the repository.
     * </p>
     * 
     * @return The ID of the repository.
     */
    public String repositoryId() {
        return repositoryId;
    }

    /**
     * <p>
     * The repository's name.
     * </p>
     * 
     * @return The repository's name.
     */
    public String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * A comment or description about the repository.
     * </p>
     * 
     * @return A comment or description about the repository.
     */
    public String repositoryDescription() {
        return repositoryDescription;
    }

    /**
     * <p>
     * The repository's default branch name.
     * </p>
     * 
     * @return The repository's default branch name.
     */
    public String defaultBranch() {
        return defaultBranch;
    }

    /**
     * <p>
     * The date and time the repository was last modified, in timestamp format.
     * </p>
     * 
     * @return The date and time the repository was last modified, in timestamp format.
     */
    public Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The date and time the repository was created, in timestamp format.
     * </p>
     * 
     * @return The date and time the repository was created, in timestamp format.
     */
    public Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The URL to use for cloning the repository over HTTPS.
     * </p>
     * 
     * @return The URL to use for cloning the repository over HTTPS.
     */
    public String cloneUrlHttp() {
        return cloneUrlHttp;
    }

    /**
     * <p>
     * The URL to use for cloning the repository over SSH.
     * </p>
     * 
     * @return The URL to use for cloning the repository over SSH.
     */
    public String cloneUrlSsh() {
        return cloneUrlSsh;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the repository.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the repository.
     */
    public String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryId());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryDescription());
        hashCode = 31 * hashCode + Objects.hashCode(defaultBranch());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(cloneUrlHttp());
        hashCode = 31 * hashCode + Objects.hashCode(cloneUrlSsh());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositoryMetadata)) {
            return false;
        }
        RepositoryMetadata other = (RepositoryMetadata) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(repositoryId(), other.repositoryId())
                && Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(repositoryDescription(), other.repositoryDescription())
                && Objects.equals(defaultBranch(), other.defaultBranch())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(creationDate(), other.creationDate()) && Objects.equals(cloneUrlHttp(), other.cloneUrlHttp())
                && Objects.equals(cloneUrlSsh(), other.cloneUrlSsh()) && Objects.equals(arn(), other.arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RepositoryMetadata").add("AccountId", accountId()).add("RepositoryId", repositoryId())
                .add("RepositoryName", repositoryName()).add("RepositoryDescription", repositoryDescription())
                .add("DefaultBranch", defaultBranch()).add("LastModifiedDate", lastModifiedDate())
                .add("CreationDate", creationDate()).add("CloneUrlHttp", cloneUrlHttp()).add("CloneUrlSsh", cloneUrlSsh())
                .add("Arn", arn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "repositoryId":
            return Optional.ofNullable(clazz.cast(repositoryId()));
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "repositoryDescription":
            return Optional.ofNullable(clazz.cast(repositoryDescription()));
        case "defaultBranch":
            return Optional.ofNullable(clazz.cast(defaultBranch()));
        case "lastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "cloneUrlHttp":
            return Optional.ofNullable(clazz.cast(cloneUrlHttp()));
        case "cloneUrlSsh":
            return Optional.ofNullable(clazz.cast(cloneUrlSsh()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RepositoryMetadata, T> g) {
        return obj -> g.apply((RepositoryMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RepositoryMetadata> {
        /**
         * <p>
         * The ID of the AWS account associated with the repository.
         * </p>
         * 
         * @param accountId
         *        The ID of the AWS account associated with the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The ID of the repository.
         * </p>
         * 
         * @param repositoryId
         *        The ID of the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryId(String repositoryId);

        /**
         * <p>
         * The repository's name.
         * </p>
         * 
         * @param repositoryName
         *        The repository's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * A comment or description about the repository.
         * </p>
         * 
         * @param repositoryDescription
         *        A comment or description about the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryDescription(String repositoryDescription);

        /**
         * <p>
         * The repository's default branch name.
         * </p>
         * 
         * @param defaultBranch
         *        The repository's default branch name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultBranch(String defaultBranch);

        /**
         * <p>
         * The date and time the repository was last modified, in timestamp format.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date and time the repository was last modified, in timestamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);

        /**
         * <p>
         * The date and time the repository was created, in timestamp format.
         * </p>
         * 
         * @param creationDate
         *        The date and time the repository was created, in timestamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The URL to use for cloning the repository over HTTPS.
         * </p>
         * 
         * @param cloneUrlHttp
         *        The URL to use for cloning the repository over HTTPS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloneUrlHttp(String cloneUrlHttp);

        /**
         * <p>
         * The URL to use for cloning the repository over SSH.
         * </p>
         * 
         * @param cloneUrlSsh
         *        The URL to use for cloning the repository over SSH.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloneUrlSsh(String cloneUrlSsh);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the repository.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String repositoryId;

        private String repositoryName;

        private String repositoryDescription;

        private String defaultBranch;

        private Instant lastModifiedDate;

        private Instant creationDate;

        private String cloneUrlHttp;

        private String cloneUrlSsh;

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(RepositoryMetadata model) {
            accountId(model.accountId);
            repositoryId(model.repositoryId);
            repositoryName(model.repositoryName);
            repositoryDescription(model.repositoryDescription);
            defaultBranch(model.defaultBranch);
            lastModifiedDate(model.lastModifiedDate);
            creationDate(model.creationDate);
            cloneUrlHttp(model.cloneUrlHttp);
            cloneUrlSsh(model.cloneUrlSsh);
            arn(model.arn);
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getRepositoryId() {
            return repositoryId;
        }

        @Override
        public final Builder repositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            return this;
        }

        public final void setRepositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getRepositoryDescription() {
            return repositoryDescription;
        }

        @Override
        public final Builder repositoryDescription(String repositoryDescription) {
            this.repositoryDescription = repositoryDescription;
            return this;
        }

        public final void setRepositoryDescription(String repositoryDescription) {
            this.repositoryDescription = repositoryDescription;
        }

        public final String getDefaultBranch() {
            return defaultBranch;
        }

        @Override
        public final Builder defaultBranch(String defaultBranch) {
            this.defaultBranch = defaultBranch;
            return this;
        }

        public final void setDefaultBranch(String defaultBranch) {
            this.defaultBranch = defaultBranch;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final String getCloneUrlHttp() {
            return cloneUrlHttp;
        }

        @Override
        public final Builder cloneUrlHttp(String cloneUrlHttp) {
            this.cloneUrlHttp = cloneUrlHttp;
            return this;
        }

        public final void setCloneUrlHttp(String cloneUrlHttp) {
            this.cloneUrlHttp = cloneUrlHttp;
        }

        public final String getCloneUrlSsh() {
            return cloneUrlSsh;
        }

        @Override
        public final Builder cloneUrlSsh(String cloneUrlSsh) {
            this.cloneUrlSsh = cloneUrlSsh;
            return this;
        }

        public final void setCloneUrlSsh(String cloneUrlSsh) {
            this.cloneUrlSsh = cloneUrlSsh;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public RepositoryMetadata build() {
            return new RepositoryMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
