/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateApprovalRuleTemplateNameRequest extends CodeCommitRequest implements
        ToCopyableBuilder<UpdateApprovalRuleTemplateNameRequest.Builder, UpdateApprovalRuleTemplateNameRequest> {
    private static final SdkField<String> OLD_APPROVAL_RULE_TEMPLATE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("oldApprovalRuleTemplateName")
            .getter(getter(UpdateApprovalRuleTemplateNameRequest::oldApprovalRuleTemplateName))
            .setter(setter(Builder::oldApprovalRuleTemplateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oldApprovalRuleTemplateName")
                    .build()).build();

    private static final SdkField<String> NEW_APPROVAL_RULE_TEMPLATE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("newApprovalRuleTemplateName")
            .getter(getter(UpdateApprovalRuleTemplateNameRequest::newApprovalRuleTemplateName))
            .setter(setter(Builder::newApprovalRuleTemplateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newApprovalRuleTemplateName")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            OLD_APPROVAL_RULE_TEMPLATE_NAME_FIELD, NEW_APPROVAL_RULE_TEMPLATE_NAME_FIELD));

    private final String oldApprovalRuleTemplateName;

    private final String newApprovalRuleTemplateName;

    private UpdateApprovalRuleTemplateNameRequest(BuilderImpl builder) {
        super(builder);
        this.oldApprovalRuleTemplateName = builder.oldApprovalRuleTemplateName;
        this.newApprovalRuleTemplateName = builder.newApprovalRuleTemplateName;
    }

    /**
     * <p>
     * The current name of the approval rule template.
     * </p>
     * 
     * @return The current name of the approval rule template.
     */
    public String oldApprovalRuleTemplateName() {
        return oldApprovalRuleTemplateName;
    }

    /**
     * <p>
     * The new name you want to apply to the approval rule template.
     * </p>
     * 
     * @return The new name you want to apply to the approval rule template.
     */
    public String newApprovalRuleTemplateName() {
        return newApprovalRuleTemplateName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(oldApprovalRuleTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(newApprovalRuleTemplateName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApprovalRuleTemplateNameRequest)) {
            return false;
        }
        UpdateApprovalRuleTemplateNameRequest other = (UpdateApprovalRuleTemplateNameRequest) obj;
        return Objects.equals(oldApprovalRuleTemplateName(), other.oldApprovalRuleTemplateName())
                && Objects.equals(newApprovalRuleTemplateName(), other.newApprovalRuleTemplateName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateApprovalRuleTemplateNameRequest")
                .add("OldApprovalRuleTemplateName", oldApprovalRuleTemplateName())
                .add("NewApprovalRuleTemplateName", newApprovalRuleTemplateName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "oldApprovalRuleTemplateName":
            return Optional.ofNullable(clazz.cast(oldApprovalRuleTemplateName()));
        case "newApprovalRuleTemplateName":
            return Optional.ofNullable(clazz.cast(newApprovalRuleTemplateName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateApprovalRuleTemplateNameRequest, T> g) {
        return obj -> g.apply((UpdateApprovalRuleTemplateNameRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateApprovalRuleTemplateNameRequest> {
        /**
         * <p>
         * The current name of the approval rule template.
         * </p>
         * 
         * @param oldApprovalRuleTemplateName
         *        The current name of the approval rule template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oldApprovalRuleTemplateName(String oldApprovalRuleTemplateName);

        /**
         * <p>
         * The new name you want to apply to the approval rule template.
         * </p>
         * 
         * @param newApprovalRuleTemplateName
         *        The new name you want to apply to the approval rule template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newApprovalRuleTemplateName(String newApprovalRuleTemplateName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeCommitRequest.BuilderImpl implements Builder {
        private String oldApprovalRuleTemplateName;

        private String newApprovalRuleTemplateName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApprovalRuleTemplateNameRequest model) {
            super(model);
            oldApprovalRuleTemplateName(model.oldApprovalRuleTemplateName);
            newApprovalRuleTemplateName(model.newApprovalRuleTemplateName);
        }

        public final String getOldApprovalRuleTemplateName() {
            return oldApprovalRuleTemplateName;
        }

        @Override
        public final Builder oldApprovalRuleTemplateName(String oldApprovalRuleTemplateName) {
            this.oldApprovalRuleTemplateName = oldApprovalRuleTemplateName;
            return this;
        }

        public final void setOldApprovalRuleTemplateName(String oldApprovalRuleTemplateName) {
            this.oldApprovalRuleTemplateName = oldApprovalRuleTemplateName;
        }

        public final String getNewApprovalRuleTemplateName() {
            return newApprovalRuleTemplateName;
        }

        @Override
        public final Builder newApprovalRuleTemplateName(String newApprovalRuleTemplateName) {
            this.newApprovalRuleTemplateName = newApprovalRuleTemplateName;
            return this;
        }

        public final void setNewApprovalRuleTemplateName(String newApprovalRuleTemplateName) {
            this.newApprovalRuleTemplateName = newApprovalRuleTemplateName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApprovalRuleTemplateNameRequest build() {
            return new UpdateApprovalRuleTemplateNameRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
