/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesError;
import software.amazon.awssdk.services.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesErrorsListCopier;
import software.amazon.awssdk.services.codecommit.model.CodeCommitResponse;
import software.amazon.awssdk.services.codecommit.model.RepositoryNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchAssociateApprovalRuleTemplateWithRepositoriesResponse
extends CodeCommitResponse
implements ToCopyableBuilder<Builder, BatchAssociateApprovalRuleTemplateWithRepositoriesResponse> {
    private static final SdkField<List<String>> ASSOCIATED_REPOSITORY_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("associatedRepositoryNames").getter(BatchAssociateApprovalRuleTemplateWithRepositoriesResponse.getter(BatchAssociateApprovalRuleTemplateWithRepositoriesResponse::associatedRepositoryNames)).setter(BatchAssociateApprovalRuleTemplateWithRepositoriesResponse.setter(Builder::associatedRepositoryNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedRepositoryNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchAssociateApprovalRuleTemplateWithRepositoriesError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(BatchAssociateApprovalRuleTemplateWithRepositoriesResponse.getter(BatchAssociateApprovalRuleTemplateWithRepositoriesResponse::errors)).setter(BatchAssociateApprovalRuleTemplateWithRepositoriesResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchAssociateApprovalRuleTemplateWithRepositoriesError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATED_REPOSITORY_NAMES_FIELD, ERRORS_FIELD));
    private final List<String> associatedRepositoryNames;
    private final List<BatchAssociateApprovalRuleTemplateWithRepositoriesError> errors;

    private BatchAssociateApprovalRuleTemplateWithRepositoriesResponse(BuilderImpl builder) {
        super(builder);
        this.associatedRepositoryNames = builder.associatedRepositoryNames;
        this.errors = builder.errors;
    }

    public boolean hasAssociatedRepositoryNames() {
        return this.associatedRepositoryNames != null && !(this.associatedRepositoryNames instanceof SdkAutoConstructList);
    }

    public List<String> associatedRepositoryNames() {
        return this.associatedRepositoryNames;
    }

    public boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public List<BatchAssociateApprovalRuleTemplateWithRepositoriesError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedRepositoryNames() ? this.associatedRepositoryNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAssociateApprovalRuleTemplateWithRepositoriesResponse)) {
            return false;
        }
        BatchAssociateApprovalRuleTemplateWithRepositoriesResponse other = (BatchAssociateApprovalRuleTemplateWithRepositoriesResponse)((Object)obj);
        return this.hasAssociatedRepositoryNames() == other.hasAssociatedRepositoryNames() && Objects.equals(this.associatedRepositoryNames(), other.associatedRepositoryNames()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public String toString() {
        return ToString.builder((String)"BatchAssociateApprovalRuleTemplateWithRepositoriesResponse").add("AssociatedRepositoryNames", this.hasAssociatedRepositoryNames() ? this.associatedRepositoryNames() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "associatedRepositoryNames": {
                return Optional.ofNullable(clazz.cast(this.associatedRepositoryNames()));
            }
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchAssociateApprovalRuleTemplateWithRepositoriesResponse, T> g) {
        return obj -> g.apply((BatchAssociateApprovalRuleTemplateWithRepositoriesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitResponse.BuilderImpl
    implements Builder {
        private List<String> associatedRepositoryNames = DefaultSdkAutoConstructList.getInstance();
        private List<BatchAssociateApprovalRuleTemplateWithRepositoriesError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAssociateApprovalRuleTemplateWithRepositoriesResponse model) {
            super(model);
            this.associatedRepositoryNames(model.associatedRepositoryNames);
            this.errors(model.errors);
        }

        public final Collection<String> getAssociatedRepositoryNames() {
            if (this.associatedRepositoryNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.associatedRepositoryNames;
        }

        @Override
        public final Builder associatedRepositoryNames(Collection<String> associatedRepositoryNames) {
            this.associatedRepositoryNames = RepositoryNameListCopier.copy(associatedRepositoryNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedRepositoryNames(String ... associatedRepositoryNames) {
            this.associatedRepositoryNames(Arrays.asList(associatedRepositoryNames));
            return this;
        }

        public final void setAssociatedRepositoryNames(Collection<String> associatedRepositoryNames) {
            this.associatedRepositoryNames = RepositoryNameListCopier.copy(associatedRepositoryNames);
        }

        public final Collection<BatchAssociateApprovalRuleTemplateWithRepositoriesError.Builder> getErrors() {
            if (this.errors instanceof SdkAutoConstructList) {
                return null;
            }
            return this.errors != null ? (Collection)this.errors.stream().map(BatchAssociateApprovalRuleTemplateWithRepositoriesError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errors(Collection<BatchAssociateApprovalRuleTemplateWithRepositoriesError> errors) {
            this.errors = BatchAssociateApprovalRuleTemplateWithRepositoriesErrorsListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchAssociateApprovalRuleTemplateWithRepositoriesError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchAssociateApprovalRuleTemplateWithRepositoriesError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchAssociateApprovalRuleTemplateWithRepositoriesError)((BatchAssociateApprovalRuleTemplateWithRepositoriesError.Builder)BatchAssociateApprovalRuleTemplateWithRepositoriesError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setErrors(Collection<BatchAssociateApprovalRuleTemplateWithRepositoriesError.BuilderImpl> errors) {
            this.errors = BatchAssociateApprovalRuleTemplateWithRepositoriesErrorsListCopier.copyFromBuilder(errors);
        }

        @Override
        public BatchAssociateApprovalRuleTemplateWithRepositoriesResponse build() {
            return new BatchAssociateApprovalRuleTemplateWithRepositoriesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCommitResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchAssociateApprovalRuleTemplateWithRepositoriesResponse> {
        public Builder associatedRepositoryNames(Collection<String> var1);

        public Builder associatedRepositoryNames(String ... var1);

        public Builder errors(Collection<BatchAssociateApprovalRuleTemplateWithRepositoriesError> var1);

        public Builder errors(BatchAssociateApprovalRuleTemplateWithRepositoriesError ... var1);

        public Builder errors(Consumer<BatchAssociateApprovalRuleTemplateWithRepositoriesError.Builder> ... var1);
    }
}

