/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.CodeCommitRequest;
import software.amazon.awssdk.services.codecommit.model.ConflictDetailLevelTypeEnum;
import software.amazon.awssdk.services.codecommit.model.ConflictResolutionStrategyTypeEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMergeCommitRequest
extends CodeCommitRequest
implements ToCopyableBuilder<Builder, GetMergeCommitRequest> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(GetMergeCommitRequest.getter(GetMergeCommitRequest::repositoryName)).setter(GetMergeCommitRequest.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<String> SOURCE_COMMIT_SPECIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceCommitSpecifier").getter(GetMergeCommitRequest.getter(GetMergeCommitRequest::sourceCommitSpecifier)).setter(GetMergeCommitRequest.setter(Builder::sourceCommitSpecifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCommitSpecifier").build()}).build();
    private static final SdkField<String> DESTINATION_COMMIT_SPECIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationCommitSpecifier").getter(GetMergeCommitRequest.getter(GetMergeCommitRequest::destinationCommitSpecifier)).setter(GetMergeCommitRequest.setter(Builder::destinationCommitSpecifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationCommitSpecifier").build()}).build();
    private static final SdkField<String> CONFLICT_DETAIL_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("conflictDetailLevel").getter(GetMergeCommitRequest.getter(GetMergeCommitRequest::conflictDetailLevelAsString)).setter(GetMergeCommitRequest.setter(Builder::conflictDetailLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conflictDetailLevel").build()}).build();
    private static final SdkField<String> CONFLICT_RESOLUTION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("conflictResolutionStrategy").getter(GetMergeCommitRequest.getter(GetMergeCommitRequest::conflictResolutionStrategyAsString)).setter(GetMergeCommitRequest.setter(Builder::conflictResolutionStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conflictResolutionStrategy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD, SOURCE_COMMIT_SPECIFIER_FIELD, DESTINATION_COMMIT_SPECIFIER_FIELD, CONFLICT_DETAIL_LEVEL_FIELD, CONFLICT_RESOLUTION_STRATEGY_FIELD));
    private final String repositoryName;
    private final String sourceCommitSpecifier;
    private final String destinationCommitSpecifier;
    private final String conflictDetailLevel;
    private final String conflictResolutionStrategy;

    private GetMergeCommitRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.sourceCommitSpecifier = builder.sourceCommitSpecifier;
        this.destinationCommitSpecifier = builder.destinationCommitSpecifier;
        this.conflictDetailLevel = builder.conflictDetailLevel;
        this.conflictResolutionStrategy = builder.conflictResolutionStrategy;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public String sourceCommitSpecifier() {
        return this.sourceCommitSpecifier;
    }

    public String destinationCommitSpecifier() {
        return this.destinationCommitSpecifier;
    }

    public ConflictDetailLevelTypeEnum conflictDetailLevel() {
        return ConflictDetailLevelTypeEnum.fromValue(this.conflictDetailLevel);
    }

    public String conflictDetailLevelAsString() {
        return this.conflictDetailLevel;
    }

    public ConflictResolutionStrategyTypeEnum conflictResolutionStrategy() {
        return ConflictResolutionStrategyTypeEnum.fromValue(this.conflictResolutionStrategy);
    }

    public String conflictResolutionStrategyAsString() {
        return this.conflictResolutionStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCommitSpecifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCommitSpecifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.conflictDetailLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.conflictResolutionStrategyAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMergeCommitRequest)) {
            return false;
        }
        GetMergeCommitRequest other = (GetMergeCommitRequest)((Object)obj);
        return Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.sourceCommitSpecifier(), other.sourceCommitSpecifier()) && Objects.equals(this.destinationCommitSpecifier(), other.destinationCommitSpecifier()) && Objects.equals(this.conflictDetailLevelAsString(), other.conflictDetailLevelAsString()) && Objects.equals(this.conflictResolutionStrategyAsString(), other.conflictResolutionStrategyAsString());
    }

    public String toString() {
        return ToString.builder((String)"GetMergeCommitRequest").add("RepositoryName", (Object)this.repositoryName()).add("SourceCommitSpecifier", (Object)this.sourceCommitSpecifier()).add("DestinationCommitSpecifier", (Object)this.destinationCommitSpecifier()).add("ConflictDetailLevel", (Object)this.conflictDetailLevelAsString()).add("ConflictResolutionStrategy", (Object)this.conflictResolutionStrategyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "sourceCommitSpecifier": {
                return Optional.ofNullable(clazz.cast(this.sourceCommitSpecifier()));
            }
            case "destinationCommitSpecifier": {
                return Optional.ofNullable(clazz.cast(this.destinationCommitSpecifier()));
            }
            case "conflictDetailLevel": {
                return Optional.ofNullable(clazz.cast(this.conflictDetailLevelAsString()));
            }
            case "conflictResolutionStrategy": {
                return Optional.ofNullable(clazz.cast(this.conflictResolutionStrategyAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMergeCommitRequest, T> g) {
        return obj -> g.apply((GetMergeCommitRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitRequest.BuilderImpl
    implements Builder {
        private String repositoryName;
        private String sourceCommitSpecifier;
        private String destinationCommitSpecifier;
        private String conflictDetailLevel;
        private String conflictResolutionStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMergeCommitRequest model) {
            super(model);
            this.repositoryName(model.repositoryName);
            this.sourceCommitSpecifier(model.sourceCommitSpecifier);
            this.destinationCommitSpecifier(model.destinationCommitSpecifier);
            this.conflictDetailLevel(model.conflictDetailLevel);
            this.conflictResolutionStrategy(model.conflictResolutionStrategy);
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getSourceCommitSpecifier() {
            return this.sourceCommitSpecifier;
        }

        @Override
        public final Builder sourceCommitSpecifier(String sourceCommitSpecifier) {
            this.sourceCommitSpecifier = sourceCommitSpecifier;
            return this;
        }

        public final void setSourceCommitSpecifier(String sourceCommitSpecifier) {
            this.sourceCommitSpecifier = sourceCommitSpecifier;
        }

        public final String getDestinationCommitSpecifier() {
            return this.destinationCommitSpecifier;
        }

        @Override
        public final Builder destinationCommitSpecifier(String destinationCommitSpecifier) {
            this.destinationCommitSpecifier = destinationCommitSpecifier;
            return this;
        }

        public final void setDestinationCommitSpecifier(String destinationCommitSpecifier) {
            this.destinationCommitSpecifier = destinationCommitSpecifier;
        }

        public final String getConflictDetailLevel() {
            return this.conflictDetailLevel;
        }

        @Override
        public final Builder conflictDetailLevel(String conflictDetailLevel) {
            this.conflictDetailLevel = conflictDetailLevel;
            return this;
        }

        @Override
        public final Builder conflictDetailLevel(ConflictDetailLevelTypeEnum conflictDetailLevel) {
            this.conflictDetailLevel(conflictDetailLevel == null ? null : conflictDetailLevel.toString());
            return this;
        }

        public final void setConflictDetailLevel(String conflictDetailLevel) {
            this.conflictDetailLevel = conflictDetailLevel;
        }

        public final String getConflictResolutionStrategy() {
            return this.conflictResolutionStrategy;
        }

        @Override
        public final Builder conflictResolutionStrategy(String conflictResolutionStrategy) {
            this.conflictResolutionStrategy = conflictResolutionStrategy;
            return this;
        }

        @Override
        public final Builder conflictResolutionStrategy(ConflictResolutionStrategyTypeEnum conflictResolutionStrategy) {
            this.conflictResolutionStrategy(conflictResolutionStrategy == null ? null : conflictResolutionStrategy.toString());
            return this;
        }

        public final void setConflictResolutionStrategy(String conflictResolutionStrategy) {
            this.conflictResolutionStrategy = conflictResolutionStrategy;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMergeCommitRequest build() {
            return new GetMergeCommitRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCommitRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMergeCommitRequest> {
        public Builder repositoryName(String var1);

        public Builder sourceCommitSpecifier(String var1);

        public Builder destinationCommitSpecifier(String var1);

        public Builder conflictDetailLevel(String var1);

        public Builder conflictDetailLevel(ConflictDetailLevelTypeEnum var1);

        public Builder conflictResolutionStrategy(String var1);

        public Builder conflictResolutionStrategy(ConflictResolutionStrategyTypeEnum var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

