/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Target
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Target> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(Target.getter(Target::repositoryName)).setter(Target.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<String> SOURCE_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceReference").getter(Target.getter(Target::sourceReference)).setter(Target.setter(Builder::sourceReference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceReference").build()}).build();
    private static final SdkField<String> DESTINATION_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationReference").getter(Target.getter(Target::destinationReference)).setter(Target.setter(Builder::destinationReference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationReference").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD, SOURCE_REFERENCE_FIELD, DESTINATION_REFERENCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String repositoryName;
    private final String sourceReference;
    private final String destinationReference;

    private Target(BuilderImpl builder) {
        this.repositoryName = builder.repositoryName;
        this.sourceReference = builder.sourceReference;
        this.destinationReference = builder.destinationReference;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public String sourceReference() {
        return this.sourceReference;
    }

    public String destinationReference() {
        return this.destinationReference;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationReference());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Target)) {
            return false;
        }
        Target other = (Target)obj;
        return Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.sourceReference(), other.sourceReference()) && Objects.equals(this.destinationReference(), other.destinationReference());
    }

    public String toString() {
        return ToString.builder((String)"Target").add("RepositoryName", (Object)this.repositoryName()).add("SourceReference", (Object)this.sourceReference()).add("DestinationReference", (Object)this.destinationReference()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "sourceReference": {
                return Optional.ofNullable(clazz.cast(this.sourceReference()));
            }
            case "destinationReference": {
                return Optional.ofNullable(clazz.cast(this.destinationReference()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Target, T> g) {
        return obj -> g.apply((Target)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String repositoryName;
        private String sourceReference;
        private String destinationReference;

        private BuilderImpl() {
        }

        private BuilderImpl(Target model) {
            this.repositoryName(model.repositoryName);
            this.sourceReference(model.sourceReference);
            this.destinationReference(model.destinationReference);
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getSourceReference() {
            return this.sourceReference;
        }

        @Override
        public final Builder sourceReference(String sourceReference) {
            this.sourceReference = sourceReference;
            return this;
        }

        public final void setSourceReference(String sourceReference) {
            this.sourceReference = sourceReference;
        }

        public final String getDestinationReference() {
            return this.destinationReference;
        }

        @Override
        public final Builder destinationReference(String destinationReference) {
            this.destinationReference = destinationReference;
            return this;
        }

        public final void setDestinationReference(String destinationReference) {
            this.destinationReference = destinationReference;
        }

        public Target build() {
            return new Target(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Target> {
        public Builder repositoryName(String var1);

        public Builder sourceReference(String var1);

        public Builder destinationReference(String var1);
    }
}

