/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.ApprovalState;
import software.amazon.awssdk.services.codecommit.model.CodeCommitRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePullRequestApprovalStateRequest
extends CodeCommitRequest
implements ToCopyableBuilder<Builder, UpdatePullRequestApprovalStateRequest> {
    private static final SdkField<String> PULL_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pullRequestId").getter(UpdatePullRequestApprovalStateRequest.getter(UpdatePullRequestApprovalStateRequest::pullRequestId)).setter(UpdatePullRequestApprovalStateRequest.setter(Builder::pullRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestId").build()}).build();
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revisionId").getter(UpdatePullRequestApprovalStateRequest.getter(UpdatePullRequestApprovalStateRequest::revisionId)).setter(UpdatePullRequestApprovalStateRequest.setter(Builder::revisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()}).build();
    private static final SdkField<String> APPROVAL_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("approvalState").getter(UpdatePullRequestApprovalStateRequest.getter(UpdatePullRequestApprovalStateRequest::approvalStateAsString)).setter(UpdatePullRequestApprovalStateRequest.setter(Builder::approvalState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PULL_REQUEST_ID_FIELD, REVISION_ID_FIELD, APPROVAL_STATE_FIELD));
    private final String pullRequestId;
    private final String revisionId;
    private final String approvalState;

    private UpdatePullRequestApprovalStateRequest(BuilderImpl builder) {
        super(builder);
        this.pullRequestId = builder.pullRequestId;
        this.revisionId = builder.revisionId;
        this.approvalState = builder.approvalState;
    }

    public String pullRequestId() {
        return this.pullRequestId;
    }

    public String revisionId() {
        return this.revisionId;
    }

    public ApprovalState approvalState() {
        return ApprovalState.fromValue(this.approvalState);
    }

    public String approvalStateAsString() {
        return this.approvalState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pullRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvalStateAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePullRequestApprovalStateRequest)) {
            return false;
        }
        UpdatePullRequestApprovalStateRequest other = (UpdatePullRequestApprovalStateRequest)((Object)obj);
        return Objects.equals(this.pullRequestId(), other.pullRequestId()) && Objects.equals(this.revisionId(), other.revisionId()) && Objects.equals(this.approvalStateAsString(), other.approvalStateAsString());
    }

    public String toString() {
        return ToString.builder((String)"UpdatePullRequestApprovalStateRequest").add("PullRequestId", (Object)this.pullRequestId()).add("RevisionId", (Object)this.revisionId()).add("ApprovalState", (Object)this.approvalStateAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pullRequestId": {
                return Optional.ofNullable(clazz.cast(this.pullRequestId()));
            }
            case "revisionId": {
                return Optional.ofNullable(clazz.cast(this.revisionId()));
            }
            case "approvalState": {
                return Optional.ofNullable(clazz.cast(this.approvalStateAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePullRequestApprovalStateRequest, T> g) {
        return obj -> g.apply((UpdatePullRequestApprovalStateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitRequest.BuilderImpl
    implements Builder {
        private String pullRequestId;
        private String revisionId;
        private String approvalState;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePullRequestApprovalStateRequest model) {
            super(model);
            this.pullRequestId(model.pullRequestId);
            this.revisionId(model.revisionId);
            this.approvalState(model.approvalState);
        }

        public final String getPullRequestId() {
            return this.pullRequestId;
        }

        @Override
        public final Builder pullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
            return this;
        }

        public final void setPullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        public final String getApprovalState() {
            return this.approvalState;
        }

        @Override
        public final Builder approvalState(String approvalState) {
            this.approvalState = approvalState;
            return this;
        }

        @Override
        public final Builder approvalState(ApprovalState approvalState) {
            this.approvalState(approvalState == null ? null : approvalState.toString());
            return this;
        }

        public final void setApprovalState(String approvalState) {
            this.approvalState = approvalState;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePullRequestApprovalStateRequest build() {
            return new UpdatePullRequestApprovalStateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCommitRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePullRequestApprovalStateRequest> {
        public Builder pullRequestId(String var1);

        public Builder revisionId(String var1);

        public Builder approvalState(String var1);

        public Builder approvalState(ApprovalState var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

