/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPullRequestApprovalStatesResponse extends CodeCommitResponse implements
        ToCopyableBuilder<GetPullRequestApprovalStatesResponse.Builder, GetPullRequestApprovalStatesResponse> {
    private static final SdkField<List<Approval>> APPROVALS_FIELD = SdkField
            .<List<Approval>> builder(MarshallingType.LIST)
            .memberName("approvals")
            .getter(getter(GetPullRequestApprovalStatesResponse::approvals))
            .setter(setter(Builder::approvals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Approval> builder(MarshallingType.SDK_POJO)
                                            .constructor(Approval::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPROVALS_FIELD));

    private final List<Approval> approvals;

    private GetPullRequestApprovalStatesResponse(BuilderImpl builder) {
        super(builder);
        this.approvals = builder.approvals;
    }

    /**
     * Returns true if the Approvals property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasApprovals() {
        return approvals != null && !(approvals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about users who have approved the pull request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasApprovals()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about users who have approved the pull request.
     */
    public final List<Approval> approvals() {
        return approvals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasApprovals() ? approvals() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPullRequestApprovalStatesResponse)) {
            return false;
        }
        GetPullRequestApprovalStatesResponse other = (GetPullRequestApprovalStatesResponse) obj;
        return hasApprovals() == other.hasApprovals() && Objects.equals(approvals(), other.approvals());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPullRequestApprovalStatesResponse").add("Approvals", hasApprovals() ? approvals() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "approvals":
            return Optional.ofNullable(clazz.cast(approvals()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPullRequestApprovalStatesResponse, T> g) {
        return obj -> g.apply((GetPullRequestApprovalStatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetPullRequestApprovalStatesResponse> {
        /**
         * <p>
         * Information about users who have approved the pull request.
         * </p>
         * 
         * @param approvals
         *        Information about users who have approved the pull request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvals(Collection<Approval> approvals);

        /**
         * <p>
         * Information about users who have approved the pull request.
         * </p>
         * 
         * @param approvals
         *        Information about users who have approved the pull request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvals(Approval... approvals);

        /**
         * <p>
         * Information about users who have approved the pull request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Approval>.Builder} avoiding the need to
         * create one manually via {@link List<Approval>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Approval>.Builder#build()} is called immediately and its
         * result is passed to {@link #approvals(List<Approval>)}.
         * 
         * @param approvals
         *        a consumer that will call methods on {@link List<Approval>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #approvals(List<Approval>)
         */
        Builder approvals(Consumer<Approval.Builder>... approvals);
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private List<Approval> approvals = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetPullRequestApprovalStatesResponse model) {
            super(model);
            approvals(model.approvals);
        }

        public final Collection<Approval.Builder> getApprovals() {
            if (approvals instanceof SdkAutoConstructList) {
                return null;
            }
            return approvals != null ? approvals.stream().map(Approval::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder approvals(Collection<Approval> approvals) {
            this.approvals = ApprovalListCopier.copy(approvals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvals(Approval... approvals) {
            approvals(Arrays.asList(approvals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvals(Consumer<Approval.Builder>... approvals) {
            approvals(Stream.of(approvals).map(c -> Approval.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setApprovals(Collection<Approval.BuilderImpl> approvals) {
            this.approvals = ApprovalListCopier.copyFromBuilder(approvals);
        }

        @Override
        public GetPullRequestApprovalStatesResponse build() {
            return new GetPullRequestApprovalStatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
