/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePullRequestStatusRequest extends CodeCommitRequest implements
        ToCopyableBuilder<UpdatePullRequestStatusRequest.Builder, UpdatePullRequestStatusRequest> {
    private static final SdkField<String> PULL_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pullRequestId").getter(getter(UpdatePullRequestStatusRequest::pullRequestId))
            .setter(setter(Builder::pullRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestId").build()).build();

    private static final SdkField<String> PULL_REQUEST_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pullRequestStatus").getter(getter(UpdatePullRequestStatusRequest::pullRequestStatusAsString))
            .setter(setter(Builder::pullRequestStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PULL_REQUEST_ID_FIELD,
            PULL_REQUEST_STATUS_FIELD));

    private final String pullRequestId;

    private final String pullRequestStatus;

    private UpdatePullRequestStatusRequest(BuilderImpl builder) {
        super(builder);
        this.pullRequestId = builder.pullRequestId;
        this.pullRequestStatus = builder.pullRequestStatus;
    }

    /**
     * <p>
     * The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.
     * </p>
     * 
     * @return The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.
     */
    public final String pullRequestId() {
        return pullRequestId;
    }

    /**
     * <p>
     * The status of the pull request. The only valid operations are to update the status from <code>OPEN</code> to
     * <code>OPEN</code>, <code>OPEN</code> to <code>CLOSED</code> or from <code>CLOSED</code> to <code>CLOSED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pullRequestStatus}
     * will return {@link PullRequestStatusEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #pullRequestStatusAsString}.
     * </p>
     * 
     * @return The status of the pull request. The only valid operations are to update the status from <code>OPEN</code>
     *         to <code>OPEN</code>, <code>OPEN</code> to <code>CLOSED</code> or from <code>CLOSED</code> to
     *         <code>CLOSED</code>.
     * @see PullRequestStatusEnum
     */
    public final PullRequestStatusEnum pullRequestStatus() {
        return PullRequestStatusEnum.fromValue(pullRequestStatus);
    }

    /**
     * <p>
     * The status of the pull request. The only valid operations are to update the status from <code>OPEN</code> to
     * <code>OPEN</code>, <code>OPEN</code> to <code>CLOSED</code> or from <code>CLOSED</code> to <code>CLOSED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pullRequestStatus}
     * will return {@link PullRequestStatusEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #pullRequestStatusAsString}.
     * </p>
     * 
     * @return The status of the pull request. The only valid operations are to update the status from <code>OPEN</code>
     *         to <code>OPEN</code>, <code>OPEN</code> to <code>CLOSED</code> or from <code>CLOSED</code> to
     *         <code>CLOSED</code>.
     * @see PullRequestStatusEnum
     */
    public final String pullRequestStatusAsString() {
        return pullRequestStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pullRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(pullRequestStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePullRequestStatusRequest)) {
            return false;
        }
        UpdatePullRequestStatusRequest other = (UpdatePullRequestStatusRequest) obj;
        return Objects.equals(pullRequestId(), other.pullRequestId())
                && Objects.equals(pullRequestStatusAsString(), other.pullRequestStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePullRequestStatusRequest").add("PullRequestId", pullRequestId())
                .add("PullRequestStatus", pullRequestStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pullRequestId":
            return Optional.ofNullable(clazz.cast(pullRequestId()));
        case "pullRequestStatus":
            return Optional.ofNullable(clazz.cast(pullRequestStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePullRequestStatusRequest, T> g) {
        return obj -> g.apply((UpdatePullRequestStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdatePullRequestStatusRequest> {
        /**
         * <p>
         * The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.
         * </p>
         * 
         * @param pullRequestId
         *        The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pullRequestId(String pullRequestId);

        /**
         * <p>
         * The status of the pull request. The only valid operations are to update the status from <code>OPEN</code> to
         * <code>OPEN</code>, <code>OPEN</code> to <code>CLOSED</code> or from <code>CLOSED</code> to
         * <code>CLOSED</code>.
         * </p>
         * 
         * @param pullRequestStatus
         *        The status of the pull request. The only valid operations are to update the status from
         *        <code>OPEN</code> to <code>OPEN</code>, <code>OPEN</code> to <code>CLOSED</code> or from
         *        <code>CLOSED</code> to <code>CLOSED</code>.
         * @see PullRequestStatusEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PullRequestStatusEnum
         */
        Builder pullRequestStatus(String pullRequestStatus);

        /**
         * <p>
         * The status of the pull request. The only valid operations are to update the status from <code>OPEN</code> to
         * <code>OPEN</code>, <code>OPEN</code> to <code>CLOSED</code> or from <code>CLOSED</code> to
         * <code>CLOSED</code>.
         * </p>
         * 
         * @param pullRequestStatus
         *        The status of the pull request. The only valid operations are to update the status from
         *        <code>OPEN</code> to <code>OPEN</code>, <code>OPEN</code> to <code>CLOSED</code> or from
         *        <code>CLOSED</code> to <code>CLOSED</code>.
         * @see PullRequestStatusEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PullRequestStatusEnum
         */
        Builder pullRequestStatus(PullRequestStatusEnum pullRequestStatus);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeCommitRequest.BuilderImpl implements Builder {
        private String pullRequestId;

        private String pullRequestStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePullRequestStatusRequest model) {
            super(model);
            pullRequestId(model.pullRequestId);
            pullRequestStatus(model.pullRequestStatus);
        }

        public final String getPullRequestId() {
            return pullRequestId;
        }

        @Override
        public final Builder pullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
            return this;
        }

        public final void setPullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
        }

        public final String getPullRequestStatus() {
            return pullRequestStatus;
        }

        @Override
        public final Builder pullRequestStatus(String pullRequestStatus) {
            this.pullRequestStatus = pullRequestStatus;
            return this;
        }

        @Override
        public final Builder pullRequestStatus(PullRequestStatusEnum pullRequestStatus) {
            this.pullRequestStatus(pullRequestStatus == null ? null : pullRequestStatus.toString());
            return this;
        }

        public final void setPullRequestStatus(String pullRequestStatus) {
            this.pullRequestStatus = pullRequestStatus;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePullRequestStatusRequest build() {
            return new UpdatePullRequestStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
