/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codecommit.model.ApprovalRulesNotSatisfiedListCopier;
import software.amazon.awssdk.services.codecommit.model.ApprovalRulesSatisfiedListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Evaluation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Evaluation> {
    private static final SdkField<Boolean> APPROVED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("approved").getter(Evaluation.getter(Evaluation::approved)).setter(Evaluation.setter(Builder::approved)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approved").build()}).build();
    private static final SdkField<Boolean> OVERRIDDEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("overridden").getter(Evaluation.getter(Evaluation::overridden)).setter(Evaluation.setter(Builder::overridden)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overridden").build()}).build();
    private static final SdkField<List<String>> APPROVAL_RULES_SATISFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("approvalRulesSatisfied").getter(Evaluation.getter(Evaluation::approvalRulesSatisfied)).setter(Evaluation.setter(Builder::approvalRulesSatisfied)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRulesSatisfied").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> APPROVAL_RULES_NOT_SATISFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("approvalRulesNotSatisfied").getter(Evaluation.getter(Evaluation::approvalRulesNotSatisfied)).setter(Evaluation.setter(Builder::approvalRulesNotSatisfied)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRulesNotSatisfied").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPROVED_FIELD, OVERRIDDEN_FIELD, APPROVAL_RULES_SATISFIED_FIELD, APPROVAL_RULES_NOT_SATISFIED_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean approved;
    private final Boolean overridden;
    private final List<String> approvalRulesSatisfied;
    private final List<String> approvalRulesNotSatisfied;

    private Evaluation(BuilderImpl builder) {
        this.approved = builder.approved;
        this.overridden = builder.overridden;
        this.approvalRulesSatisfied = builder.approvalRulesSatisfied;
        this.approvalRulesNotSatisfied = builder.approvalRulesNotSatisfied;
    }

    public final Boolean approved() {
        return this.approved;
    }

    public final Boolean overridden() {
        return this.overridden;
    }

    public final boolean hasApprovalRulesSatisfied() {
        return this.approvalRulesSatisfied != null && !(this.approvalRulesSatisfied instanceof SdkAutoConstructList);
    }

    public final List<String> approvalRulesSatisfied() {
        return this.approvalRulesSatisfied;
    }

    public final boolean hasApprovalRulesNotSatisfied() {
        return this.approvalRulesNotSatisfied != null && !(this.approvalRulesNotSatisfied instanceof SdkAutoConstructList);
    }

    public final List<String> approvalRulesNotSatisfied() {
        return this.approvalRulesNotSatisfied;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.approved());
        hashCode = 31 * hashCode + Objects.hashCode(this.overridden());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApprovalRulesSatisfied() ? this.approvalRulesSatisfied() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApprovalRulesNotSatisfied() ? this.approvalRulesNotSatisfied() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Evaluation)) {
            return false;
        }
        Evaluation other = (Evaluation)obj;
        return Objects.equals(this.approved(), other.approved()) && Objects.equals(this.overridden(), other.overridden()) && this.hasApprovalRulesSatisfied() == other.hasApprovalRulesSatisfied() && Objects.equals(this.approvalRulesSatisfied(), other.approvalRulesSatisfied()) && this.hasApprovalRulesNotSatisfied() == other.hasApprovalRulesNotSatisfied() && Objects.equals(this.approvalRulesNotSatisfied(), other.approvalRulesNotSatisfied());
    }

    public final String toString() {
        return ToString.builder((String)"Evaluation").add("Approved", (Object)this.approved()).add("Overridden", (Object)this.overridden()).add("ApprovalRulesSatisfied", this.hasApprovalRulesSatisfied() ? this.approvalRulesSatisfied() : null).add("ApprovalRulesNotSatisfied", this.hasApprovalRulesNotSatisfied() ? this.approvalRulesNotSatisfied() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "approved": {
                return Optional.ofNullable(clazz.cast(this.approved()));
            }
            case "overridden": {
                return Optional.ofNullable(clazz.cast(this.overridden()));
            }
            case "approvalRulesSatisfied": {
                return Optional.ofNullable(clazz.cast(this.approvalRulesSatisfied()));
            }
            case "approvalRulesNotSatisfied": {
                return Optional.ofNullable(clazz.cast(this.approvalRulesNotSatisfied()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Evaluation, T> g) {
        return obj -> g.apply((Evaluation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean approved;
        private Boolean overridden;
        private List<String> approvalRulesSatisfied = DefaultSdkAutoConstructList.getInstance();
        private List<String> approvalRulesNotSatisfied = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Evaluation model) {
            this.approved(model.approved);
            this.overridden(model.overridden);
            this.approvalRulesSatisfied(model.approvalRulesSatisfied);
            this.approvalRulesNotSatisfied(model.approvalRulesNotSatisfied);
        }

        public final Boolean getApproved() {
            return this.approved;
        }

        @Override
        public final Builder approved(Boolean approved) {
            this.approved = approved;
            return this;
        }

        public final void setApproved(Boolean approved) {
            this.approved = approved;
        }

        public final Boolean getOverridden() {
            return this.overridden;
        }

        @Override
        public final Builder overridden(Boolean overridden) {
            this.overridden = overridden;
            return this;
        }

        public final void setOverridden(Boolean overridden) {
            this.overridden = overridden;
        }

        public final Collection<String> getApprovalRulesSatisfied() {
            if (this.approvalRulesSatisfied instanceof SdkAutoConstructList) {
                return null;
            }
            return this.approvalRulesSatisfied;
        }

        @Override
        public final Builder approvalRulesSatisfied(Collection<String> approvalRulesSatisfied) {
            this.approvalRulesSatisfied = ApprovalRulesSatisfiedListCopier.copy(approvalRulesSatisfied);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvalRulesSatisfied(String ... approvalRulesSatisfied) {
            this.approvalRulesSatisfied(Arrays.asList(approvalRulesSatisfied));
            return this;
        }

        public final void setApprovalRulesSatisfied(Collection<String> approvalRulesSatisfied) {
            this.approvalRulesSatisfied = ApprovalRulesSatisfiedListCopier.copy(approvalRulesSatisfied);
        }

        public final Collection<String> getApprovalRulesNotSatisfied() {
            if (this.approvalRulesNotSatisfied instanceof SdkAutoConstructList) {
                return null;
            }
            return this.approvalRulesNotSatisfied;
        }

        @Override
        public final Builder approvalRulesNotSatisfied(Collection<String> approvalRulesNotSatisfied) {
            this.approvalRulesNotSatisfied = ApprovalRulesNotSatisfiedListCopier.copy(approvalRulesNotSatisfied);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvalRulesNotSatisfied(String ... approvalRulesNotSatisfied) {
            this.approvalRulesNotSatisfied(Arrays.asList(approvalRulesNotSatisfied));
            return this;
        }

        public final void setApprovalRulesNotSatisfied(Collection<String> approvalRulesNotSatisfied) {
            this.approvalRulesNotSatisfied = ApprovalRulesNotSatisfiedListCopier.copy(approvalRulesNotSatisfied);
        }

        public Evaluation build() {
            return new Evaluation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Evaluation> {
        public Builder approved(Boolean var1);

        public Builder overridden(Boolean var1);

        public Builder approvalRulesSatisfied(Collection<String> var1);

        public Builder approvalRulesSatisfied(String ... var1);

        public Builder approvalRulesNotSatisfied(Collection<String> var1);

        public Builder approvalRulesNotSatisfied(String ... var1);
    }
}

