/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codecommit.model.CodeCommitResponse;
import software.amazon.awssdk.services.codecommit.model.PullRequestIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPullRequestsResponse
extends CodeCommitResponse
implements ToCopyableBuilder<Builder, ListPullRequestsResponse> {
    private static final SdkField<List<String>> PULL_REQUEST_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("pullRequestIds").getter(ListPullRequestsResponse.getter(ListPullRequestsResponse::pullRequestIds)).setter(ListPullRequestsResponse.setter(Builder::pullRequestIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListPullRequestsResponse.getter(ListPullRequestsResponse::nextToken)).setter(ListPullRequestsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PULL_REQUEST_IDS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> pullRequestIds;
    private final String nextToken;

    private ListPullRequestsResponse(BuilderImpl builder) {
        super(builder);
        this.pullRequestIds = builder.pullRequestIds;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPullRequestIds() {
        return this.pullRequestIds != null && !(this.pullRequestIds instanceof SdkAutoConstructList);
    }

    public final List<String> pullRequestIds() {
        return this.pullRequestIds;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPullRequestIds() ? this.pullRequestIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPullRequestsResponse)) {
            return false;
        }
        ListPullRequestsResponse other = (ListPullRequestsResponse)((Object)obj);
        return this.hasPullRequestIds() == other.hasPullRequestIds() && Objects.equals(this.pullRequestIds(), other.pullRequestIds()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPullRequestsResponse").add("PullRequestIds", this.hasPullRequestIds() ? this.pullRequestIds() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pullRequestIds": {
                return Optional.ofNullable(clazz.cast(this.pullRequestIds()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPullRequestsResponse, T> g) {
        return obj -> g.apply((ListPullRequestsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitResponse.BuilderImpl
    implements Builder {
        private List<String> pullRequestIds = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPullRequestsResponse model) {
            super(model);
            this.pullRequestIds(model.pullRequestIds);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getPullRequestIds() {
            if (this.pullRequestIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.pullRequestIds;
        }

        @Override
        public final Builder pullRequestIds(Collection<String> pullRequestIds) {
            this.pullRequestIds = PullRequestIdListCopier.copy(pullRequestIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pullRequestIds(String ... pullRequestIds) {
            this.pullRequestIds(Arrays.asList(pullRequestIds));
            return this;
        }

        public final void setPullRequestIds(Collection<String> pullRequestIds) {
            this.pullRequestIds = PullRequestIdListCopier.copy(pullRequestIds);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListPullRequestsResponse build() {
            return new ListPullRequestsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCommitResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPullRequestsResponse> {
        public Builder pullRequestIds(Collection<String> var1);

        public Builder pullRequestIds(String ... var1);

        public Builder nextToken(String var1);
    }
}

