/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum OverrideStatus {
    OVERRIDE("OVERRIDE"),
    REVOKE("REVOKE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private OverrideStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OverrideStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(OverrideStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OverrideStatus> knownValues() {
        return Stream.of(OverrideStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

