/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codecommit.model.ReactionUsersListCopier;
import software.amazon.awssdk.services.codecommit.model.ReactionValueFormats;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReactionForComment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReactionForComment> {
    private static final SdkField<ReactionValueFormats> REACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("reaction").getter(ReactionForComment.getter(ReactionForComment::reaction)).setter(ReactionForComment.setter(Builder::reaction)).constructor(ReactionValueFormats::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reaction").build()}).build();
    private static final SdkField<List<String>> REACTION_USERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("reactionUsers").getter(ReactionForComment.getter(ReactionForComment::reactionUsers)).setter(ReactionForComment.setter(Builder::reactionUsers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reactionUsers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> REACTIONS_FROM_DELETED_USERS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("reactionsFromDeletedUsersCount").getter(ReactionForComment.getter(ReactionForComment::reactionsFromDeletedUsersCount)).setter(ReactionForComment.setter(Builder::reactionsFromDeletedUsersCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reactionsFromDeletedUsersCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REACTION_FIELD, REACTION_USERS_FIELD, REACTIONS_FROM_DELETED_USERS_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final ReactionValueFormats reaction;
    private final List<String> reactionUsers;
    private final Integer reactionsFromDeletedUsersCount;

    private ReactionForComment(BuilderImpl builder) {
        this.reaction = builder.reaction;
        this.reactionUsers = builder.reactionUsers;
        this.reactionsFromDeletedUsersCount = builder.reactionsFromDeletedUsersCount;
    }

    public final ReactionValueFormats reaction() {
        return this.reaction;
    }

    public final boolean hasReactionUsers() {
        return this.reactionUsers != null && !(this.reactionUsers instanceof SdkAutoConstructList);
    }

    public final List<String> reactionUsers() {
        return this.reactionUsers;
    }

    public final Integer reactionsFromDeletedUsersCount() {
        return this.reactionsFromDeletedUsersCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reaction());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReactionUsers() ? this.reactionUsers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.reactionsFromDeletedUsersCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReactionForComment)) {
            return false;
        }
        ReactionForComment other = (ReactionForComment)obj;
        return Objects.equals(this.reaction(), other.reaction()) && this.hasReactionUsers() == other.hasReactionUsers() && Objects.equals(this.reactionUsers(), other.reactionUsers()) && Objects.equals(this.reactionsFromDeletedUsersCount(), other.reactionsFromDeletedUsersCount());
    }

    public final String toString() {
        return ToString.builder((String)"ReactionForComment").add("Reaction", (Object)this.reaction()).add("ReactionUsers", this.hasReactionUsers() ? this.reactionUsers() : null).add("ReactionsFromDeletedUsersCount", (Object)this.reactionsFromDeletedUsersCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "reaction": {
                return Optional.ofNullable(clazz.cast(this.reaction()));
            }
            case "reactionUsers": {
                return Optional.ofNullable(clazz.cast(this.reactionUsers()));
            }
            case "reactionsFromDeletedUsersCount": {
                return Optional.ofNullable(clazz.cast(this.reactionsFromDeletedUsersCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReactionForComment, T> g) {
        return obj -> g.apply((ReactionForComment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ReactionValueFormats reaction;
        private List<String> reactionUsers = DefaultSdkAutoConstructList.getInstance();
        private Integer reactionsFromDeletedUsersCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ReactionForComment model) {
            this.reaction(model.reaction);
            this.reactionUsers(model.reactionUsers);
            this.reactionsFromDeletedUsersCount(model.reactionsFromDeletedUsersCount);
        }

        public final ReactionValueFormats.Builder getReaction() {
            return this.reaction != null ? this.reaction.toBuilder() : null;
        }

        @Override
        public final Builder reaction(ReactionValueFormats reaction) {
            this.reaction = reaction;
            return this;
        }

        public final void setReaction(ReactionValueFormats.BuilderImpl reaction) {
            this.reaction = reaction != null ? reaction.build() : null;
        }

        public final Collection<String> getReactionUsers() {
            if (this.reactionUsers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.reactionUsers;
        }

        @Override
        public final Builder reactionUsers(Collection<String> reactionUsers) {
            this.reactionUsers = ReactionUsersListCopier.copy(reactionUsers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reactionUsers(String ... reactionUsers) {
            this.reactionUsers(Arrays.asList(reactionUsers));
            return this;
        }

        public final void setReactionUsers(Collection<String> reactionUsers) {
            this.reactionUsers = ReactionUsersListCopier.copy(reactionUsers);
        }

        public final Integer getReactionsFromDeletedUsersCount() {
            return this.reactionsFromDeletedUsersCount;
        }

        @Override
        public final Builder reactionsFromDeletedUsersCount(Integer reactionsFromDeletedUsersCount) {
            this.reactionsFromDeletedUsersCount = reactionsFromDeletedUsersCount;
            return this;
        }

        public final void setReactionsFromDeletedUsersCount(Integer reactionsFromDeletedUsersCount) {
            this.reactionsFromDeletedUsersCount = reactionsFromDeletedUsersCount;
        }

        public ReactionForComment build() {
            return new ReactionForComment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReactionForComment> {
        public Builder reaction(ReactionValueFormats var1);

        default public Builder reaction(Consumer<ReactionValueFormats.Builder> reaction) {
            return this.reaction((ReactionValueFormats)((ReactionValueFormats.Builder)ReactionValueFormats.builder().applyMutation(reaction)).build());
        }

        public Builder reactionUsers(Collection<String> var1);

        public Builder reactionUsers(String ... var1);

        public Builder reactionsFromDeletedUsersCount(Integer var1);
    }
}

