/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about conflicts in a merge operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Conflict implements SdkPojo, Serializable, ToCopyableBuilder<Conflict.Builder, Conflict> {
    private static final SdkField<ConflictMetadata> CONFLICT_METADATA_FIELD = SdkField
            .<ConflictMetadata> builder(MarshallingType.SDK_POJO).memberName("conflictMetadata")
            .getter(getter(Conflict::conflictMetadata)).setter(setter(Builder::conflictMetadata))
            .constructor(ConflictMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conflictMetadata").build()).build();

    private static final SdkField<List<MergeHunk>> MERGE_HUNKS_FIELD = SdkField
            .<List<MergeHunk>> builder(MarshallingType.LIST)
            .memberName("mergeHunks")
            .getter(getter(Conflict::mergeHunks))
            .setter(setter(Builder::mergeHunks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeHunks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MergeHunk> builder(MarshallingType.SDK_POJO)
                                            .constructor(MergeHunk::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFLICT_METADATA_FIELD,
            MERGE_HUNKS_FIELD));

    private static final long serialVersionUID = 1L;

    private final ConflictMetadata conflictMetadata;

    private final List<MergeHunk> mergeHunks;

    private Conflict(BuilderImpl builder) {
        this.conflictMetadata = builder.conflictMetadata;
        this.mergeHunks = builder.mergeHunks;
    }

    /**
     * <p>
     * Metadata about a conflict in a merge operation.
     * </p>
     * 
     * @return Metadata about a conflict in a merge operation.
     */
    public final ConflictMetadata conflictMetadata() {
        return conflictMetadata;
    }

    /**
     * Returns true if the MergeHunks property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasMergeHunks() {
        return mergeHunks != null && !(mergeHunks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of hunks that contain the differences between files or lines causing the conflict.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMergeHunks()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of hunks that contain the differences between files or lines causing the conflict.
     */
    public final List<MergeHunk> mergeHunks() {
        return mergeHunks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(conflictMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(hasMergeHunks() ? mergeHunks() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Conflict)) {
            return false;
        }
        Conflict other = (Conflict) obj;
        return Objects.equals(conflictMetadata(), other.conflictMetadata()) && hasMergeHunks() == other.hasMergeHunks()
                && Objects.equals(mergeHunks(), other.mergeHunks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Conflict").add("ConflictMetadata", conflictMetadata())
                .add("MergeHunks", hasMergeHunks() ? mergeHunks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "conflictMetadata":
            return Optional.ofNullable(clazz.cast(conflictMetadata()));
        case "mergeHunks":
            return Optional.ofNullable(clazz.cast(mergeHunks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Conflict, T> g) {
        return obj -> g.apply((Conflict) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Conflict> {
        /**
         * <p>
         * Metadata about a conflict in a merge operation.
         * </p>
         * 
         * @param conflictMetadata
         *        Metadata about a conflict in a merge operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conflictMetadata(ConflictMetadata conflictMetadata);

        /**
         * <p>
         * Metadata about a conflict in a merge operation.
         * </p>
         * This is a convenience that creates an instance of the {@link ConflictMetadata.Builder} avoiding the need to
         * create one manually via {@link ConflictMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConflictMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #conflictMetadata(ConflictMetadata)}.
         * 
         * @param conflictMetadata
         *        a consumer that will call methods on {@link ConflictMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conflictMetadata(ConflictMetadata)
         */
        default Builder conflictMetadata(Consumer<ConflictMetadata.Builder> conflictMetadata) {
            return conflictMetadata(ConflictMetadata.builder().applyMutation(conflictMetadata).build());
        }

        /**
         * <p>
         * A list of hunks that contain the differences between files or lines causing the conflict.
         * </p>
         * 
         * @param mergeHunks
         *        A list of hunks that contain the differences between files or lines causing the conflict.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mergeHunks(Collection<MergeHunk> mergeHunks);

        /**
         * <p>
         * A list of hunks that contain the differences between files or lines causing the conflict.
         * </p>
         * 
         * @param mergeHunks
         *        A list of hunks that contain the differences between files or lines causing the conflict.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mergeHunks(MergeHunk... mergeHunks);

        /**
         * <p>
         * A list of hunks that contain the differences between files or lines causing the conflict.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MergeHunk>.Builder} avoiding the need to
         * create one manually via {@link List<MergeHunk>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MergeHunk>.Builder#build()} is called immediately and its
         * result is passed to {@link #mergeHunks(List<MergeHunk>)}.
         * 
         * @param mergeHunks
         *        a consumer that will call methods on {@link List<MergeHunk>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mergeHunks(List<MergeHunk>)
         */
        Builder mergeHunks(Consumer<MergeHunk.Builder>... mergeHunks);
    }

    static final class BuilderImpl implements Builder {
        private ConflictMetadata conflictMetadata;

        private List<MergeHunk> mergeHunks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Conflict model) {
            conflictMetadata(model.conflictMetadata);
            mergeHunks(model.mergeHunks);
        }

        public final ConflictMetadata.Builder getConflictMetadata() {
            return conflictMetadata != null ? conflictMetadata.toBuilder() : null;
        }

        @Override
        public final Builder conflictMetadata(ConflictMetadata conflictMetadata) {
            this.conflictMetadata = conflictMetadata;
            return this;
        }

        public final void setConflictMetadata(ConflictMetadata.BuilderImpl conflictMetadata) {
            this.conflictMetadata = conflictMetadata != null ? conflictMetadata.build() : null;
        }

        public final List<MergeHunk.Builder> getMergeHunks() {
            List<MergeHunk.Builder> result = MergeHunksCopier.copyToBuilder(this.mergeHunks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder mergeHunks(Collection<MergeHunk> mergeHunks) {
            this.mergeHunks = MergeHunksCopier.copy(mergeHunks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mergeHunks(MergeHunk... mergeHunks) {
            mergeHunks(Arrays.asList(mergeHunks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mergeHunks(Consumer<MergeHunk.Builder>... mergeHunks) {
            mergeHunks(Stream.of(mergeHunks).map(c -> MergeHunk.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMergeHunks(Collection<MergeHunk.BuilderImpl> mergeHunks) {
            this.mergeHunks = MergeHunksCopier.copyFromBuilder(mergeHunks);
        }

        @Override
        public Conflict build() {
            return new Conflict(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
