/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetCommitsResponse extends CodeCommitResponse implements
        ToCopyableBuilder<BatchGetCommitsResponse.Builder, BatchGetCommitsResponse> {
    private static final SdkField<List<Commit>> COMMITS_FIELD = SdkField
            .<List<Commit>> builder(MarshallingType.LIST)
            .memberName("commits")
            .getter(getter(BatchGetCommitsResponse::commits))
            .setter(setter(Builder::commits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commits").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Commit> builder(MarshallingType.SDK_POJO)
                                            .constructor(Commit::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BatchGetCommitsError>> ERRORS_FIELD = SdkField
            .<List<BatchGetCommitsError>> builder(MarshallingType.LIST)
            .memberName("errors")
            .getter(getter(BatchGetCommitsResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchGetCommitsError> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchGetCommitsError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMITS_FIELD, ERRORS_FIELD));

    private final List<Commit> commits;

    private final List<BatchGetCommitsError> errors;

    private BatchGetCommitsResponse(BuilderImpl builder) {
        super(builder);
        this.commits = builder.commits;
        this.errors = builder.errors;
    }

    /**
     * Returns true if the Commits property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasCommits() {
        return commits != null && !(commits instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of commit data type objects, each of which contains information about a specified commit.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCommits()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of commit data type objects, each of which contains information about a specified commit.
     */
    public final List<Commit> commits() {
        return commits;
    }

    /**
     * Returns true if the Errors property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns any commit IDs for which information could not be found. For example, if one of the commit IDs was a
     * shortened SHA ID or that commit was not found in the specified repository, the ID returns an error object with
     * more information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasErrors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Returns any commit IDs for which information could not be found. For example, if one of the commit IDs
     *         was a shortened SHA ID or that commit was not found in the specified repository, the ID returns an error
     *         object with more information.
     */
    public final List<BatchGetCommitsError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCommits() ? commits() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetCommitsResponse)) {
            return false;
        }
        BatchGetCommitsResponse other = (BatchGetCommitsResponse) obj;
        return hasCommits() == other.hasCommits() && Objects.equals(commits(), other.commits())
                && hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetCommitsResponse").add("Commits", hasCommits() ? commits() : null)
                .add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "commits":
            return Optional.ofNullable(clazz.cast(commits()));
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetCommitsResponse, T> g) {
        return obj -> g.apply((BatchGetCommitsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetCommitsResponse> {
        /**
         * <p>
         * An array of commit data type objects, each of which contains information about a specified commit.
         * </p>
         * 
         * @param commits
         *        An array of commit data type objects, each of which contains information about a specified commit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commits(Collection<Commit> commits);

        /**
         * <p>
         * An array of commit data type objects, each of which contains information about a specified commit.
         * </p>
         * 
         * @param commits
         *        An array of commit data type objects, each of which contains information about a specified commit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commits(Commit... commits);

        /**
         * <p>
         * An array of commit data type objects, each of which contains information about a specified commit.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Commit>.Builder} avoiding the need to
         * create one manually via {@link List<Commit>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Commit>.Builder#build()} is called immediately and its
         * result is passed to {@link #commits(List<Commit>)}.
         * 
         * @param commits
         *        a consumer that will call methods on {@link List<Commit>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #commits(List<Commit>)
         */
        Builder commits(Consumer<Commit.Builder>... commits);

        /**
         * <p>
         * Returns any commit IDs for which information could not be found. For example, if one of the commit IDs was a
         * shortened SHA ID or that commit was not found in the specified repository, the ID returns an error object
         * with more information.
         * </p>
         * 
         * @param errors
         *        Returns any commit IDs for which information could not be found. For example, if one of the commit IDs
         *        was a shortened SHA ID or that commit was not found in the specified repository, the ID returns an
         *        error object with more information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<BatchGetCommitsError> errors);

        /**
         * <p>
         * Returns any commit IDs for which information could not be found. For example, if one of the commit IDs was a
         * shortened SHA ID or that commit was not found in the specified repository, the ID returns an error object
         * with more information.
         * </p>
         * 
         * @param errors
         *        Returns any commit IDs for which information could not be found. For example, if one of the commit IDs
         *        was a shortened SHA ID or that commit was not found in the specified repository, the ID returns an
         *        error object with more information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(BatchGetCommitsError... errors);

        /**
         * <p>
         * Returns any commit IDs for which information could not be found. For example, if one of the commit IDs was a
         * shortened SHA ID or that commit was not found in the specified repository, the ID returns an error object
         * with more information.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BatchGetCommitsError>.Builder} avoiding the
         * need to create one manually via {@link List<BatchGetCommitsError>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BatchGetCommitsError>.Builder#build()} is called immediately
         * and its result is passed to {@link #errors(List<BatchGetCommitsError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on {@link List<BatchGetCommitsError>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(List<BatchGetCommitsError>)
         */
        Builder errors(Consumer<BatchGetCommitsError.Builder>... errors);
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private List<Commit> commits = DefaultSdkAutoConstructList.getInstance();

        private List<BatchGetCommitsError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetCommitsResponse model) {
            super(model);
            commits(model.commits);
            errors(model.errors);
        }

        public final List<Commit.Builder> getCommits() {
            List<Commit.Builder> result = CommitObjectsListCopier.copyToBuilder(this.commits);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder commits(Collection<Commit> commits) {
            this.commits = CommitObjectsListCopier.copy(commits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commits(Commit... commits) {
            commits(Arrays.asList(commits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commits(Consumer<Commit.Builder>... commits) {
            commits(Stream.of(commits).map(c -> Commit.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCommits(Collection<Commit.BuilderImpl> commits) {
            this.commits = CommitObjectsListCopier.copyFromBuilder(commits);
        }

        public final List<BatchGetCommitsError.Builder> getErrors() {
            List<BatchGetCommitsError.Builder> result = BatchGetCommitsErrorsListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder errors(Collection<BatchGetCommitsError> errors) {
            this.errors = BatchGetCommitsErrorsListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchGetCommitsError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchGetCommitsError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> BatchGetCommitsError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setErrors(Collection<BatchGetCommitsError.BuilderImpl> errors) {
            this.errors = BatchGetCommitsErrorsListCopier.copyFromBuilder(errors);
        }

        @Override
        public BatchGetCommitsResponse build() {
            return new BatchGetCommitsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
