/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codecommit.model.BatchDescribeMergeConflictsError;
import software.amazon.awssdk.services.codecommit.model.BatchDescribeMergeConflictsErrorsCopier;
import software.amazon.awssdk.services.codecommit.model.CodeCommitResponse;
import software.amazon.awssdk.services.codecommit.model.Conflict;
import software.amazon.awssdk.services.codecommit.model.ConflictsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDescribeMergeConflictsResponse
extends CodeCommitResponse
implements ToCopyableBuilder<Builder, BatchDescribeMergeConflictsResponse> {
    private static final SdkField<List<Conflict>> CONFLICTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("conflicts").getter(BatchDescribeMergeConflictsResponse.getter(BatchDescribeMergeConflictsResponse::conflicts)).setter(BatchDescribeMergeConflictsResponse.setter(Builder::conflicts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conflicts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Conflict::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(BatchDescribeMergeConflictsResponse.getter(BatchDescribeMergeConflictsResponse::nextToken)).setter(BatchDescribeMergeConflictsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<BatchDescribeMergeConflictsError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(BatchDescribeMergeConflictsResponse.getter(BatchDescribeMergeConflictsResponse::errors)).setter(BatchDescribeMergeConflictsResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchDescribeMergeConflictsError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESTINATION_COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationCommitId").getter(BatchDescribeMergeConflictsResponse.getter(BatchDescribeMergeConflictsResponse::destinationCommitId)).setter(BatchDescribeMergeConflictsResponse.setter(Builder::destinationCommitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationCommitId").build()}).build();
    private static final SdkField<String> SOURCE_COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceCommitId").getter(BatchDescribeMergeConflictsResponse.getter(BatchDescribeMergeConflictsResponse::sourceCommitId)).setter(BatchDescribeMergeConflictsResponse.setter(Builder::sourceCommitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCommitId").build()}).build();
    private static final SdkField<String> BASE_COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("baseCommitId").getter(BatchDescribeMergeConflictsResponse.getter(BatchDescribeMergeConflictsResponse::baseCommitId)).setter(BatchDescribeMergeConflictsResponse.setter(Builder::baseCommitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseCommitId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFLICTS_FIELD, NEXT_TOKEN_FIELD, ERRORS_FIELD, DESTINATION_COMMIT_ID_FIELD, SOURCE_COMMIT_ID_FIELD, BASE_COMMIT_ID_FIELD));
    private final List<Conflict> conflicts;
    private final String nextToken;
    private final List<BatchDescribeMergeConflictsError> errors;
    private final String destinationCommitId;
    private final String sourceCommitId;
    private final String baseCommitId;

    private BatchDescribeMergeConflictsResponse(BuilderImpl builder) {
        super(builder);
        this.conflicts = builder.conflicts;
        this.nextToken = builder.nextToken;
        this.errors = builder.errors;
        this.destinationCommitId = builder.destinationCommitId;
        this.sourceCommitId = builder.sourceCommitId;
        this.baseCommitId = builder.baseCommitId;
    }

    public final boolean hasConflicts() {
        return this.conflicts != null && !(this.conflicts instanceof SdkAutoConstructList);
    }

    public final List<Conflict> conflicts() {
        return this.conflicts;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<BatchDescribeMergeConflictsError> errors() {
        return this.errors;
    }

    public final String destinationCommitId() {
        return this.destinationCommitId;
    }

    public final String sourceCommitId() {
        return this.sourceCommitId;
    }

    public final String baseCommitId() {
        return this.baseCommitId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConflicts() ? this.conflicts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseCommitId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDescribeMergeConflictsResponse)) {
            return false;
        }
        BatchDescribeMergeConflictsResponse other = (BatchDescribeMergeConflictsResponse)((Object)obj);
        return this.hasConflicts() == other.hasConflicts() && Objects.equals(this.conflicts(), other.conflicts()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors()) && Objects.equals(this.destinationCommitId(), other.destinationCommitId()) && Objects.equals(this.sourceCommitId(), other.sourceCommitId()) && Objects.equals(this.baseCommitId(), other.baseCommitId());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDescribeMergeConflictsResponse").add("Conflicts", this.hasConflicts() ? this.conflicts() : null).add("NextToken", (Object)this.nextToken()).add("Errors", this.hasErrors() ? this.errors() : null).add("DestinationCommitId", (Object)this.destinationCommitId()).add("SourceCommitId", (Object)this.sourceCommitId()).add("BaseCommitId", (Object)this.baseCommitId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "conflicts": {
                return Optional.ofNullable(clazz.cast(this.conflicts()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
            case "destinationCommitId": {
                return Optional.ofNullable(clazz.cast(this.destinationCommitId()));
            }
            case "sourceCommitId": {
                return Optional.ofNullable(clazz.cast(this.sourceCommitId()));
            }
            case "baseCommitId": {
                return Optional.ofNullable(clazz.cast(this.baseCommitId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDescribeMergeConflictsResponse, T> g) {
        return obj -> g.apply((BatchDescribeMergeConflictsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitResponse.BuilderImpl
    implements Builder {
        private List<Conflict> conflicts = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private List<BatchDescribeMergeConflictsError> errors = DefaultSdkAutoConstructList.getInstance();
        private String destinationCommitId;
        private String sourceCommitId;
        private String baseCommitId;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDescribeMergeConflictsResponse model) {
            super(model);
            this.conflicts(model.conflicts);
            this.nextToken(model.nextToken);
            this.errors(model.errors);
            this.destinationCommitId(model.destinationCommitId);
            this.sourceCommitId(model.sourceCommitId);
            this.baseCommitId(model.baseCommitId);
        }

        public final List<Conflict.Builder> getConflicts() {
            List<Conflict.Builder> result = ConflictsCopier.copyToBuilder(this.conflicts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder conflicts(Collection<Conflict> conflicts) {
            this.conflicts = ConflictsCopier.copy(conflicts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conflicts(Conflict ... conflicts) {
            this.conflicts(Arrays.asList(conflicts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conflicts(Consumer<Conflict.Builder> ... conflicts) {
            this.conflicts(Stream.of(conflicts).map(c -> (Conflict)((Conflict.Builder)Conflict.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConflicts(Collection<Conflict.BuilderImpl> conflicts) {
            this.conflicts = ConflictsCopier.copyFromBuilder(conflicts);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final List<BatchDescribeMergeConflictsError.Builder> getErrors() {
            List<BatchDescribeMergeConflictsError.Builder> result = BatchDescribeMergeConflictsErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder errors(Collection<BatchDescribeMergeConflictsError> errors) {
            this.errors = BatchDescribeMergeConflictsErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchDescribeMergeConflictsError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchDescribeMergeConflictsError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchDescribeMergeConflictsError)((BatchDescribeMergeConflictsError.Builder)BatchDescribeMergeConflictsError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setErrors(Collection<BatchDescribeMergeConflictsError.BuilderImpl> errors) {
            this.errors = BatchDescribeMergeConflictsErrorsCopier.copyFromBuilder(errors);
        }

        public final String getDestinationCommitId() {
            return this.destinationCommitId;
        }

        @Override
        public final Builder destinationCommitId(String destinationCommitId) {
            this.destinationCommitId = destinationCommitId;
            return this;
        }

        public final void setDestinationCommitId(String destinationCommitId) {
            this.destinationCommitId = destinationCommitId;
        }

        public final String getSourceCommitId() {
            return this.sourceCommitId;
        }

        @Override
        public final Builder sourceCommitId(String sourceCommitId) {
            this.sourceCommitId = sourceCommitId;
            return this;
        }

        public final void setSourceCommitId(String sourceCommitId) {
            this.sourceCommitId = sourceCommitId;
        }

        public final String getBaseCommitId() {
            return this.baseCommitId;
        }

        @Override
        public final Builder baseCommitId(String baseCommitId) {
            this.baseCommitId = baseCommitId;
            return this;
        }

        public final void setBaseCommitId(String baseCommitId) {
            this.baseCommitId = baseCommitId;
        }

        @Override
        public BatchDescribeMergeConflictsResponse build() {
            return new BatchDescribeMergeConflictsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCommitResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDescribeMergeConflictsResponse> {
        public Builder conflicts(Collection<Conflict> var1);

        public Builder conflicts(Conflict ... var1);

        public Builder conflicts(Consumer<Conflict.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder errors(Collection<BatchDescribeMergeConflictsError> var1);

        public Builder errors(BatchDescribeMergeConflictsError ... var1);

        public Builder errors(Consumer<BatchDescribeMergeConflictsError.Builder> ... var1);

        public Builder destinationCommitId(String var1);

        public Builder sourceCommitId(String var1);

        public Builder baseCommitId(String var1);
    }
}

