/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a list branches operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBranchesResponse extends CodeCommitResponse implements
        ToCopyableBuilder<ListBranchesResponse.Builder, ListBranchesResponse> {
    private static final SdkField<List<String>> BRANCHES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("branches")
            .getter(getter(ListBranchesResponse::branches))
            .setter(setter(Builder::branches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branches").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListBranchesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRANCHES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> branches;

    private final String nextToken;

    private ListBranchesResponse(BuilderImpl builder) {
        super(builder);
        this.branches = builder.branches;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Branches property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBranches() {
        return branches != null && !(branches instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of branch names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBranches} method.
     * </p>
     * 
     * @return The list of branch names.
     */
    public final List<String> branches() {
        return branches;
    }

    /**
     * <p>
     * An enumeration token that returns the batch of the results.
     * </p>
     * 
     * @return An enumeration token that returns the batch of the results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBranches() ? branches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBranchesResponse)) {
            return false;
        }
        ListBranchesResponse other = (ListBranchesResponse) obj;
        return hasBranches() == other.hasBranches() && Objects.equals(branches(), other.branches())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBranchesResponse").add("Branches", hasBranches() ? branches() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "branches":
            return Optional.ofNullable(clazz.cast(branches()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBranchesResponse, T> g) {
        return obj -> g.apply((ListBranchesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListBranchesResponse> {
        /**
         * <p>
         * The list of branch names.
         * </p>
         * 
         * @param branches
         *        The list of branch names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branches(Collection<String> branches);

        /**
         * <p>
         * The list of branch names.
         * </p>
         * 
         * @param branches
         *        The list of branch names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branches(String... branches);

        /**
         * <p>
         * An enumeration token that returns the batch of the results.
         * </p>
         * 
         * @param nextToken
         *        An enumeration token that returns the batch of the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private List<String> branches = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBranchesResponse model) {
            super(model);
            branches(model.branches);
            nextToken(model.nextToken);
        }

        public final Collection<String> getBranches() {
            if (branches instanceof SdkAutoConstructList) {
                return null;
            }
            return branches;
        }

        public final void setBranches(Collection<String> branches) {
            this.branches = BranchNameListCopier.copy(branches);
        }

        @Override
        @Transient
        public final Builder branches(Collection<String> branches) {
            this.branches = BranchNameListCopier.copy(branches);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder branches(String... branches) {
            branches(Arrays.asList(branches));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBranchesResponse build() {
            return new ListBranchesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
