/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDifferencesResponse extends CodeCommitResponse implements
        ToCopyableBuilder<GetDifferencesResponse.Builder, GetDifferencesResponse> {
    private static final SdkField<List<Difference>> DIFFERENCES_FIELD = SdkField
            .<List<Difference>> builder(MarshallingType.LIST)
            .memberName("differences")
            .getter(getter(GetDifferencesResponse::differences))
            .setter(setter(Builder::differences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("differences").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Difference> builder(MarshallingType.SDK_POJO)
                                            .constructor(Difference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetDifferencesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIFFERENCES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Difference> differences;

    private final String nextToken;

    private GetDifferencesResponse(BuilderImpl builder) {
        super(builder);
        this.differences = builder.differences;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Differences property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDifferences() {
        return differences != null && !(differences instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A data type object that contains information about the differences, including whether the difference is added,
     * modified, or deleted (A, D, M).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDifferences} method.
     * </p>
     * 
     * @return A data type object that contains information about the differences, including whether the difference is
     *         added, modified, or deleted (A, D, M).
     */
    public final List<Difference> differences() {
        return differences;
    }

    /**
     * <p>
     * An enumeration token that can be used in a request to return the next batch of the results.
     * </p>
     * 
     * @return An enumeration token that can be used in a request to return the next batch of the results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDifferences() ? differences() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDifferencesResponse)) {
            return false;
        }
        GetDifferencesResponse other = (GetDifferencesResponse) obj;
        return hasDifferences() == other.hasDifferences() && Objects.equals(differences(), other.differences())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDifferencesResponse").add("Differences", hasDifferences() ? differences() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "differences":
            return Optional.ofNullable(clazz.cast(differences()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDifferencesResponse, T> g) {
        return obj -> g.apply((GetDifferencesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDifferencesResponse> {
        /**
         * <p>
         * A data type object that contains information about the differences, including whether the difference is
         * added, modified, or deleted (A, D, M).
         * </p>
         * 
         * @param differences
         *        A data type object that contains information about the differences, including whether the difference
         *        is added, modified, or deleted (A, D, M).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder differences(Collection<Difference> differences);

        /**
         * <p>
         * A data type object that contains information about the differences, including whether the difference is
         * added, modified, or deleted (A, D, M).
         * </p>
         * 
         * @param differences
         *        A data type object that contains information about the differences, including whether the difference
         *        is added, modified, or deleted (A, D, M).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder differences(Difference... differences);

        /**
         * <p>
         * A data type object that contains information about the differences, including whether the difference is
         * added, modified, or deleted (A, D, M).
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Difference>.Builder} avoiding the
         * need to create one manually via {@link List<Difference>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Difference>.Builder#build()} is called immediately and its
         * result is passed to {@link #differences(List<Difference>)}.
         * 
         * @param differences
         *        a consumer that will call methods on {@link List<Difference>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #differences(List<Difference>)
         */
        Builder differences(Consumer<Difference.Builder>... differences);

        /**
         * <p>
         * An enumeration token that can be used in a request to return the next batch of the results.
         * </p>
         * 
         * @param nextToken
         *        An enumeration token that can be used in a request to return the next batch of the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private List<Difference> differences = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDifferencesResponse model) {
            super(model);
            differences(model.differences);
            nextToken(model.nextToken);
        }

        public final List<Difference.Builder> getDifferences() {
            List<Difference.Builder> result = DifferenceListCopier.copyToBuilder(this.differences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDifferences(Collection<Difference.BuilderImpl> differences) {
            this.differences = DifferenceListCopier.copyFromBuilder(differences);
        }

        @Override
        public final Builder differences(Collection<Difference> differences) {
            this.differences = DifferenceListCopier.copy(differences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder differences(Difference... differences) {
            differences(Arrays.asList(differences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder differences(Consumer<Difference.Builder>... differences) {
            differences(Stream.of(differences).map(c -> Difference.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetDifferencesResponse build() {
            return new GetDifferencesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
