/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information about the change in the merge state for a pull request event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PullRequestMergedStateChangedEventMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<PullRequestMergedStateChangedEventMetadata.Builder, PullRequestMergedStateChangedEventMetadata> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(PullRequestMergedStateChangedEventMetadata::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> DESTINATION_REFERENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationReference").getter(getter(PullRequestMergedStateChangedEventMetadata::destinationReference))
            .setter(setter(Builder::destinationReference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationReference").build())
            .build();

    private static final SdkField<MergeMetadata> MERGE_METADATA_FIELD = SdkField
            .<MergeMetadata> builder(MarshallingType.SDK_POJO).memberName("mergeMetadata")
            .getter(getter(PullRequestMergedStateChangedEventMetadata::mergeMetadata)).setter(setter(Builder::mergeMetadata))
            .constructor(MergeMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeMetadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD,
            DESTINATION_REFERENCE_FIELD, MERGE_METADATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String repositoryName;

    private final String destinationReference;

    private final MergeMetadata mergeMetadata;

    private PullRequestMergedStateChangedEventMetadata(BuilderImpl builder) {
        this.repositoryName = builder.repositoryName;
        this.destinationReference = builder.destinationReference;
        this.mergeMetadata = builder.mergeMetadata;
    }

    /**
     * <p>
     * The name of the repository where the pull request was created.
     * </p>
     * 
     * @return The name of the repository where the pull request was created.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The name of the branch that the pull request is merged into.
     * </p>
     * 
     * @return The name of the branch that the pull request is merged into.
     */
    public final String destinationReference() {
        return destinationReference;
    }

    /**
     * <p>
     * Information about the merge state change event.
     * </p>
     * 
     * @return Information about the merge state change event.
     */
    public final MergeMetadata mergeMetadata() {
        return mergeMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(destinationReference());
        hashCode = 31 * hashCode + Objects.hashCode(mergeMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PullRequestMergedStateChangedEventMetadata)) {
            return false;
        }
        PullRequestMergedStateChangedEventMetadata other = (PullRequestMergedStateChangedEventMetadata) obj;
        return Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(destinationReference(), other.destinationReference())
                && Objects.equals(mergeMetadata(), other.mergeMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PullRequestMergedStateChangedEventMetadata").add("RepositoryName", repositoryName())
                .add("DestinationReference", destinationReference()).add("MergeMetadata", mergeMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "destinationReference":
            return Optional.ofNullable(clazz.cast(destinationReference()));
        case "mergeMetadata":
            return Optional.ofNullable(clazz.cast(mergeMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PullRequestMergedStateChangedEventMetadata, T> g) {
        return obj -> g.apply((PullRequestMergedStateChangedEventMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PullRequestMergedStateChangedEventMetadata> {
        /**
         * <p>
         * The name of the repository where the pull request was created.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository where the pull request was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The name of the branch that the pull request is merged into.
         * </p>
         * 
         * @param destinationReference
         *        The name of the branch that the pull request is merged into.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationReference(String destinationReference);

        /**
         * <p>
         * Information about the merge state change event.
         * </p>
         * 
         * @param mergeMetadata
         *        Information about the merge state change event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mergeMetadata(MergeMetadata mergeMetadata);

        /**
         * <p>
         * Information about the merge state change event.
         * </p>
         * This is a convenience method that creates an instance of the {@link MergeMetadata.Builder} avoiding the need
         * to create one manually via {@link MergeMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link MergeMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #mergeMetadata(MergeMetadata)}.
         * 
         * @param mergeMetadata
         *        a consumer that will call methods on {@link MergeMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mergeMetadata(MergeMetadata)
         */
        default Builder mergeMetadata(Consumer<MergeMetadata.Builder> mergeMetadata) {
            return mergeMetadata(MergeMetadata.builder().applyMutation(mergeMetadata).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String repositoryName;

        private String destinationReference;

        private MergeMetadata mergeMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(PullRequestMergedStateChangedEventMetadata model) {
            repositoryName(model.repositoryName);
            destinationReference(model.destinationReference);
            mergeMetadata(model.mergeMetadata);
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getDestinationReference() {
            return destinationReference;
        }

        public final void setDestinationReference(String destinationReference) {
            this.destinationReference = destinationReference;
        }

        @Override
        public final Builder destinationReference(String destinationReference) {
            this.destinationReference = destinationReference;
            return this;
        }

        public final MergeMetadata.Builder getMergeMetadata() {
            return mergeMetadata != null ? mergeMetadata.toBuilder() : null;
        }

        public final void setMergeMetadata(MergeMetadata.BuilderImpl mergeMetadata) {
            this.mergeMetadata = mergeMetadata != null ? mergeMetadata.build() : null;
        }

        @Override
        public final Builder mergeMetadata(MergeMetadata mergeMetadata) {
            this.mergeMetadata = mergeMetadata;
            return this;
        }

        @Override
        public PullRequestMergedStateChangedEventMetadata build() {
            return new PullRequestMergedStateChangedEventMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
