/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about merge hunks in a merge or pull request operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MergeHunk implements SdkPojo, Serializable, ToCopyableBuilder<MergeHunk.Builder, MergeHunk> {
    private static final SdkField<Boolean> IS_CONFLICT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isConflict").getter(getter(MergeHunk::isConflict)).setter(setter(Builder::isConflict))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isConflict").build()).build();

    private static final SdkField<MergeHunkDetail> SOURCE_FIELD = SdkField.<MergeHunkDetail> builder(MarshallingType.SDK_POJO)
            .memberName("source").getter(getter(MergeHunk::source)).setter(setter(Builder::source))
            .constructor(MergeHunkDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<MergeHunkDetail> DESTINATION_FIELD = SdkField
            .<MergeHunkDetail> builder(MarshallingType.SDK_POJO).memberName("destination").getter(getter(MergeHunk::destination))
            .setter(setter(Builder::destination)).constructor(MergeHunkDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final SdkField<MergeHunkDetail> BASE_FIELD = SdkField.<MergeHunkDetail> builder(MarshallingType.SDK_POJO)
            .memberName("base").getter(getter(MergeHunk::base)).setter(setter(Builder::base))
            .constructor(MergeHunkDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("base").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_CONFLICT_FIELD,
            SOURCE_FIELD, DESTINATION_FIELD, BASE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean isConflict;

    private final MergeHunkDetail source;

    private final MergeHunkDetail destination;

    private final MergeHunkDetail base;

    private MergeHunk(BuilderImpl builder) {
        this.isConflict = builder.isConflict;
        this.source = builder.source;
        this.destination = builder.destination;
        this.base = builder.base;
    }

    /**
     * <p>
     * A Boolean value indicating whether a combination of hunks contains a conflict. Conflicts occur when the same file
     * or the same lines in a file were modified in both the source and destination of a merge or pull request. Valid
     * values include true, false, and null. True when the hunk represents a conflict and one or more files contains a
     * line conflict. File mode conflicts in a merge do not set this to true.
     * </p>
     * 
     * @return A Boolean value indicating whether a combination of hunks contains a conflict. Conflicts occur when the
     *         same file or the same lines in a file were modified in both the source and destination of a merge or pull
     *         request. Valid values include true, false, and null. True when the hunk represents a conflict and one or
     *         more files contains a line conflict. File mode conflicts in a merge do not set this to true.
     */
    public final Boolean isConflict() {
        return isConflict;
    }

    /**
     * <p>
     * Information about the merge hunk in the source of a merge or pull request.
     * </p>
     * 
     * @return Information about the merge hunk in the source of a merge or pull request.
     */
    public final MergeHunkDetail source() {
        return source;
    }

    /**
     * <p>
     * Information about the merge hunk in the destination of a merge or pull request.
     * </p>
     * 
     * @return Information about the merge hunk in the destination of a merge or pull request.
     */
    public final MergeHunkDetail destination() {
        return destination;
    }

    /**
     * <p>
     * Information about the merge hunk in the base of a merge or pull request.
     * </p>
     * 
     * @return Information about the merge hunk in the base of a merge or pull request.
     */
    public final MergeHunkDetail base() {
        return base;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isConflict());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(base());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MergeHunk)) {
            return false;
        }
        MergeHunk other = (MergeHunk) obj;
        return Objects.equals(isConflict(), other.isConflict()) && Objects.equals(source(), other.source())
                && Objects.equals(destination(), other.destination()) && Objects.equals(base(), other.base());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MergeHunk").add("IsConflict", isConflict()).add("Source", source())
                .add("Destination", destination()).add("Base", base()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "isConflict":
            return Optional.ofNullable(clazz.cast(isConflict()));
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "base":
            return Optional.ofNullable(clazz.cast(base()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MergeHunk, T> g) {
        return obj -> g.apply((MergeHunk) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MergeHunk> {
        /**
         * <p>
         * A Boolean value indicating whether a combination of hunks contains a conflict. Conflicts occur when the same
         * file or the same lines in a file were modified in both the source and destination of a merge or pull request.
         * Valid values include true, false, and null. True when the hunk represents a conflict and one or more files
         * contains a line conflict. File mode conflicts in a merge do not set this to true.
         * </p>
         * 
         * @param isConflict
         *        A Boolean value indicating whether a combination of hunks contains a conflict. Conflicts occur when
         *        the same file or the same lines in a file were modified in both the source and destination of a merge
         *        or pull request. Valid values include true, false, and null. True when the hunk represents a conflict
         *        and one or more files contains a line conflict. File mode conflicts in a merge do not set this to
         *        true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isConflict(Boolean isConflict);

        /**
         * <p>
         * Information about the merge hunk in the source of a merge or pull request.
         * </p>
         * 
         * @param source
         *        Information about the merge hunk in the source of a merge or pull request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(MergeHunkDetail source);

        /**
         * <p>
         * Information about the merge hunk in the source of a merge or pull request.
         * </p>
         * This is a convenience method that creates an instance of the {@link MergeHunkDetail.Builder} avoiding the
         * need to create one manually via {@link MergeHunkDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link MergeHunkDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #source(MergeHunkDetail)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link MergeHunkDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(MergeHunkDetail)
         */
        default Builder source(Consumer<MergeHunkDetail.Builder> source) {
            return source(MergeHunkDetail.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * Information about the merge hunk in the destination of a merge or pull request.
         * </p>
         * 
         * @param destination
         *        Information about the merge hunk in the destination of a merge or pull request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(MergeHunkDetail destination);

        /**
         * <p>
         * Information about the merge hunk in the destination of a merge or pull request.
         * </p>
         * This is a convenience method that creates an instance of the {@link MergeHunkDetail.Builder} avoiding the
         * need to create one manually via {@link MergeHunkDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link MergeHunkDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #destination(MergeHunkDetail)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link MergeHunkDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(MergeHunkDetail)
         */
        default Builder destination(Consumer<MergeHunkDetail.Builder> destination) {
            return destination(MergeHunkDetail.builder().applyMutation(destination).build());
        }

        /**
         * <p>
         * Information about the merge hunk in the base of a merge or pull request.
         * </p>
         * 
         * @param base
         *        Information about the merge hunk in the base of a merge or pull request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder base(MergeHunkDetail base);

        /**
         * <p>
         * Information about the merge hunk in the base of a merge or pull request.
         * </p>
         * This is a convenience method that creates an instance of the {@link MergeHunkDetail.Builder} avoiding the
         * need to create one manually via {@link MergeHunkDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link MergeHunkDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #base(MergeHunkDetail)}.
         * 
         * @param base
         *        a consumer that will call methods on {@link MergeHunkDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #base(MergeHunkDetail)
         */
        default Builder base(Consumer<MergeHunkDetail.Builder> base) {
            return base(MergeHunkDetail.builder().applyMutation(base).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean isConflict;

        private MergeHunkDetail source;

        private MergeHunkDetail destination;

        private MergeHunkDetail base;

        private BuilderImpl() {
        }

        private BuilderImpl(MergeHunk model) {
            isConflict(model.isConflict);
            source(model.source);
            destination(model.destination);
            base(model.base);
        }

        public final Boolean getIsConflict() {
            return isConflict;
        }

        public final void setIsConflict(Boolean isConflict) {
            this.isConflict = isConflict;
        }

        @Override
        public final Builder isConflict(Boolean isConflict) {
            this.isConflict = isConflict;
            return this;
        }

        public final MergeHunkDetail.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(MergeHunkDetail.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(MergeHunkDetail source) {
            this.source = source;
            return this;
        }

        public final MergeHunkDetail.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        public final void setDestination(MergeHunkDetail.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(MergeHunkDetail destination) {
            this.destination = destination;
            return this;
        }

        public final MergeHunkDetail.Builder getBase() {
            return base != null ? base.toBuilder() : null;
        }

        public final void setBase(MergeHunkDetail.BuilderImpl base) {
            this.base = base != null ? base.build() : null;
        }

        @Override
        public final Builder base(MergeHunkDetail base) {
            this.base = base;
            return this;
        }

        @Override
        public MergeHunk build() {
            return new MergeHunk(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
