/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information about comments on a pull request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CommentsForPullRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<CommentsForPullRequest.Builder, CommentsForPullRequest> {
    private static final SdkField<String> PULL_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pullRequestId").getter(getter(CommentsForPullRequest::pullRequestId))
            .setter(setter(Builder::pullRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestId").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(CommentsForPullRequest::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> BEFORE_COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("beforeCommitId").getter(getter(CommentsForPullRequest::beforeCommitId))
            .setter(setter(Builder::beforeCommitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beforeCommitId").build()).build();

    private static final SdkField<String> AFTER_COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("afterCommitId").getter(getter(CommentsForPullRequest::afterCommitId))
            .setter(setter(Builder::afterCommitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterCommitId").build()).build();

    private static final SdkField<String> BEFORE_BLOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("beforeBlobId").getter(getter(CommentsForPullRequest::beforeBlobId))
            .setter(setter(Builder::beforeBlobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beforeBlobId").build()).build();

    private static final SdkField<String> AFTER_BLOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("afterBlobId").getter(getter(CommentsForPullRequest::afterBlobId)).setter(setter(Builder::afterBlobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterBlobId").build()).build();

    private static final SdkField<Location> LOCATION_FIELD = SdkField.<Location> builder(MarshallingType.SDK_POJO)
            .memberName("location").getter(getter(CommentsForPullRequest::location)).setter(setter(Builder::location))
            .constructor(Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final SdkField<List<Comment>> COMMENTS_FIELD = SdkField
            .<List<Comment>> builder(MarshallingType.LIST)
            .memberName("comments")
            .getter(getter(CommentsForPullRequest::comments))
            .setter(setter(Builder::comments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Comment> builder(MarshallingType.SDK_POJO)
                                            .constructor(Comment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PULL_REQUEST_ID_FIELD,
            REPOSITORY_NAME_FIELD, BEFORE_COMMIT_ID_FIELD, AFTER_COMMIT_ID_FIELD, BEFORE_BLOB_ID_FIELD, AFTER_BLOB_ID_FIELD,
            LOCATION_FIELD, COMMENTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String pullRequestId;

    private final String repositoryName;

    private final String beforeCommitId;

    private final String afterCommitId;

    private final String beforeBlobId;

    private final String afterBlobId;

    private final Location location;

    private final List<Comment> comments;

    private CommentsForPullRequest(BuilderImpl builder) {
        this.pullRequestId = builder.pullRequestId;
        this.repositoryName = builder.repositoryName;
        this.beforeCommitId = builder.beforeCommitId;
        this.afterCommitId = builder.afterCommitId;
        this.beforeBlobId = builder.beforeBlobId;
        this.afterBlobId = builder.afterBlobId;
        this.location = builder.location;
        this.comments = builder.comments;
    }

    /**
     * <p>
     * The system-generated ID of the pull request.
     * </p>
     * 
     * @return The system-generated ID of the pull request.
     */
    public final String pullRequestId() {
        return pullRequestId;
    }

    /**
     * <p>
     * The name of the repository that contains the pull request.
     * </p>
     * 
     * @return The name of the repository that contains the pull request.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The full commit ID of the commit that was the tip of the destination branch when the pull request was created.
     * This commit is superceded by the after commit in the source branch when and if you merge the source branch into
     * the destination branch.
     * </p>
     * 
     * @return The full commit ID of the commit that was the tip of the destination branch when the pull request was
     *         created. This commit is superceded by the after commit in the source branch when and if you merge the
     *         source branch into the destination branch.
     */
    public final String beforeCommitId() {
        return beforeCommitId;
    }

    /**
     * <p>
     * The full commit ID of the commit that was the tip of the source branch at the time the comment was made.
     * </p>
     * 
     * @return The full commit ID of the commit that was the tip of the source branch at the time the comment was made.
     */
    public final String afterCommitId() {
        return afterCommitId;
    }

    /**
     * <p>
     * The full blob ID of the file on which you want to comment on the destination commit.
     * </p>
     * 
     * @return The full blob ID of the file on which you want to comment on the destination commit.
     */
    public final String beforeBlobId() {
        return beforeBlobId;
    }

    /**
     * <p>
     * The full blob ID of the file on which you want to comment on the source commit.
     * </p>
     * 
     * @return The full blob ID of the file on which you want to comment on the source commit.
     */
    public final String afterBlobId() {
        return afterBlobId;
    }

    /**
     * <p>
     * Location information about the comment on the pull request, including the file name, line number, and whether the
     * version of the file where the comment was made is BEFORE (destination branch) or AFTER (source branch).
     * </p>
     * 
     * @return Location information about the comment on the pull request, including the file name, line number, and
     *         whether the version of the file where the comment was made is BEFORE (destination branch) or AFTER
     *         (source branch).
     */
    public final Location location() {
        return location;
    }

    /**
     * For responses, this returns true if the service returned a value for the Comments property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasComments() {
        return comments != null && !(comments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of comment objects. Each comment object contains information about a comment on the pull request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComments} method.
     * </p>
     * 
     * @return An array of comment objects. Each comment object contains information about a comment on the pull
     *         request.
     */
    public final List<Comment> comments() {
        return comments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pullRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(beforeCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(afterCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(beforeBlobId());
        hashCode = 31 * hashCode + Objects.hashCode(afterBlobId());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(hasComments() ? comments() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommentsForPullRequest)) {
            return false;
        }
        CommentsForPullRequest other = (CommentsForPullRequest) obj;
        return Objects.equals(pullRequestId(), other.pullRequestId()) && Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(beforeCommitId(), other.beforeCommitId())
                && Objects.equals(afterCommitId(), other.afterCommitId()) && Objects.equals(beforeBlobId(), other.beforeBlobId())
                && Objects.equals(afterBlobId(), other.afterBlobId()) && Objects.equals(location(), other.location())
                && hasComments() == other.hasComments() && Objects.equals(comments(), other.comments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CommentsForPullRequest").add("PullRequestId", pullRequestId())
                .add("RepositoryName", repositoryName()).add("BeforeCommitId", beforeCommitId())
                .add("AfterCommitId", afterCommitId()).add("BeforeBlobId", beforeBlobId()).add("AfterBlobId", afterBlobId())
                .add("Location", location()).add("Comments", hasComments() ? comments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pullRequestId":
            return Optional.ofNullable(clazz.cast(pullRequestId()));
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "beforeCommitId":
            return Optional.ofNullable(clazz.cast(beforeCommitId()));
        case "afterCommitId":
            return Optional.ofNullable(clazz.cast(afterCommitId()));
        case "beforeBlobId":
            return Optional.ofNullable(clazz.cast(beforeBlobId()));
        case "afterBlobId":
            return Optional.ofNullable(clazz.cast(afterBlobId()));
        case "location":
            return Optional.ofNullable(clazz.cast(location()));
        case "comments":
            return Optional.ofNullable(clazz.cast(comments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CommentsForPullRequest, T> g) {
        return obj -> g.apply((CommentsForPullRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CommentsForPullRequest> {
        /**
         * <p>
         * The system-generated ID of the pull request.
         * </p>
         * 
         * @param pullRequestId
         *        The system-generated ID of the pull request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pullRequestId(String pullRequestId);

        /**
         * <p>
         * The name of the repository that contains the pull request.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository that contains the pull request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The full commit ID of the commit that was the tip of the destination branch when the pull request was
         * created. This commit is superceded by the after commit in the source branch when and if you merge the source
         * branch into the destination branch.
         * </p>
         * 
         * @param beforeCommitId
         *        The full commit ID of the commit that was the tip of the destination branch when the pull request was
         *        created. This commit is superceded by the after commit in the source branch when and if you merge the
         *        source branch into the destination branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beforeCommitId(String beforeCommitId);

        /**
         * <p>
         * The full commit ID of the commit that was the tip of the source branch at the time the comment was made.
         * </p>
         * 
         * @param afterCommitId
         *        The full commit ID of the commit that was the tip of the source branch at the time the comment was
         *        made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterCommitId(String afterCommitId);

        /**
         * <p>
         * The full blob ID of the file on which you want to comment on the destination commit.
         * </p>
         * 
         * @param beforeBlobId
         *        The full blob ID of the file on which you want to comment on the destination commit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beforeBlobId(String beforeBlobId);

        /**
         * <p>
         * The full blob ID of the file on which you want to comment on the source commit.
         * </p>
         * 
         * @param afterBlobId
         *        The full blob ID of the file on which you want to comment on the source commit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterBlobId(String afterBlobId);

        /**
         * <p>
         * Location information about the comment on the pull request, including the file name, line number, and whether
         * the version of the file where the comment was made is BEFORE (destination branch) or AFTER (source branch).
         * </p>
         * 
         * @param location
         *        Location information about the comment on the pull request, including the file name, line number, and
         *        whether the version of the file where the comment was made is BEFORE (destination branch) or AFTER
         *        (source branch).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(Location location);

        /**
         * <p>
         * Location information about the comment on the pull request, including the file name, line number, and whether
         * the version of the file where the comment was made is BEFORE (destination branch) or AFTER (source branch).
         * </p>
         * This is a convenience method that creates an instance of the {@link Location.Builder} avoiding the need to
         * create one manually via {@link Location#builder()}.
         *
         * When the {@link Consumer} completes, {@link Location.Builder#build()} is called immediately and its result is
         * passed to {@link #location(Location)}.
         * 
         * @param location
         *        a consumer that will call methods on {@link Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #location(Location)
         */
        default Builder location(Consumer<Location.Builder> location) {
            return location(Location.builder().applyMutation(location).build());
        }

        /**
         * <p>
         * An array of comment objects. Each comment object contains information about a comment on the pull request.
         * </p>
         * 
         * @param comments
         *        An array of comment objects. Each comment object contains information about a comment on the pull
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comments(Collection<Comment> comments);

        /**
         * <p>
         * An array of comment objects. Each comment object contains information about a comment on the pull request.
         * </p>
         * 
         * @param comments
         *        An array of comment objects. Each comment object contains information about a comment on the pull
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comments(Comment... comments);

        /**
         * <p>
         * An array of comment objects. Each comment object contains information about a comment on the pull request.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Comment>.Builder} avoiding the need
         * to create one manually via {@link List<Comment>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Comment>.Builder#build()} is called immediately and its
         * result is passed to {@link #comments(List<Comment>)}.
         * 
         * @param comments
         *        a consumer that will call methods on {@link List<Comment>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #comments(List<Comment>)
         */
        Builder comments(Consumer<Comment.Builder>... comments);
    }

    static final class BuilderImpl implements Builder {
        private String pullRequestId;

        private String repositoryName;

        private String beforeCommitId;

        private String afterCommitId;

        private String beforeBlobId;

        private String afterBlobId;

        private Location location;

        private List<Comment> comments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CommentsForPullRequest model) {
            pullRequestId(model.pullRequestId);
            repositoryName(model.repositoryName);
            beforeCommitId(model.beforeCommitId);
            afterCommitId(model.afterCommitId);
            beforeBlobId(model.beforeBlobId);
            afterBlobId(model.afterBlobId);
            location(model.location);
            comments(model.comments);
        }

        public final String getPullRequestId() {
            return pullRequestId;
        }

        public final void setPullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
        }

        @Override
        public final Builder pullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
            return this;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getBeforeCommitId() {
            return beforeCommitId;
        }

        public final void setBeforeCommitId(String beforeCommitId) {
            this.beforeCommitId = beforeCommitId;
        }

        @Override
        public final Builder beforeCommitId(String beforeCommitId) {
            this.beforeCommitId = beforeCommitId;
            return this;
        }

        public final String getAfterCommitId() {
            return afterCommitId;
        }

        public final void setAfterCommitId(String afterCommitId) {
            this.afterCommitId = afterCommitId;
        }

        @Override
        public final Builder afterCommitId(String afterCommitId) {
            this.afterCommitId = afterCommitId;
            return this;
        }

        public final String getBeforeBlobId() {
            return beforeBlobId;
        }

        public final void setBeforeBlobId(String beforeBlobId) {
            this.beforeBlobId = beforeBlobId;
        }

        @Override
        public final Builder beforeBlobId(String beforeBlobId) {
            this.beforeBlobId = beforeBlobId;
            return this;
        }

        public final String getAfterBlobId() {
            return afterBlobId;
        }

        public final void setAfterBlobId(String afterBlobId) {
            this.afterBlobId = afterBlobId;
        }

        @Override
        public final Builder afterBlobId(String afterBlobId) {
            this.afterBlobId = afterBlobId;
            return this;
        }

        public final Location.Builder getLocation() {
            return location != null ? location.toBuilder() : null;
        }

        public final void setLocation(Location.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        public final Builder location(Location location) {
            this.location = location;
            return this;
        }

        public final List<Comment.Builder> getComments() {
            List<Comment.Builder> result = CommentsCopier.copyToBuilder(this.comments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComments(Collection<Comment.BuilderImpl> comments) {
            this.comments = CommentsCopier.copyFromBuilder(comments);
        }

        @Override
        public final Builder comments(Collection<Comment> comments) {
            this.comments = CommentsCopier.copy(comments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder comments(Comment... comments) {
            comments(Arrays.asList(comments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder comments(Consumer<Comment.Builder>... comments) {
            comments(Stream.of(comments).map(c -> Comment.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CommentsForPullRequest build() {
            return new CommentsForPullRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
