/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a change to the status of a pull request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PullRequestStatusChangedEventMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<PullRequestStatusChangedEventMetadata.Builder, PullRequestStatusChangedEventMetadata> {
    private static final SdkField<String> PULL_REQUEST_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pullRequestStatus").getter(getter(PullRequestStatusChangedEventMetadata::pullRequestStatusAsString))
            .setter(setter(Builder::pullRequestStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PULL_REQUEST_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String pullRequestStatus;

    private PullRequestStatusChangedEventMetadata(BuilderImpl builder) {
        this.pullRequestStatus = builder.pullRequestStatus;
    }

    /**
     * <p>
     * The changed status of the pull request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pullRequestStatus}
     * will return {@link PullRequestStatusEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #pullRequestStatusAsString}.
     * </p>
     * 
     * @return The changed status of the pull request.
     * @see PullRequestStatusEnum
     */
    public final PullRequestStatusEnum pullRequestStatus() {
        return PullRequestStatusEnum.fromValue(pullRequestStatus);
    }

    /**
     * <p>
     * The changed status of the pull request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pullRequestStatus}
     * will return {@link PullRequestStatusEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #pullRequestStatusAsString}.
     * </p>
     * 
     * @return The changed status of the pull request.
     * @see PullRequestStatusEnum
     */
    public final String pullRequestStatusAsString() {
        return pullRequestStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pullRequestStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PullRequestStatusChangedEventMetadata)) {
            return false;
        }
        PullRequestStatusChangedEventMetadata other = (PullRequestStatusChangedEventMetadata) obj;
        return Objects.equals(pullRequestStatusAsString(), other.pullRequestStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PullRequestStatusChangedEventMetadata").add("PullRequestStatus", pullRequestStatusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pullRequestStatus":
            return Optional.ofNullable(clazz.cast(pullRequestStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PullRequestStatusChangedEventMetadata, T> g) {
        return obj -> g.apply((PullRequestStatusChangedEventMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PullRequestStatusChangedEventMetadata> {
        /**
         * <p>
         * The changed status of the pull request.
         * </p>
         * 
         * @param pullRequestStatus
         *        The changed status of the pull request.
         * @see PullRequestStatusEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PullRequestStatusEnum
         */
        Builder pullRequestStatus(String pullRequestStatus);

        /**
         * <p>
         * The changed status of the pull request.
         * </p>
         * 
         * @param pullRequestStatus
         *        The changed status of the pull request.
         * @see PullRequestStatusEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PullRequestStatusEnum
         */
        Builder pullRequestStatus(PullRequestStatusEnum pullRequestStatus);
    }

    static final class BuilderImpl implements Builder {
        private String pullRequestStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(PullRequestStatusChangedEventMetadata model) {
            pullRequestStatus(model.pullRequestStatus);
        }

        public final String getPullRequestStatus() {
            return pullRequestStatus;
        }

        public final void setPullRequestStatus(String pullRequestStatus) {
            this.pullRequestStatus = pullRequestStatus;
        }

        @Override
        @Transient
        public final Builder pullRequestStatus(String pullRequestStatus) {
            this.pullRequestStatus = pullRequestStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder pullRequestStatus(PullRequestStatusEnum pullRequestStatus) {
            this.pullRequestStatus(pullRequestStatus == null ? null : pullRequestStatus.toString());
            return this;
        }

        @Override
        public PullRequestStatusChangedEventMetadata build() {
            return new PullRequestStatusChangedEventMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
