/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class MergePullRequestByThreeWayRequest extends CodeCommitRequest implements
        ToCopyableBuilder<MergePullRequestByThreeWayRequest.Builder, MergePullRequestByThreeWayRequest> {
    private static final SdkField<String> PULL_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pullRequestId").getter(getter(MergePullRequestByThreeWayRequest::pullRequestId))
            .setter(setter(Builder::pullRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestId").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(MergePullRequestByThreeWayRequest::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> SOURCE_COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceCommitId").getter(getter(MergePullRequestByThreeWayRequest::sourceCommitId))
            .setter(setter(Builder::sourceCommitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCommitId").build()).build();

    private static final SdkField<String> CONFLICT_DETAIL_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("conflictDetailLevel").getter(getter(MergePullRequestByThreeWayRequest::conflictDetailLevelAsString))
            .setter(setter(Builder::conflictDetailLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conflictDetailLevel").build())
            .build();

    private static final SdkField<String> CONFLICT_RESOLUTION_STRATEGY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("conflictResolutionStrategy")
            .getter(getter(MergePullRequestByThreeWayRequest::conflictResolutionStrategyAsString))
            .setter(setter(Builder::conflictResolutionStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conflictResolutionStrategy").build())
            .build();

    private static final SdkField<String> COMMIT_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("commitMessage").getter(getter(MergePullRequestByThreeWayRequest::commitMessage))
            .setter(setter(Builder::commitMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitMessage").build()).build();

    private static final SdkField<String> AUTHOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authorName").getter(getter(MergePullRequestByThreeWayRequest::authorName))
            .setter(setter(Builder::authorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorName").build()).build();

    private static final SdkField<String> EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("email")
            .getter(getter(MergePullRequestByThreeWayRequest::email)).setter(setter(Builder::email))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("email").build()).build();

    private static final SdkField<Boolean> KEEP_EMPTY_FOLDERS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("keepEmptyFolders").getter(getter(MergePullRequestByThreeWayRequest::keepEmptyFolders))
            .setter(setter(Builder::keepEmptyFolders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keepEmptyFolders").build()).build();

    private static final SdkField<ConflictResolution> CONFLICT_RESOLUTION_FIELD = SdkField
            .<ConflictResolution> builder(MarshallingType.SDK_POJO).memberName("conflictResolution")
            .getter(getter(MergePullRequestByThreeWayRequest::conflictResolution)).setter(setter(Builder::conflictResolution))
            .constructor(ConflictResolution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conflictResolution").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PULL_REQUEST_ID_FIELD,
            REPOSITORY_NAME_FIELD, SOURCE_COMMIT_ID_FIELD, CONFLICT_DETAIL_LEVEL_FIELD, CONFLICT_RESOLUTION_STRATEGY_FIELD,
            COMMIT_MESSAGE_FIELD, AUTHOR_NAME_FIELD, EMAIL_FIELD, KEEP_EMPTY_FOLDERS_FIELD, CONFLICT_RESOLUTION_FIELD));

    private final String pullRequestId;

    private final String repositoryName;

    private final String sourceCommitId;

    private final String conflictDetailLevel;

    private final String conflictResolutionStrategy;

    private final String commitMessage;

    private final String authorName;

    private final String email;

    private final Boolean keepEmptyFolders;

    private final ConflictResolution conflictResolution;

    private MergePullRequestByThreeWayRequest(BuilderImpl builder) {
        super(builder);
        this.pullRequestId = builder.pullRequestId;
        this.repositoryName = builder.repositoryName;
        this.sourceCommitId = builder.sourceCommitId;
        this.conflictDetailLevel = builder.conflictDetailLevel;
        this.conflictResolutionStrategy = builder.conflictResolutionStrategy;
        this.commitMessage = builder.commitMessage;
        this.authorName = builder.authorName;
        this.email = builder.email;
        this.keepEmptyFolders = builder.keepEmptyFolders;
        this.conflictResolution = builder.conflictResolution;
    }

    /**
     * <p>
     * The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.
     * </p>
     * 
     * @return The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.
     */
    public final String pullRequestId() {
        return pullRequestId;
    }

    /**
     * <p>
     * The name of the repository where the pull request was created.
     * </p>
     * 
     * @return The name of the repository where the pull request was created.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The full commit ID of the original or updated commit in the pull request source branch. Pass this value if you
     * want an exception thrown if the current commit ID of the tip of the source branch does not match this commit ID.
     * </p>
     * 
     * @return The full commit ID of the original or updated commit in the pull request source branch. Pass this value
     *         if you want an exception thrown if the current commit ID of the tip of the source branch does not match
     *         this commit ID.
     */
    public final String sourceCommitId() {
        return sourceCommitId;
    }

    /**
     * <p>
     * The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a
     * not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is
     * considered not mergeable if the same file in both branches has differences on the same line.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #conflictDetailLevel} will return {@link ConflictDetailLevelTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #conflictDetailLevelAsString}.
     * </p>
     * 
     * @return The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a
     *         not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a
     *         conflict is considered not mergeable if the same file in both branches has differences on the same line.
     * @see ConflictDetailLevelTypeEnum
     */
    public final ConflictDetailLevelTypeEnum conflictDetailLevel() {
        return ConflictDetailLevelTypeEnum.fromValue(conflictDetailLevel);
    }

    /**
     * <p>
     * The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a
     * not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is
     * considered not mergeable if the same file in both branches has differences on the same line.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #conflictDetailLevel} will return {@link ConflictDetailLevelTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #conflictDetailLevelAsString}.
     * </p>
     * 
     * @return The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a
     *         not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a
     *         conflict is considered not mergeable if the same file in both branches has differences on the same line.
     * @see ConflictDetailLevelTypeEnum
     */
    public final String conflictDetailLevelAsString() {
        return conflictDetailLevel;
    }

    /**
     * <p>
     * Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions
     * of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation
     * is successful.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #conflictResolutionStrategy} will return {@link ConflictResolutionStrategyTypeEnum#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #conflictResolutionStrategyAsString}.
     * </p>
     * 
     * @return Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two
     *         versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the
     *         merge operation is successful.
     * @see ConflictResolutionStrategyTypeEnum
     */
    public final ConflictResolutionStrategyTypeEnum conflictResolutionStrategy() {
        return ConflictResolutionStrategyTypeEnum.fromValue(conflictResolutionStrategy);
    }

    /**
     * <p>
     * Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions
     * of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation
     * is successful.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #conflictResolutionStrategy} will return {@link ConflictResolutionStrategyTypeEnum#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #conflictResolutionStrategyAsString}.
     * </p>
     * 
     * @return Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two
     *         versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the
     *         merge operation is successful.
     * @see ConflictResolutionStrategyTypeEnum
     */
    public final String conflictResolutionStrategyAsString() {
        return conflictResolutionStrategy;
    }

    /**
     * <p>
     * The commit message to include in the commit information for the merge.
     * </p>
     * 
     * @return The commit message to include in the commit information for the merge.
     */
    public final String commitMessage() {
        return commitMessage;
    }

    /**
     * <p>
     * The name of the author who created the commit. This information is used as both the author and committer for the
     * commit.
     * </p>
     * 
     * @return The name of the author who created the commit. This information is used as both the author and committer
     *         for the commit.
     */
    public final String authorName() {
        return authorName;
    }

    /**
     * <p>
     * The email address of the person merging the branches. This information is used in the commit information for the
     * merge.
     * </p>
     * 
     * @return The email address of the person merging the branches. This information is used in the commit information
     *         for the merge.
     */
    public final String email() {
        return email;
    }

    /**
     * <p>
     * If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders
     * empty. If true, a .gitkeep file is created for empty folders. The default is false.
     * </p>
     * 
     * @return If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the
     *         folders empty. If true, a .gitkeep file is created for empty folders. The default is false.
     */
    public final Boolean keepEmptyFolders() {
        return keepEmptyFolders;
    }

    /**
     * <p>
     * If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a
     * merge.
     * </p>
     * 
     * @return If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during
     *         a merge.
     */
    public final ConflictResolution conflictResolution() {
        return conflictResolution;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pullRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(conflictDetailLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(conflictResolutionStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(commitMessage());
        hashCode = 31 * hashCode + Objects.hashCode(authorName());
        hashCode = 31 * hashCode + Objects.hashCode(email());
        hashCode = 31 * hashCode + Objects.hashCode(keepEmptyFolders());
        hashCode = 31 * hashCode + Objects.hashCode(conflictResolution());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MergePullRequestByThreeWayRequest)) {
            return false;
        }
        MergePullRequestByThreeWayRequest other = (MergePullRequestByThreeWayRequest) obj;
        return Objects.equals(pullRequestId(), other.pullRequestId()) && Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(sourceCommitId(), other.sourceCommitId())
                && Objects.equals(conflictDetailLevelAsString(), other.conflictDetailLevelAsString())
                && Objects.equals(conflictResolutionStrategyAsString(), other.conflictResolutionStrategyAsString())
                && Objects.equals(commitMessage(), other.commitMessage()) && Objects.equals(authorName(), other.authorName())
                && Objects.equals(email(), other.email()) && Objects.equals(keepEmptyFolders(), other.keepEmptyFolders())
                && Objects.equals(conflictResolution(), other.conflictResolution());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MergePullRequestByThreeWayRequest").add("PullRequestId", pullRequestId())
                .add("RepositoryName", repositoryName()).add("SourceCommitId", sourceCommitId())
                .add("ConflictDetailLevel", conflictDetailLevelAsString())
                .add("ConflictResolutionStrategy", conflictResolutionStrategyAsString()).add("CommitMessage", commitMessage())
                .add("AuthorName", authorName()).add("Email", email()).add("KeepEmptyFolders", keepEmptyFolders())
                .add("ConflictResolution", conflictResolution()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pullRequestId":
            return Optional.ofNullable(clazz.cast(pullRequestId()));
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "sourceCommitId":
            return Optional.ofNullable(clazz.cast(sourceCommitId()));
        case "conflictDetailLevel":
            return Optional.ofNullable(clazz.cast(conflictDetailLevelAsString()));
        case "conflictResolutionStrategy":
            return Optional.ofNullable(clazz.cast(conflictResolutionStrategyAsString()));
        case "commitMessage":
            return Optional.ofNullable(clazz.cast(commitMessage()));
        case "authorName":
            return Optional.ofNullable(clazz.cast(authorName()));
        case "email":
            return Optional.ofNullable(clazz.cast(email()));
        case "keepEmptyFolders":
            return Optional.ofNullable(clazz.cast(keepEmptyFolders()));
        case "conflictResolution":
            return Optional.ofNullable(clazz.cast(conflictResolution()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MergePullRequestByThreeWayRequest, T> g) {
        return obj -> g.apply((MergePullRequestByThreeWayRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, MergePullRequestByThreeWayRequest> {
        /**
         * <p>
         * The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.
         * </p>
         * 
         * @param pullRequestId
         *        The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pullRequestId(String pullRequestId);

        /**
         * <p>
         * The name of the repository where the pull request was created.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository where the pull request was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The full commit ID of the original or updated commit in the pull request source branch. Pass this value if
         * you want an exception thrown if the current commit ID of the tip of the source branch does not match this
         * commit ID.
         * </p>
         * 
         * @param sourceCommitId
         *        The full commit ID of the original or updated commit in the pull request source branch. Pass this
         *        value if you want an exception thrown if the current commit ID of the tip of the source branch does
         *        not match this commit ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCommitId(String sourceCommitId);

        /**
         * <p>
         * The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a
         * not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a
         * conflict is considered not mergeable if the same file in both branches has differences on the same line.
         * </p>
         * 
         * @param conflictDetailLevel
         *        The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a
         *        not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a
         *        conflict is considered not mergeable if the same file in both branches has differences on the same
         *        line.
         * @see ConflictDetailLevelTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConflictDetailLevelTypeEnum
         */
        Builder conflictDetailLevel(String conflictDetailLevel);

        /**
         * <p>
         * The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a
         * not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a
         * conflict is considered not mergeable if the same file in both branches has differences on the same line.
         * </p>
         * 
         * @param conflictDetailLevel
         *        The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a
         *        not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a
         *        conflict is considered not mergeable if the same file in both branches has differences on the same
         *        line.
         * @see ConflictDetailLevelTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConflictDetailLevelTypeEnum
         */
        Builder conflictDetailLevel(ConflictDetailLevelTypeEnum conflictDetailLevel);

        /**
         * <p>
         * Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two
         * versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the
         * merge operation is successful.
         * </p>
         * 
         * @param conflictResolutionStrategy
         *        Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging
         *        two versions of a file. The default is NONE, which requires any conflicts to be resolved manually
         *        before the merge operation is successful.
         * @see ConflictResolutionStrategyTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConflictResolutionStrategyTypeEnum
         */
        Builder conflictResolutionStrategy(String conflictResolutionStrategy);

        /**
         * <p>
         * Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two
         * versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the
         * merge operation is successful.
         * </p>
         * 
         * @param conflictResolutionStrategy
         *        Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging
         *        two versions of a file. The default is NONE, which requires any conflicts to be resolved manually
         *        before the merge operation is successful.
         * @see ConflictResolutionStrategyTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConflictResolutionStrategyTypeEnum
         */
        Builder conflictResolutionStrategy(ConflictResolutionStrategyTypeEnum conflictResolutionStrategy);

        /**
         * <p>
         * The commit message to include in the commit information for the merge.
         * </p>
         * 
         * @param commitMessage
         *        The commit message to include in the commit information for the merge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitMessage(String commitMessage);

        /**
         * <p>
         * The name of the author who created the commit. This information is used as both the author and committer for
         * the commit.
         * </p>
         * 
         * @param authorName
         *        The name of the author who created the commit. This information is used as both the author and
         *        committer for the commit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorName(String authorName);

        /**
         * <p>
         * The email address of the person merging the branches. This information is used in the commit information for
         * the merge.
         * </p>
         * 
         * @param email
         *        The email address of the person merging the branches. This information is used in the commit
         *        information for the merge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(String email);

        /**
         * <p>
         * If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the
         * folders empty. If true, a .gitkeep file is created for empty folders. The default is false.
         * </p>
         * 
         * @param keepEmptyFolders
         *        If the commit contains deletions, whether to keep a folder or folder structure if the changes leave
         *        the folders empty. If true, a .gitkeep file is created for empty folders. The default is false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keepEmptyFolders(Boolean keepEmptyFolders);

        /**
         * <p>
         * If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a
         * merge.
         * </p>
         * 
         * @param conflictResolution
         *        If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts
         *        during a merge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conflictResolution(ConflictResolution conflictResolution);

        /**
         * <p>
         * If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a
         * merge.
         * </p>
         * This is a convenience that creates an instance of the {@link ConflictResolution.Builder} avoiding the need to
         * create one manually via {@link ConflictResolution#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConflictResolution.Builder#build()} is called immediately and its
         * result is passed to {@link #conflictResolution(ConflictResolution)}.
         * 
         * @param conflictResolution
         *        a consumer that will call methods on {@link ConflictResolution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conflictResolution(ConflictResolution)
         */
        default Builder conflictResolution(Consumer<ConflictResolution.Builder> conflictResolution) {
            return conflictResolution(ConflictResolution.builder().applyMutation(conflictResolution).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeCommitRequest.BuilderImpl implements Builder {
        private String pullRequestId;

        private String repositoryName;

        private String sourceCommitId;

        private String conflictDetailLevel;

        private String conflictResolutionStrategy;

        private String commitMessage;

        private String authorName;

        private String email;

        private Boolean keepEmptyFolders;

        private ConflictResolution conflictResolution;

        private BuilderImpl() {
        }

        private BuilderImpl(MergePullRequestByThreeWayRequest model) {
            super(model);
            pullRequestId(model.pullRequestId);
            repositoryName(model.repositoryName);
            sourceCommitId(model.sourceCommitId);
            conflictDetailLevel(model.conflictDetailLevel);
            conflictResolutionStrategy(model.conflictResolutionStrategy);
            commitMessage(model.commitMessage);
            authorName(model.authorName);
            email(model.email);
            keepEmptyFolders(model.keepEmptyFolders);
            conflictResolution(model.conflictResolution);
        }

        public final String getPullRequestId() {
            return pullRequestId;
        }

        public final void setPullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
        }

        @Override
        @Transient
        public final Builder pullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
            return this;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        @Transient
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getSourceCommitId() {
            return sourceCommitId;
        }

        public final void setSourceCommitId(String sourceCommitId) {
            this.sourceCommitId = sourceCommitId;
        }

        @Override
        @Transient
        public final Builder sourceCommitId(String sourceCommitId) {
            this.sourceCommitId = sourceCommitId;
            return this;
        }

        public final String getConflictDetailLevel() {
            return conflictDetailLevel;
        }

        public final void setConflictDetailLevel(String conflictDetailLevel) {
            this.conflictDetailLevel = conflictDetailLevel;
        }

        @Override
        @Transient
        public final Builder conflictDetailLevel(String conflictDetailLevel) {
            this.conflictDetailLevel = conflictDetailLevel;
            return this;
        }

        @Override
        @Transient
        public final Builder conflictDetailLevel(ConflictDetailLevelTypeEnum conflictDetailLevel) {
            this.conflictDetailLevel(conflictDetailLevel == null ? null : conflictDetailLevel.toString());
            return this;
        }

        public final String getConflictResolutionStrategy() {
            return conflictResolutionStrategy;
        }

        public final void setConflictResolutionStrategy(String conflictResolutionStrategy) {
            this.conflictResolutionStrategy = conflictResolutionStrategy;
        }

        @Override
        @Transient
        public final Builder conflictResolutionStrategy(String conflictResolutionStrategy) {
            this.conflictResolutionStrategy = conflictResolutionStrategy;
            return this;
        }

        @Override
        @Transient
        public final Builder conflictResolutionStrategy(ConflictResolutionStrategyTypeEnum conflictResolutionStrategy) {
            this.conflictResolutionStrategy(conflictResolutionStrategy == null ? null : conflictResolutionStrategy.toString());
            return this;
        }

        public final String getCommitMessage() {
            return commitMessage;
        }

        public final void setCommitMessage(String commitMessage) {
            this.commitMessage = commitMessage;
        }

        @Override
        @Transient
        public final Builder commitMessage(String commitMessage) {
            this.commitMessage = commitMessage;
            return this;
        }

        public final String getAuthorName() {
            return authorName;
        }

        public final void setAuthorName(String authorName) {
            this.authorName = authorName;
        }

        @Override
        @Transient
        public final Builder authorName(String authorName) {
            this.authorName = authorName;
            return this;
        }

        public final String getEmail() {
            return email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        @Transient
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final Boolean getKeepEmptyFolders() {
            return keepEmptyFolders;
        }

        public final void setKeepEmptyFolders(Boolean keepEmptyFolders) {
            this.keepEmptyFolders = keepEmptyFolders;
        }

        @Override
        @Transient
        public final Builder keepEmptyFolders(Boolean keepEmptyFolders) {
            this.keepEmptyFolders = keepEmptyFolders;
            return this;
        }

        public final ConflictResolution.Builder getConflictResolution() {
            return conflictResolution != null ? conflictResolution.toBuilder() : null;
        }

        public final void setConflictResolution(ConflictResolution.BuilderImpl conflictResolution) {
            this.conflictResolution = conflictResolution != null ? conflictResolution.build() : null;
        }

        @Override
        @Transient
        public final Builder conflictResolution(ConflictResolution conflictResolution) {
            this.conflictResolution = conflictResolution;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public MergePullRequestByThreeWayRequest build() {
            return new MergePullRequestByThreeWayRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
