/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a trigger for a repository.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RepositoryTrigger implements SdkPojo, Serializable,
        ToCopyableBuilder<RepositoryTrigger.Builder, RepositoryTrigger> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(RepositoryTrigger::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESTINATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationArn").getter(getter(RepositoryTrigger::destinationArn))
            .setter(setter(Builder::destinationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationArn").build()).build();

    private static final SdkField<String> CUSTOM_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customData").getter(getter(RepositoryTrigger::customData)).setter(setter(Builder::customData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customData").build()).build();

    private static final SdkField<List<String>> BRANCHES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("branches")
            .getter(getter(RepositoryTrigger::branches))
            .setter(setter(Builder::branches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branches").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EVENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("events")
            .getter(getter(RepositoryTrigger::eventsAsStrings))
            .setter(setter(Builder::eventsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("events").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            DESTINATION_ARN_FIELD, CUSTOM_DATA_FIELD, BRANCHES_FIELD, EVENTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String destinationArn;

    private final String customData;

    private final List<String> branches;

    private final List<String> events;

    private RepositoryTrigger(BuilderImpl builder) {
        this.name = builder.name;
        this.destinationArn = builder.destinationArn;
        this.customData = builder.customData;
        this.branches = builder.branches;
        this.events = builder.events;
    }

    /**
     * <p>
     * The name of the trigger.
     * </p>
     * 
     * @return The name of the trigger.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ARN of the resource that is the target for a trigger (for example, the ARN of a topic in Amazon SNS).
     * </p>
     * 
     * @return The ARN of the resource that is the target for a trigger (for example, the ARN of a topic in Amazon SNS).
     */
    public final String destinationArn() {
        return destinationArn;
    }

    /**
     * <p>
     * Any custom data associated with the trigger to be included in the information sent to the target of the trigger.
     * </p>
     * 
     * @return Any custom data associated with the trigger to be included in the information sent to the target of the
     *         trigger.
     */
    public final String customData() {
        return customData;
    }

    /**
     * For responses, this returns true if the service returned a value for the Branches property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBranches() {
        return branches != null && !(branches instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The branches to be included in the trigger configuration. If you specify an empty array, the trigger applies to
     * all branches.
     * </p>
     * <note>
     * <p>
     * Although no content is required in the array, you must include the array itself.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBranches} method.
     * </p>
     * 
     * @return The branches to be included in the trigger configuration. If you specify an empty array, the trigger
     *         applies to all branches.</p> <note>
     *         <p>
     *         Although no content is required in the array, you must include the array itself.
     *         </p>
     */
    public final List<String> branches() {
        return branches;
    }

    /**
     * <p>
     * The repository events that cause the trigger to run actions in another service, such as sending a notification
     * through Amazon SNS.
     * </p>
     * <note>
     * <p>
     * The valid value "all" cannot be used with any other values.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvents} method.
     * </p>
     * 
     * @return The repository events that cause the trigger to run actions in another service, such as sending a
     *         notification through Amazon SNS. </p> <note>
     *         <p>
     *         The valid value "all" cannot be used with any other values.
     *         </p>
     */
    public final List<RepositoryTriggerEventEnum> events() {
        return RepositoryTriggerEventListCopier.copyStringToEnum(events);
    }

    /**
     * For responses, this returns true if the service returned a value for the Events property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEvents() {
        return events != null && !(events instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The repository events that cause the trigger to run actions in another service, such as sending a notification
     * through Amazon SNS.
     * </p>
     * <note>
     * <p>
     * The valid value "all" cannot be used with any other values.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvents} method.
     * </p>
     * 
     * @return The repository events that cause the trigger to run actions in another service, such as sending a
     *         notification through Amazon SNS. </p> <note>
     *         <p>
     *         The valid value "all" cannot be used with any other values.
     *         </p>
     */
    public final List<String> eventsAsStrings() {
        return events;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(destinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(customData());
        hashCode = 31 * hashCode + Objects.hashCode(hasBranches() ? branches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEvents() ? eventsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositoryTrigger)) {
            return false;
        }
        RepositoryTrigger other = (RepositoryTrigger) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(destinationArn(), other.destinationArn())
                && Objects.equals(customData(), other.customData()) && hasBranches() == other.hasBranches()
                && Objects.equals(branches(), other.branches()) && hasEvents() == other.hasEvents()
                && Objects.equals(eventsAsStrings(), other.eventsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RepositoryTrigger").add("Name", name()).add("DestinationArn", destinationArn())
                .add("CustomData", customData()).add("Branches", hasBranches() ? branches() : null)
                .add("Events", hasEvents() ? eventsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "destinationArn":
            return Optional.ofNullable(clazz.cast(destinationArn()));
        case "customData":
            return Optional.ofNullable(clazz.cast(customData()));
        case "branches":
            return Optional.ofNullable(clazz.cast(branches()));
        case "events":
            return Optional.ofNullable(clazz.cast(eventsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RepositoryTrigger, T> g) {
        return obj -> g.apply((RepositoryTrigger) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RepositoryTrigger> {
        /**
         * <p>
         * The name of the trigger.
         * </p>
         * 
         * @param name
         *        The name of the trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ARN of the resource that is the target for a trigger (for example, the ARN of a topic in Amazon SNS).
         * </p>
         * 
         * @param destinationArn
         *        The ARN of the resource that is the target for a trigger (for example, the ARN of a topic in Amazon
         *        SNS).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationArn(String destinationArn);

        /**
         * <p>
         * Any custom data associated with the trigger to be included in the information sent to the target of the
         * trigger.
         * </p>
         * 
         * @param customData
         *        Any custom data associated with the trigger to be included in the information sent to the target of
         *        the trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customData(String customData);

        /**
         * <p>
         * The branches to be included in the trigger configuration. If you specify an empty array, the trigger applies
         * to all branches.
         * </p>
         * <note>
         * <p>
         * Although no content is required in the array, you must include the array itself.
         * </p>
         * </note>
         * 
         * @param branches
         *        The branches to be included in the trigger configuration. If you specify an empty array, the trigger
         *        applies to all branches.</p> <note>
         *        <p>
         *        Although no content is required in the array, you must include the array itself.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branches(Collection<String> branches);

        /**
         * <p>
         * The branches to be included in the trigger configuration. If you specify an empty array, the trigger applies
         * to all branches.
         * </p>
         * <note>
         * <p>
         * Although no content is required in the array, you must include the array itself.
         * </p>
         * </note>
         * 
         * @param branches
         *        The branches to be included in the trigger configuration. If you specify an empty array, the trigger
         *        applies to all branches.</p> <note>
         *        <p>
         *        Although no content is required in the array, you must include the array itself.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branches(String... branches);

        /**
         * <p>
         * The repository events that cause the trigger to run actions in another service, such as sending a
         * notification through Amazon SNS.
         * </p>
         * <note>
         * <p>
         * The valid value "all" cannot be used with any other values.
         * </p>
         * </note>
         * 
         * @param events
         *        The repository events that cause the trigger to run actions in another service, such as sending a
         *        notification through Amazon SNS. </p> <note>
         *        <p>
         *        The valid value "all" cannot be used with any other values.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventsWithStrings(Collection<String> events);

        /**
         * <p>
         * The repository events that cause the trigger to run actions in another service, such as sending a
         * notification through Amazon SNS.
         * </p>
         * <note>
         * <p>
         * The valid value "all" cannot be used with any other values.
         * </p>
         * </note>
         * 
         * @param events
         *        The repository events that cause the trigger to run actions in another service, such as sending a
         *        notification through Amazon SNS. </p> <note>
         *        <p>
         *        The valid value "all" cannot be used with any other values.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventsWithStrings(String... events);

        /**
         * <p>
         * The repository events that cause the trigger to run actions in another service, such as sending a
         * notification through Amazon SNS.
         * </p>
         * <note>
         * <p>
         * The valid value "all" cannot be used with any other values.
         * </p>
         * </note>
         * 
         * @param events
         *        The repository events that cause the trigger to run actions in another service, such as sending a
         *        notification through Amazon SNS. </p> <note>
         *        <p>
         *        The valid value "all" cannot be used with any other values.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Collection<RepositoryTriggerEventEnum> events);

        /**
         * <p>
         * The repository events that cause the trigger to run actions in another service, such as sending a
         * notification through Amazon SNS.
         * </p>
         * <note>
         * <p>
         * The valid value "all" cannot be used with any other values.
         * </p>
         * </note>
         * 
         * @param events
         *        The repository events that cause the trigger to run actions in another service, such as sending a
         *        notification through Amazon SNS. </p> <note>
         *        <p>
         *        The valid value "all" cannot be used with any other values.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(RepositoryTriggerEventEnum... events);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String destinationArn;

        private String customData;

        private List<String> branches = DefaultSdkAutoConstructList.getInstance();

        private List<String> events = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RepositoryTrigger model) {
            name(model.name);
            destinationArn(model.destinationArn);
            customData(model.customData);
            branches(model.branches);
            eventsWithStrings(model.events);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDestinationArn() {
            return destinationArn;
        }

        public final void setDestinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
        }

        @Override
        @Transient
        public final Builder destinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
            return this;
        }

        public final String getCustomData() {
            return customData;
        }

        public final void setCustomData(String customData) {
            this.customData = customData;
        }

        @Override
        @Transient
        public final Builder customData(String customData) {
            this.customData = customData;
            return this;
        }

        public final Collection<String> getBranches() {
            if (branches instanceof SdkAutoConstructList) {
                return null;
            }
            return branches;
        }

        public final void setBranches(Collection<String> branches) {
            this.branches = BranchNameListCopier.copy(branches);
        }

        @Override
        @Transient
        public final Builder branches(Collection<String> branches) {
            this.branches = BranchNameListCopier.copy(branches);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder branches(String... branches) {
            branches(Arrays.asList(branches));
            return this;
        }

        public final Collection<String> getEvents() {
            if (events instanceof SdkAutoConstructList) {
                return null;
            }
            return events;
        }

        public final void setEvents(Collection<String> events) {
            this.events = RepositoryTriggerEventListCopier.copy(events);
        }

        @Override
        @Transient
        public final Builder eventsWithStrings(Collection<String> events) {
            this.events = RepositoryTriggerEventListCopier.copy(events);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder eventsWithStrings(String... events) {
            eventsWithStrings(Arrays.asList(events));
            return this;
        }

        @Override
        @Transient
        public final Builder events(Collection<RepositoryTriggerEventEnum> events) {
            this.events = RepositoryTriggerEventListCopier.copyEnumToString(events);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder events(RepositoryTriggerEventEnum... events) {
            events(Arrays.asList(events));
            return this;
        }

        @Override
        public RepositoryTrigger build() {
            return new RepositoryTrigger(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
