/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codecommit.model.BranchNameListCopier;
import software.amazon.awssdk.services.codecommit.model.RepositoryTriggerEventEnum;
import software.amazon.awssdk.services.codecommit.model.RepositoryTriggerEventListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RepositoryTrigger
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RepositoryTrigger> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(RepositoryTrigger.getter(RepositoryTrigger::name)).setter(RepositoryTrigger.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESTINATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationArn").getter(RepositoryTrigger.getter(RepositoryTrigger::destinationArn)).setter(RepositoryTrigger.setter(Builder::destinationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationArn").build()}).build();
    private static final SdkField<String> CUSTOM_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customData").getter(RepositoryTrigger.getter(RepositoryTrigger::customData)).setter(RepositoryTrigger.setter(Builder::customData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customData").build()}).build();
    private static final SdkField<List<String>> BRANCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("branches").getter(RepositoryTrigger.getter(RepositoryTrigger::branches)).setter(RepositoryTrigger.setter(Builder::branches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branches").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("events").getter(RepositoryTrigger.getter(RepositoryTrigger::eventsAsStrings)).setter(RepositoryTrigger.setter(Builder::eventsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("events").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESTINATION_ARN_FIELD, CUSTOM_DATA_FIELD, BRANCHES_FIELD, EVENTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String destinationArn;
    private final String customData;
    private final List<String> branches;
    private final List<String> events;

    private RepositoryTrigger(BuilderImpl builder) {
        this.name = builder.name;
        this.destinationArn = builder.destinationArn;
        this.customData = builder.customData;
        this.branches = builder.branches;
        this.events = builder.events;
    }

    public final String name() {
        return this.name;
    }

    public final String destinationArn() {
        return this.destinationArn;
    }

    public final String customData() {
        return this.customData;
    }

    public final boolean hasBranches() {
        return this.branches != null && !(this.branches instanceof SdkAutoConstructList);
    }

    public final List<String> branches() {
        return this.branches;
    }

    public final List<RepositoryTriggerEventEnum> events() {
        return RepositoryTriggerEventListCopier.copyStringToEnum(this.events);
    }

    public final boolean hasEvents() {
        return this.events != null && !(this.events instanceof SdkAutoConstructList);
    }

    public final List<String> eventsAsStrings() {
        return this.events;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.customData());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBranches() ? this.branches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvents() ? this.eventsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositoryTrigger)) {
            return false;
        }
        RepositoryTrigger other = (RepositoryTrigger)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.destinationArn(), other.destinationArn()) && Objects.equals(this.customData(), other.customData()) && this.hasBranches() == other.hasBranches() && Objects.equals(this.branches(), other.branches()) && this.hasEvents() == other.hasEvents() && Objects.equals(this.eventsAsStrings(), other.eventsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"RepositoryTrigger").add("Name", (Object)this.name()).add("DestinationArn", (Object)this.destinationArn()).add("CustomData", (Object)this.customData()).add("Branches", this.hasBranches() ? this.branches() : null).add("Events", this.hasEvents() ? this.eventsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "destinationArn": {
                return Optional.ofNullable(clazz.cast(this.destinationArn()));
            }
            case "customData": {
                return Optional.ofNullable(clazz.cast(this.customData()));
            }
            case "branches": {
                return Optional.ofNullable(clazz.cast(this.branches()));
            }
            case "events": {
                return Optional.ofNullable(clazz.cast(this.eventsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RepositoryTrigger, T> g) {
        return obj -> g.apply((RepositoryTrigger)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String destinationArn;
        private String customData;
        private List<String> branches = DefaultSdkAutoConstructList.getInstance();
        private List<String> events = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RepositoryTrigger model) {
            this.name(model.name);
            this.destinationArn(model.destinationArn);
            this.customData(model.customData);
            this.branches(model.branches);
            this.eventsWithStrings(model.events);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDestinationArn() {
            return this.destinationArn;
        }

        public final void setDestinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
        }

        @Override
        @Transient
        public final Builder destinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
            return this;
        }

        public final String getCustomData() {
            return this.customData;
        }

        public final void setCustomData(String customData) {
            this.customData = customData;
        }

        @Override
        @Transient
        public final Builder customData(String customData) {
            this.customData = customData;
            return this;
        }

        public final Collection<String> getBranches() {
            if (this.branches instanceof SdkAutoConstructList) {
                return null;
            }
            return this.branches;
        }

        public final void setBranches(Collection<String> branches) {
            this.branches = BranchNameListCopier.copy(branches);
        }

        @Override
        @Transient
        public final Builder branches(Collection<String> branches) {
            this.branches = BranchNameListCopier.copy(branches);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder branches(String ... branches) {
            this.branches(Arrays.asList(branches));
            return this;
        }

        public final Collection<String> getEvents() {
            if (this.events instanceof SdkAutoConstructList) {
                return null;
            }
            return this.events;
        }

        public final void setEvents(Collection<String> events) {
            this.events = RepositoryTriggerEventListCopier.copy(events);
        }

        @Override
        @Transient
        public final Builder eventsWithStrings(Collection<String> events) {
            this.events = RepositoryTriggerEventListCopier.copy(events);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder eventsWithStrings(String ... events) {
            this.eventsWithStrings(Arrays.asList(events));
            return this;
        }

        @Override
        @Transient
        public final Builder events(Collection<RepositoryTriggerEventEnum> events) {
            this.events = RepositoryTriggerEventListCopier.copyEnumToString(events);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder events(RepositoryTriggerEventEnum ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        public RepositoryTrigger build() {
            return new RepositoryTrigger(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RepositoryTrigger> {
        public Builder name(String var1);

        public Builder destinationArn(String var1);

        public Builder customData(String var1);

        public Builder branches(Collection<String> var1);

        public Builder branches(String ... var1);

        public Builder eventsWithStrings(Collection<String> var1);

        public Builder eventsWithStrings(String ... var1);

        public Builder events(Collection<RepositoryTriggerEventEnum> var1);

        public Builder events(RepositoryTriggerEventEnum ... var1);
    }
}

