/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information about errors in a BatchDescribeMergeConflicts operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDescribeMergeConflictsError implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchDescribeMergeConflictsError.Builder, BatchDescribeMergeConflictsError> {
    private static final SdkField<String> FILE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filePath").getter(getter(BatchDescribeMergeConflictsError::filePath)).setter(setter(Builder::filePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePath").build()).build();

    private static final SdkField<String> EXCEPTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("exceptionName").getter(getter(BatchDescribeMergeConflictsError::exceptionName))
            .setter(setter(Builder::exceptionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exceptionName").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(BatchDescribeMergeConflictsError::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_PATH_FIELD,
            EXCEPTION_NAME_FIELD, MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String filePath;

    private final String exceptionName;

    private final String message;

    private BatchDescribeMergeConflictsError(BuilderImpl builder) {
        this.filePath = builder.filePath;
        this.exceptionName = builder.exceptionName;
        this.message = builder.message;
    }

    /**
     * <p>
     * The path to the file.
     * </p>
     * 
     * @return The path to the file.
     */
    public final String filePath() {
        return filePath;
    }

    /**
     * <p>
     * The name of the exception.
     * </p>
     * 
     * @return The name of the exception.
     */
    public final String exceptionName() {
        return exceptionName;
    }

    /**
     * <p>
     * The message provided by the exception.
     * </p>
     * 
     * @return The message provided by the exception.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filePath());
        hashCode = 31 * hashCode + Objects.hashCode(exceptionName());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDescribeMergeConflictsError)) {
            return false;
        }
        BatchDescribeMergeConflictsError other = (BatchDescribeMergeConflictsError) obj;
        return Objects.equals(filePath(), other.filePath()) && Objects.equals(exceptionName(), other.exceptionName())
                && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDescribeMergeConflictsError").add("FilePath", filePath())
                .add("ExceptionName", exceptionName()).add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filePath":
            return Optional.ofNullable(clazz.cast(filePath()));
        case "exceptionName":
            return Optional.ofNullable(clazz.cast(exceptionName()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDescribeMergeConflictsError, T> g) {
        return obj -> g.apply((BatchDescribeMergeConflictsError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchDescribeMergeConflictsError> {
        /**
         * <p>
         * The path to the file.
         * </p>
         * 
         * @param filePath
         *        The path to the file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filePath(String filePath);

        /**
         * <p>
         * The name of the exception.
         * </p>
         * 
         * @param exceptionName
         *        The name of the exception.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exceptionName(String exceptionName);

        /**
         * <p>
         * The message provided by the exception.
         * </p>
         * 
         * @param message
         *        The message provided by the exception.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String filePath;

        private String exceptionName;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDescribeMergeConflictsError model) {
            filePath(model.filePath);
            exceptionName(model.exceptionName);
            message(model.message);
        }

        public final String getFilePath() {
            return filePath;
        }

        public final void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        @Override
        @Transient
        public final Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public final String getExceptionName() {
            return exceptionName;
        }

        public final void setExceptionName(String exceptionName) {
            this.exceptionName = exceptionName;
        }

        @Override
        @Transient
        public final Builder exceptionName(String exceptionName) {
            this.exceptionName = exceptionName;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        @Transient
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BatchDescribeMergeConflictsError build() {
            return new BatchDescribeMergeConflictsError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
