/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class MergePullRequestByFastForwardRequest extends CodeCommitRequest implements
        ToCopyableBuilder<MergePullRequestByFastForwardRequest.Builder, MergePullRequestByFastForwardRequest> {
    private static final SdkField<String> PULL_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pullRequestId").getter(getter(MergePullRequestByFastForwardRequest::pullRequestId))
            .setter(setter(Builder::pullRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestId").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(MergePullRequestByFastForwardRequest::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> SOURCE_COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceCommitId").getter(getter(MergePullRequestByFastForwardRequest::sourceCommitId))
            .setter(setter(Builder::sourceCommitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCommitId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PULL_REQUEST_ID_FIELD,
            REPOSITORY_NAME_FIELD, SOURCE_COMMIT_ID_FIELD));

    private final String pullRequestId;

    private final String repositoryName;

    private final String sourceCommitId;

    private MergePullRequestByFastForwardRequest(BuilderImpl builder) {
        super(builder);
        this.pullRequestId = builder.pullRequestId;
        this.repositoryName = builder.repositoryName;
        this.sourceCommitId = builder.sourceCommitId;
    }

    /**
     * <p>
     * The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.
     * </p>
     * 
     * @return The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.
     */
    public final String pullRequestId() {
        return pullRequestId;
    }

    /**
     * <p>
     * The name of the repository where the pull request was created.
     * </p>
     * 
     * @return The name of the repository where the pull request was created.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The full commit ID of the original or updated commit in the pull request source branch. Pass this value if you
     * want an exception thrown if the current commit ID of the tip of the source branch does not match this commit ID.
     * </p>
     * 
     * @return The full commit ID of the original or updated commit in the pull request source branch. Pass this value
     *         if you want an exception thrown if the current commit ID of the tip of the source branch does not match
     *         this commit ID.
     */
    public final String sourceCommitId() {
        return sourceCommitId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pullRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceCommitId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MergePullRequestByFastForwardRequest)) {
            return false;
        }
        MergePullRequestByFastForwardRequest other = (MergePullRequestByFastForwardRequest) obj;
        return Objects.equals(pullRequestId(), other.pullRequestId()) && Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(sourceCommitId(), other.sourceCommitId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MergePullRequestByFastForwardRequest").add("PullRequestId", pullRequestId())
                .add("RepositoryName", repositoryName()).add("SourceCommitId", sourceCommitId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pullRequestId":
            return Optional.ofNullable(clazz.cast(pullRequestId()));
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "sourceCommitId":
            return Optional.ofNullable(clazz.cast(sourceCommitId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MergePullRequestByFastForwardRequest, T> g) {
        return obj -> g.apply((MergePullRequestByFastForwardRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, MergePullRequestByFastForwardRequest> {
        /**
         * <p>
         * The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.
         * </p>
         * 
         * @param pullRequestId
         *        The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pullRequestId(String pullRequestId);

        /**
         * <p>
         * The name of the repository where the pull request was created.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository where the pull request was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The full commit ID of the original or updated commit in the pull request source branch. Pass this value if
         * you want an exception thrown if the current commit ID of the tip of the source branch does not match this
         * commit ID.
         * </p>
         * 
         * @param sourceCommitId
         *        The full commit ID of the original or updated commit in the pull request source branch. Pass this
         *        value if you want an exception thrown if the current commit ID of the tip of the source branch does
         *        not match this commit ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCommitId(String sourceCommitId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeCommitRequest.BuilderImpl implements Builder {
        private String pullRequestId;

        private String repositoryName;

        private String sourceCommitId;

        private BuilderImpl() {
        }

        private BuilderImpl(MergePullRequestByFastForwardRequest model) {
            super(model);
            pullRequestId(model.pullRequestId);
            repositoryName(model.repositoryName);
            sourceCommitId(model.sourceCommitId);
        }

        public final String getPullRequestId() {
            return pullRequestId;
        }

        public final void setPullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
        }

        @Override
        @Transient
        public final Builder pullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
            return this;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        @Transient
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getSourceCommitId() {
            return sourceCommitId;
        }

        public final void setSourceCommitId(String sourceCommitId) {
            this.sourceCommitId = sourceCommitId;
        }

        @Override
        @Transient
        public final Builder sourceCommitId(String sourceCommitId) {
            this.sourceCommitId = sourceCommitId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public MergePullRequestByFastForwardRequest build() {
            return new MergePullRequestByFastForwardRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
