/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a source file that is part of changes made in a commit.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceFileSpecifier implements SdkPojo, Serializable,
        ToCopyableBuilder<SourceFileSpecifier.Builder, SourceFileSpecifier> {
    private static final SdkField<String> FILE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filePath").getter(getter(SourceFileSpecifier::filePath)).setter(setter(Builder::filePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePath").build()).build();

    private static final SdkField<Boolean> IS_MOVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isMove").getter(getter(SourceFileSpecifier::isMove)).setter(setter(Builder::isMove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isMove").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(FILE_PATH_FIELD, IS_MOVE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String filePath;

    private final Boolean isMove;

    private SourceFileSpecifier(BuilderImpl builder) {
        this.filePath = builder.filePath;
        this.isMove = builder.isMove;
    }

    /**
     * <p>
     * The full path to the file, including the name of the file.
     * </p>
     * 
     * @return The full path to the file, including the name of the file.
     */
    public final String filePath() {
        return filePath;
    }

    /**
     * <p>
     * Whether to remove the source file from the parent commit.
     * </p>
     * 
     * @return Whether to remove the source file from the parent commit.
     */
    public final Boolean isMove() {
        return isMove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filePath());
        hashCode = 31 * hashCode + Objects.hashCode(isMove());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceFileSpecifier)) {
            return false;
        }
        SourceFileSpecifier other = (SourceFileSpecifier) obj;
        return Objects.equals(filePath(), other.filePath()) && Objects.equals(isMove(), other.isMove());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceFileSpecifier").add("FilePath", filePath()).add("IsMove", isMove()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filePath":
            return Optional.ofNullable(clazz.cast(filePath()));
        case "isMove":
            return Optional.ofNullable(clazz.cast(isMove()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceFileSpecifier, T> g) {
        return obj -> g.apply((SourceFileSpecifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceFileSpecifier> {
        /**
         * <p>
         * The full path to the file, including the name of the file.
         * </p>
         * 
         * @param filePath
         *        The full path to the file, including the name of the file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filePath(String filePath);

        /**
         * <p>
         * Whether to remove the source file from the parent commit.
         * </p>
         * 
         * @param isMove
         *        Whether to remove the source file from the parent commit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isMove(Boolean isMove);
    }

    static final class BuilderImpl implements Builder {
        private String filePath;

        private Boolean isMove;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceFileSpecifier model) {
            filePath(model.filePath);
            isMove(model.isMove);
        }

        public final String getFilePath() {
            return filePath;
        }

        public final void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        @Override
        @Transient
        public final Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public final Boolean getIsMove() {
            return isMove;
        }

        public final void setIsMove(Boolean isMove) {
            this.isMove = isMove;
        }

        @Override
        @Transient
        public final Builder isMove(Boolean isMove) {
            this.isMove = isMove;
            return this;
        }

        @Override
        public SourceFileSpecifier build() {
            return new SourceFileSpecifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
