/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateApprovalRuleTemplateContentRequest extends CodeCommitRequest implements
        ToCopyableBuilder<UpdateApprovalRuleTemplateContentRequest.Builder, UpdateApprovalRuleTemplateContentRequest> {
    private static final SdkField<String> APPROVAL_RULE_TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("approvalRuleTemplateName")
            .getter(getter(UpdateApprovalRuleTemplateContentRequest::approvalRuleTemplateName))
            .setter(setter(Builder::approvalRuleTemplateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRuleTemplateName").build())
            .build();

    private static final SdkField<String> NEW_RULE_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("newRuleContent").getter(getter(UpdateApprovalRuleTemplateContentRequest::newRuleContent))
            .setter(setter(Builder::newRuleContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newRuleContent").build()).build();

    private static final SdkField<String> EXISTING_RULE_CONTENT_SHA256_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("existingRuleContentSha256")
            .getter(getter(UpdateApprovalRuleTemplateContentRequest::existingRuleContentSha256))
            .setter(setter(Builder::existingRuleContentSha256))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("existingRuleContentSha256").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            APPROVAL_RULE_TEMPLATE_NAME_FIELD, NEW_RULE_CONTENT_FIELD, EXISTING_RULE_CONTENT_SHA256_FIELD));

    private final String approvalRuleTemplateName;

    private final String newRuleContent;

    private final String existingRuleContentSha256;

    private UpdateApprovalRuleTemplateContentRequest(BuilderImpl builder) {
        super(builder);
        this.approvalRuleTemplateName = builder.approvalRuleTemplateName;
        this.newRuleContent = builder.newRuleContent;
        this.existingRuleContentSha256 = builder.existingRuleContentSha256;
    }

    /**
     * <p>
     * The name of the approval rule template where you want to update the content of the rule.
     * </p>
     * 
     * @return The name of the approval rule template where you want to update the content of the rule.
     */
    public final String approvalRuleTemplateName() {
        return approvalRuleTemplateName;
    }

    /**
     * <p>
     * The content that replaces the existing content of the rule. Content statements must be complete. You cannot
     * provide only the changes.
     * </p>
     * 
     * @return The content that replaces the existing content of the rule. Content statements must be complete. You
     *         cannot provide only the changes.
     */
    public final String newRuleContent() {
        return newRuleContent;
    }

    /**
     * <p>
     * The SHA-256 hash signature for the content of the approval rule. You can retrieve this information by using
     * <a>GetPullRequest</a>.
     * </p>
     * 
     * @return The SHA-256 hash signature for the content of the approval rule. You can retrieve this information by
     *         using <a>GetPullRequest</a>.
     */
    public final String existingRuleContentSha256() {
        return existingRuleContentSha256;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(approvalRuleTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(newRuleContent());
        hashCode = 31 * hashCode + Objects.hashCode(existingRuleContentSha256());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApprovalRuleTemplateContentRequest)) {
            return false;
        }
        UpdateApprovalRuleTemplateContentRequest other = (UpdateApprovalRuleTemplateContentRequest) obj;
        return Objects.equals(approvalRuleTemplateName(), other.approvalRuleTemplateName())
                && Objects.equals(newRuleContent(), other.newRuleContent())
                && Objects.equals(existingRuleContentSha256(), other.existingRuleContentSha256());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateApprovalRuleTemplateContentRequest")
                .add("ApprovalRuleTemplateName", approvalRuleTemplateName()).add("NewRuleContent", newRuleContent())
                .add("ExistingRuleContentSha256", existingRuleContentSha256()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "approvalRuleTemplateName":
            return Optional.ofNullable(clazz.cast(approvalRuleTemplateName()));
        case "newRuleContent":
            return Optional.ofNullable(clazz.cast(newRuleContent()));
        case "existingRuleContentSha256":
            return Optional.ofNullable(clazz.cast(existingRuleContentSha256()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateApprovalRuleTemplateContentRequest, T> g) {
        return obj -> g.apply((UpdateApprovalRuleTemplateContentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateApprovalRuleTemplateContentRequest> {
        /**
         * <p>
         * The name of the approval rule template where you want to update the content of the rule.
         * </p>
         * 
         * @param approvalRuleTemplateName
         *        The name of the approval rule template where you want to update the content of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalRuleTemplateName(String approvalRuleTemplateName);

        /**
         * <p>
         * The content that replaces the existing content of the rule. Content statements must be complete. You cannot
         * provide only the changes.
         * </p>
         * 
         * @param newRuleContent
         *        The content that replaces the existing content of the rule. Content statements must be complete. You
         *        cannot provide only the changes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newRuleContent(String newRuleContent);

        /**
         * <p>
         * The SHA-256 hash signature for the content of the approval rule. You can retrieve this information by using
         * <a>GetPullRequest</a>.
         * </p>
         * 
         * @param existingRuleContentSha256
         *        The SHA-256 hash signature for the content of the approval rule. You can retrieve this information by
         *        using <a>GetPullRequest</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder existingRuleContentSha256(String existingRuleContentSha256);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeCommitRequest.BuilderImpl implements Builder {
        private String approvalRuleTemplateName;

        private String newRuleContent;

        private String existingRuleContentSha256;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApprovalRuleTemplateContentRequest model) {
            super(model);
            approvalRuleTemplateName(model.approvalRuleTemplateName);
            newRuleContent(model.newRuleContent);
            existingRuleContentSha256(model.existingRuleContentSha256);
        }

        public final String getApprovalRuleTemplateName() {
            return approvalRuleTemplateName;
        }

        public final void setApprovalRuleTemplateName(String approvalRuleTemplateName) {
            this.approvalRuleTemplateName = approvalRuleTemplateName;
        }

        @Override
        @Transient
        public final Builder approvalRuleTemplateName(String approvalRuleTemplateName) {
            this.approvalRuleTemplateName = approvalRuleTemplateName;
            return this;
        }

        public final String getNewRuleContent() {
            return newRuleContent;
        }

        public final void setNewRuleContent(String newRuleContent) {
            this.newRuleContent = newRuleContent;
        }

        @Override
        @Transient
        public final Builder newRuleContent(String newRuleContent) {
            this.newRuleContent = newRuleContent;
            return this;
        }

        public final String getExistingRuleContentSha256() {
            return existingRuleContentSha256;
        }

        public final void setExistingRuleContentSha256(String existingRuleContentSha256) {
            this.existingRuleContentSha256 = existingRuleContentSha256;
        }

        @Override
        @Transient
        public final Builder existingRuleContentSha256(String existingRuleContentSha256) {
            this.existingRuleContentSha256 = existingRuleContentSha256;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApprovalRuleTemplateContentRequest build() {
            return new UpdateApprovalRuleTemplateContentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
