/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of an update repository description operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRepositoryDescriptionRequest extends CodeCommitRequest implements
        ToCopyableBuilder<UpdateRepositoryDescriptionRequest.Builder, UpdateRepositoryDescriptionRequest> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(UpdateRepositoryDescriptionRequest::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> REPOSITORY_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryDescription").getter(getter(UpdateRepositoryDescriptionRequest::repositoryDescription))
            .setter(setter(Builder::repositoryDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD,
            REPOSITORY_DESCRIPTION_FIELD));

    private final String repositoryName;

    private final String repositoryDescription;

    private UpdateRepositoryDescriptionRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.repositoryDescription = builder.repositoryDescription;
    }

    /**
     * <p>
     * The name of the repository to set or change the comment or description for.
     * </p>
     * 
     * @return The name of the repository to set or change the comment or description for.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The new comment or description for the specified repository. Repository descriptions are limited to 1,000
     * characters.
     * </p>
     * 
     * @return The new comment or description for the specified repository. Repository descriptions are limited to 1,000
     *         characters.
     */
    public final String repositoryDescription() {
        return repositoryDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRepositoryDescriptionRequest)) {
            return false;
        }
        UpdateRepositoryDescriptionRequest other = (UpdateRepositoryDescriptionRequest) obj;
        return Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(repositoryDescription(), other.repositoryDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRepositoryDescriptionRequest").add("RepositoryName", repositoryName())
                .add("RepositoryDescription", repositoryDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "repositoryDescription":
            return Optional.ofNullable(clazz.cast(repositoryDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRepositoryDescriptionRequest, T> g) {
        return obj -> g.apply((UpdateRepositoryDescriptionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateRepositoryDescriptionRequest> {
        /**
         * <p>
         * The name of the repository to set or change the comment or description for.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository to set or change the comment or description for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The new comment or description for the specified repository. Repository descriptions are limited to 1,000
         * characters.
         * </p>
         * 
         * @param repositoryDescription
         *        The new comment or description for the specified repository. Repository descriptions are limited to
         *        1,000 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryDescription(String repositoryDescription);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeCommitRequest.BuilderImpl implements Builder {
        private String repositoryName;

        private String repositoryDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRepositoryDescriptionRequest model) {
            super(model);
            repositoryName(model.repositoryName);
            repositoryDescription(model.repositoryDescription);
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        @Transient
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getRepositoryDescription() {
            return repositoryDescription;
        }

        public final void setRepositoryDescription(String repositoryDescription) {
            this.repositoryDescription = repositoryDescription;
        }

        @Override
        @Transient
        public final Builder repositoryDescription(String repositoryDescription) {
            this.repositoryDescription = repositoryDescription;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRepositoryDescriptionRequest build() {
            return new UpdateRepositoryDescriptionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
