/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeletePullRequestApprovalRuleResponse extends CodeCommitResponse implements
        ToCopyableBuilder<DeletePullRequestApprovalRuleResponse.Builder, DeletePullRequestApprovalRuleResponse> {
    private static final SdkField<String> APPROVAL_RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("approvalRuleId").getter(getter(DeletePullRequestApprovalRuleResponse::approvalRuleId))
            .setter(setter(Builder::approvalRuleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRuleId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPROVAL_RULE_ID_FIELD));

    private final String approvalRuleId;

    private DeletePullRequestApprovalRuleResponse(BuilderImpl builder) {
        super(builder);
        this.approvalRuleId = builder.approvalRuleId;
    }

    /**
     * <p>
     * The ID of the deleted approval rule.
     * </p>
     * <note>
     * <p>
     * If the approval rule was deleted in an earlier API call, the response is 200 OK without content.
     * </p>
     * </note>
     * 
     * @return The ID of the deleted approval rule. </p> <note>
     *         <p>
     *         If the approval rule was deleted in an earlier API call, the response is 200 OK without content.
     *         </p>
     */
    public final String approvalRuleId() {
        return approvalRuleId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(approvalRuleId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePullRequestApprovalRuleResponse)) {
            return false;
        }
        DeletePullRequestApprovalRuleResponse other = (DeletePullRequestApprovalRuleResponse) obj;
        return Objects.equals(approvalRuleId(), other.approvalRuleId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeletePullRequestApprovalRuleResponse").add("ApprovalRuleId", approvalRuleId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "approvalRuleId":
            return Optional.ofNullable(clazz.cast(approvalRuleId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeletePullRequestApprovalRuleResponse, T> g) {
        return obj -> g.apply((DeletePullRequestApprovalRuleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeletePullRequestApprovalRuleResponse> {
        /**
         * <p>
         * The ID of the deleted approval rule.
         * </p>
         * <note>
         * <p>
         * If the approval rule was deleted in an earlier API call, the response is 200 OK without content.
         * </p>
         * </note>
         * 
         * @param approvalRuleId
         *        The ID of the deleted approval rule. </p> <note>
         *        <p>
         *        If the approval rule was deleted in an earlier API call, the response is 200 OK without content.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalRuleId(String approvalRuleId);
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private String approvalRuleId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletePullRequestApprovalRuleResponse model) {
            super(model);
            approvalRuleId(model.approvalRuleId);
        }

        public final String getApprovalRuleId() {
            return approvalRuleId;
        }

        public final void setApprovalRuleId(String approvalRuleId) {
            this.approvalRuleId = approvalRuleId;
        }

        @Override
        @Transient
        public final Builder approvalRuleId(String approvalRuleId) {
            this.approvalRuleId = approvalRuleId;
            return this;
        }

        @Override
        public DeletePullRequestApprovalRuleResponse build() {
            return new DeletePullRequestApprovalRuleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
